/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.decorator;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.decorator.JCRProtectedNodeAbstractDecorator;
import org.jahia.services.pwd.PasswordService;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyService;
import org.jahia.services.pwdpolicy.PasswordHistoryEntry;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserImpl;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRUserNode
extends JCRProtectedNodeAbstractDecorator {
    private static transient Logger logger = LoggerFactory.getLogger(JCRUserNode.class);
    public static final String ROOT_USER_UUID = "b32d306a-6c74-11de-b3ef-001e4fead50b";
    public static final String PROVIDER_NAME = "jcr";
    public static final String J_DISPLAYABLE_NAME = "j:displayableName";
    public static final String J_PASSWORD = "j:password";
    public static final String J_EXTERNAL = "j:external";
    public static final String J_EXTERNAL_SOURCE = "j:externalSource";
    private static final String J_PUBLIC_PROPERTIES = "j:publicProperties";
    public final List<String> publicProperties = Arrays.asList("j:external", "j:externalSource", "j:publicProperties");

    public JCRUserNode(JCRNodeWrapper node) {
        super(node);
    }

    public JahiaUser getJahiaUser() {
        Properties properties = new Properties();
        try {
            properties.putAll(this.getPropertiesAsString());
        }
        catch (RepositoryException e) {
            logger.error("Cannot read user properties", (Throwable)e);
        }
        return new JahiaUserImpl(this.getName(), this.getPath(), properties, this.isRoot(), this.getProviderName(), this.getRealm());
    }

    public String getUsername() {
        return this.getName();
    }

    public String getUserKey() {
        return this.getPath();
    }

    public String getProviderName() {
        return this.getProvider().getKey();
    }

    public boolean isPropertyEditable(String name) {
        try {
            return !J_EXTERNAL.equals(name) && !"j:checkinDate".equals(name) && this.canReadProperty(name);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean isRoot() {
        try {
            return this.getIdentifier().equals(ROOT_USER_UUID);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    protected boolean canReadProperty(String s) throws RepositoryException {
        Value[] values;
        if (this.publicProperties.contains(s) || JahiaUserManagerService.isGuest(this) || this.node.hasPermission("jcr:write")) {
            return true;
        }
        if (this.node.hasProperty(s) && !"jnt:user".equals(this.node.getProperty(s).getDefinition().getDeclaringNodeType().getName())) {
            return true;
        }
        if (!this.node.hasProperty(J_PUBLIC_PROPERTIES)) {
            return false;
        }
        JCRPropertyWrapper p = this.node.getProperty(J_PUBLIC_PROPERTIES);
        for (Value value : values = p.getValues()) {
            if (!s.equals(value.getString())) continue;
            return true;
        }
        return false;
    }

    public boolean verifyPassword(String userPassword) {
        try {
            return StringUtils.isNotEmpty((String)userPassword) && PasswordService.getInstance().matches(userPassword, this.getProperty(J_PASSWORD).getString());
        }
        catch (RepositoryException e) {
            logger.debug("Password verification failed for user " + this.getName(), (Throwable)e);
            return false;
        }
    }

    public boolean setPassword(String pwd) {
        try {
            this.setProperty(J_PASSWORD, PasswordService.getInstance().digest(pwd, this.isRoot()));
            return true;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isAccountLocked() {
        try {
            return !this.isRoot() && this.hasProperty("j:accountLocked") && this.getProperty("j:accountLocked").getBoolean();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List<PasswordHistoryEntry> getPasswordHistory() {
        return JahiaPasswordPolicyService.getInstance().getPasswordHistory(this);
    }

    public long getLastPasswordChangeTimestamp() {
        List<PasswordHistoryEntry> pwdHistory = this.getPasswordHistory();
        return pwdHistory.size() > 0 ? pwdHistory.get(0).getModificationDate().getTime() : 0L;
    }

    public boolean isMemberOfGroup(String siteKey, String name) {
        return "guest".equals(name) || "users".equals(name) || "site-users".equals(name) && (this.getRealm() == null || this.getRealm().equals(siteKey)) || this.isRoot() && JahiaGroupManagerService.POWERFUL_GROUPS.contains(name) || JahiaGroupManagerService.getInstance().isMember(this.getName(), this.getRealm(), name, siteKey);
    }

    public String getRealm() {
        return this.getPath().startsWith("/sites/") ? StringUtils.substringBetween((String)this.getPath(), (String)"/sites/", (String)"/") : null;
    }

    public String getLocalPath() {
        return this.getPath();
    }

    @Override
    public String getDisplayableName() {
        try {
            return this.getDisplayableName(this.getSession().getLocale());
        }
        catch (RepositoryException e) {
            logger.error("", (Throwable)e);
            return super.getDisplayableName();
        }
    }

    public String getDisplayableName(Locale locale) {
        String userName = this.getName();
        if ("guest".equals(userName)) {
            Locale l = locale;
            if (l == null) {
                try {
                    l = this.getSession().getLocale();
                }
                catch (RepositoryException e) {
                    logger.error("", (Throwable)e);
                }
                if (l == null) {
                    l = SettingsBean.getInstance().getDefaultLocale();
                }
                if (l == null) {
                    l = Locale.ENGLISH;
                }
            }
            return Messages.get(ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackage(SettingsBean.getInstance().getGuestUserResourceModuleName()), SettingsBean.getInstance().getGuestUserResourceKey(), l, userName);
        }
        return super.getDisplayableName();
    }
}

