/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.files;

import java.util.Map;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheFactory;
import org.jahia.services.content.files.FileCacheEntry;
import org.jahia.services.content.files.FileKey;
import org.jahia.services.content.files.FileLastModifiedCacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheManager {
    public static final String CONTENT_CACHE_NAME = "FileContentCache";
    public static final String LAST_MODIFIED_CACHE_NAME = "FileLastModifiedCache";
    private static Logger logger = LoggerFactory.getLogger(FileCacheManager.class);
    private CacheFactory cacheFactory;
    private Cache<String, Map<String, FileCacheEntry>> contentCache;
    private Cache<String, FileLastModifiedCacheEntry> lastModifiedCache;

    public static FileCacheManager getInstance() {
        return (FileCacheManager)SpringContextSingleton.getBean("FileCacheManager");
    }

    private FileCacheManager() {
    }

    public Cache<String, Map<String, FileCacheEntry>> getContentCache() {
        if (this.contentCache == null) {
            try {
                this.contentCache = this.cacheFactory.getCache(CONTENT_CACHE_NAME, true);
            }
            catch (JahiaInitializationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new JahiaRuntimeException(e);
            }
        }
        return this.contentCache;
    }

    public Cache<String, FileLastModifiedCacheEntry> getLastModifiedCache() {
        if (this.lastModifiedCache == null) {
            try {
                this.lastModifiedCache = this.cacheFactory.getCache(LAST_MODIFIED_CACHE_NAME, true);
            }
            catch (JahiaInitializationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new JahiaRuntimeException(e);
            }
        }
        return this.lastModifiedCache;
    }

    public void invalidate(FileKey key) {
        this.getContentCache().remove(key.getCacheKey());
        this.getLastModifiedCache().remove(key.getCacheKey());
    }

    public void invalidate(String workspace, String nodePath) {
        this.invalidate(new FileKey(workspace, nodePath));
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }
}

