/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.jahia.bin.Jahia;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.PropertyConstraintViolationException;
import org.jahia.services.content.interceptor.BaseInterceptor;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.HtmlTagAttributeTraverser;
import org.jahia.utils.WebUtils;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.i18n.LocaleContextHolder;

public class URLInterceptor
extends BaseInterceptor
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(URLInterceptor.class);
    private String dmsContext;
    private String cmsContext;
    private static final String DOC_CONTEXT_PLACEHOLDER = "##doc-context##/";
    private static final String CMS_CONTEXT_PLACEHOLDER = "##cms-context##/";
    private static final Pattern DOC_CONTEXT_PLACEHOLDER_PATTERN = Pattern.compile("##doc-context##/", 16);
    private static final Pattern CMS_CONTEXT_PLACEHOLDER_PATTERN = Pattern.compile("##cms-context##/", 16);
    private Pattern cmsPattern;
    private Pattern cmsPatternWithContextPlaceholder;
    private Pattern refPattern;
    private HtmlTagAttributeTraverser urlTraverser;

    private String escape(String s) {
        s = s.replace("{", "\\{");
        s = s.replace("}", "\\}");
        return s;
    }

    public URLInterceptor(HtmlTagAttributeTraverser urlTraverser) {
        this.urlTraverser = urlTraverser;
    }

    @Override
    public void beforeRemove(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (node.isNodeType("jmix:referencesInField")) {
            JCRNodeIteratorWrapper ni = node.getNodes("j:referenceInField*");
            if (definition.isInternationalized()) {
                name = name + "_" + node.getSession().getLocale();
            }
            while (ni.hasNext()) {
                JCRNodeWrapper ref = (JCRNodeWrapper)ni.next();
                if (!name.equals(ref.getProperty("j:fieldName").getString())) continue;
                ref.remove();
            }
        }
    }

    @Override
    public Value beforeSetValue(final JCRNodeWrapper node, String name, final ExtendedPropertyDefinition definition, Value originalValue) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        String result;
        JCRNodeWrapper nodeWithReferences;
        String content = originalValue.getString();
        JCRNodeWrapper jCRNodeWrapper = nodeWithReferences = node.isNodeType("jnt:translation") ? node.getParent() : node;
        if (definition.isInternationalized()) {
            Locale locale = node.getSession().getLocale();
            if (locale == null) {
                if (node.isNodeType("jnt:translation")) {
                    name = name + "_" + node.getProperty("jcr:language").getString();
                }
            } else {
                name = name + "_" + locale;
            }
        }
        final HashMap<String, Long> refs = new HashMap<String, Long>();
        if (logger.isDebugEnabled()) {
            logger.debug("Intercept setValue for " + node.getPath() + "/" + name);
        }
        if (nodeWithReferences.isNodeType("jmix:referencesInField")) {
            JCRNodeIteratorWrapper ni = nodeWithReferences.getNodes("j:referenceInField*");
            while (ni.hasNext()) {
                JCRNodeWrapper ref = (JCRNodeWrapper)ni.next();
                if (!name.equals(ref.getProperty("j:fieldName").getString()) || !ref.hasProperty("j:reference")) continue;
                refs.put(ref.getProperty("j:reference").getString(), Long.valueOf(StringUtils.substringAfterLast((String)ref.getName(), (String)"_")));
            }
        }
        final HashMap newRefs = new HashMap();
        try {
            result = this.urlTraverser.traverse(content, new HtmlTagAttributeTraverser.HtmlTagAttributeVisitor(){

                @Override
                public String visit(String value, RenderContext context, String tagName, String attrName, Resource resource) {
                    if (StringUtils.isNotEmpty((String)value)) {
                        try {
                            value = URLInterceptor.this.replaceRefsByPlaceholders(value, newRefs, refs, node.getSession().getWorkspace().getName(), node.getSession().getLocale(), node, definition);
                        }
                        catch (RepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return value;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RepositoryException) {
                throw (RepositoryException)e.getCause();
            }
            throw e;
        }
        HashSet<String> refsToRemove = new HashSet<String>(refs.size());
        if (!newRefs.equals(refs)) {
            if (!newRefs.isEmpty() && !nodeWithReferences.isNodeType("jmix:referencesInField")) {
                nodeWithReferences.addMixin("jmix:referencesInField");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("New references : " + newRefs);
            }
            JCRNodeIteratorWrapper ni = nodeWithReferences.getNodes("j:referenceInField*");
            while (ni.hasNext()) {
                JCRNodeWrapper ref = (JCRNodeWrapper)ni.next();
                if (!name.equals(ref.getProperty("j:fieldName").getString()) || ref.hasProperty("j:reference") && newRefs.containsKey(ref.getProperty("j:reference").getString())) continue;
                refsToRemove.add(ref.getName());
            }
            for (Map.Entry entry : newRefs.entrySet()) {
                if (refs.containsKey(entry.getKey())) continue;
                JCRNodeWrapper ref = nodeWithReferences.addNode("j:referenceInField_" + Text.escapeIllegalJcrChars((String)name) + "_" + entry.getValue(), "jnt:referenceInField");
                ref.setProperty("j:fieldName", name);
                ref.setProperty("j:reference", (String)entry.getKey());
            }
        }
        for (String refToRemove : refsToRemove) {
            nodeWithReferences.getNode(refToRemove).remove();
        }
        if (!result.equals(content)) {
            return node.getSession().getValueFactory().createValue(result);
        }
        return originalValue;
    }

    @Override
    public Value[] beforeSetValues(JCRNodeWrapper node, String name, ExtendedPropertyDefinition definition, Value[] originalValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] res = new Value[originalValues.length];
        for (int i = 0; i < originalValues.length; ++i) {
            Value originalValue = originalValues[i];
            res[i] = this.beforeSetValue(node, name, definition, originalValue);
        }
        return res;
    }

    @Override
    public Value afterGetValue(final JCRPropertyWrapper property, Value storedValue) throws ValueFormatException, RepositoryException {
        String result;
        String content = storedValue.getString();
        if (content == null || !content.contains(DOC_CONTEXT_PLACEHOLDER) && !content.contains(CMS_CONTEXT_PLACEHOLDER)) {
            return storedValue;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Intercept getValue for " + property.getPath());
        }
        final HashMap<Long, String> refs = new HashMap<Long, String>();
        ExtendedPropertyDefinition definition = (ExtendedPropertyDefinition)property.getDefinition();
        String name = definition.getName();
        JCRNodeWrapper parent = property.getParent();
        if (definition.isInternationalized()) {
            name = name + "_" + property.getLocale();
        }
        if (parent.isNodeType("jnt:translation")) {
            parent = parent.getParent();
        }
        if (parent.isNodeType("jmix:referencesInField")) {
            JCRNodeIteratorWrapper ni = parent.getNodes("j:referenceInField*");
            while (ni.hasNext()) {
                JCRNodeWrapper ref = (JCRNodeWrapper)ni.next();
                if (!name.equals(ref.getProperty("j:fieldName").getString()) || !ref.hasProperty("j:reference")) continue;
                try {
                    refs.put(Long.valueOf(StringUtils.substringAfterLast((String)ref.getName(), (String)"_")), ref.getProperty("j:reference").getString());
                }
                catch (PathNotFoundException e) {
                    logger.warn("Unable to get j:reference field on the node {}. Skipping reference.", (Object)ref.getPath());
                }
            }
        }
        try {
            result = this.urlTraverser.traverse(content, new HtmlTagAttributeTraverser.HtmlTagAttributeVisitor(){

                @Override
                public String visit(String value, RenderContext context, String tagName, String attrName, Resource resource) {
                    if (StringUtils.isNotEmpty((String)value)) {
                        try {
                            value = URLInterceptor.this.replacePlaceholdersByRefs(value, refs, property.getSession().getWorkspace().getName(), property.getSession().getLocale(), property.getParent());
                            if ("#".equals(value) && attrName.toLowerCase().equals("src") && tagName.toLowerCase().equals("img")) {
                                value = "/missing-image.png";
                            }
                        }
                        catch (RepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return value;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RepositoryException) {
                throw (RepositoryException)e.getCause();
            }
            throw e;
        }
        if (!result.equals(content)) {
            return property.getSession().getValueFactory().createValue(result);
        }
        return storedValue;
    }

    @Override
    public Value[] afterGetValues(JCRPropertyWrapper property, Value[] storedValues) throws ValueFormatException, RepositoryException {
        Value[] res = new Value[storedValues.length];
        for (int i = 0; i < storedValues.length; ++i) {
            Value storedValue = storedValues[i];
            res[i] = this.afterGetValue(property, storedValue);
        }
        return res;
    }

    private String replaceRefsByPlaceholders(final String originalValue, final Map<String, Long> newRefs, final Map<String, Long> oldRefs, String workspace, final Locale locale, final JCRNodeWrapper node, final ExtendedPropertyDefinition definition) throws RepositoryException {
        boolean isCmsContext;
        String pathPart;
        if (logger.isDebugEnabled()) {
            logger.debug("Before replaceRefsByPlaceholders : " + originalValue);
        }
        if ((pathPart = originalValue).startsWith(this.dmsContext)) {
            pathPart = StringUtils.substringAfter((String)StringUtils.substringAfter((String)pathPart, (String)this.dmsContext), (String)"/");
            isCmsContext = false;
        } else if (pathPart.startsWith(this.cmsContext)) {
            Matcher m = this.cmsPattern.matcher(pathPart);
            if (!m.matches()) {
                throw new PropertyConstraintViolationException(node, Messages.getInternal("label.error.invalidlink", LocaleContextHolder.getLocale(), "Invalid link") + pathPart, definition.isInternationalized() ? locale : null, definition);
            }
            pathPart = m.group(5);
            isCmsContext = true;
        } else {
            return originalValue;
        }
        final String path = "/" + WebUtils.urlDecode(pathPart);
        return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, null, new JCRCallback<String>(){

            @Override
            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper reference;
                String value = originalValue;
                String ext = null;
                String tpl = null;
                try {
                    String currentPath = path;
                    if (isCmsContext) {
                        while (true) {
                            int i;
                            if ((i = currentPath.lastIndexOf(46)) > currentPath.lastIndexOf(47)) {
                                if (ext == null) {
                                    ext = currentPath.substring(i + 1);
                                } else {
                                    tpl = tpl == null ? currentPath.substring(i + 1) : currentPath.substring(i + 1) + "." + tpl;
                                }
                            } else {
                                throw new PathNotFoundException("not found in " + path);
                            }
                            currentPath = currentPath.substring(0, i);
                            try {
                                reference = session.getNode(JCRContentUtils.escapeNodePath(currentPath));
                            }
                            catch (PathNotFoundException pathNotFoundException) {
                                continue;
                            }
                            break;
                        }
                        value = URLInterceptor.CMS_CONTEXT_PLACEHOLDER + StringUtils.substringAfter((String)value, (String)URLInterceptor.this.cmsContext);
                    } else {
                        while (true) {
                            if (!StringUtils.contains((String)currentPath, (char)'/')) {
                                throw new PathNotFoundException("not found in " + path);
                            }
                            currentPath = StringUtils.substringAfter((String)currentPath, (String)"/");
                            try {
                                reference = session.getNode(JCRContentUtils.escapeNodePath("/" + currentPath));
                            }
                            catch (PathNotFoundException i) {
                                continue;
                            }
                            break;
                        }
                        value = URLInterceptor.DOC_CONTEXT_PLACEHOLDER + StringUtils.substringAfter((String)value, (String)URLInterceptor.this.dmsContext);
                    }
                }
                catch (PathNotFoundException e) {
                    throw new PropertyConstraintViolationException(node, Messages.getInternal("label.error.invalidlink", LocaleContextHolder.getLocale(), "Invalid link") + path, definition.isInternationalized() ? locale : null, definition);
                }
                String id = reference.getIdentifier();
                if (!newRefs.containsKey(id)) {
                    if (oldRefs.containsKey(id)) {
                        newRefs.put(id, oldRefs.get(id));
                    } else {
                        Long max = Math.max(oldRefs.isEmpty() ? 0L : (Long)Collections.max(oldRefs.values()), newRefs.isEmpty() ? 0L : (Long)Collections.max(newRefs.values()));
                        newRefs.put(id, max + 1L);
                    }
                }
                Long index = (Long)newRefs.get(id);
                String link = "/##ref:link" + index + "##";
                if (tpl != null) {
                    link = link + "." + tpl;
                }
                if (ext != null) {
                    link = link + "." + ext;
                }
                value = WebUtils.urlDecode(value).replace(path, link);
                if (logger.isDebugEnabled()) {
                    logger.debug("After replaceRefsByPlaceholders : " + value);
                }
                return value;
            }
        });
    }

    private String replacePlaceholdersByRefs(final String originalValue, final Map<Long, String> refs, String workspaceName, Locale locale, final JCRNodeWrapper parent) throws RepositoryException {
        boolean isCmsContext;
        String pathPart = originalValue;
        if (logger.isDebugEnabled()) {
            logger.debug("Before replacePlaceholdersByRefs : " + originalValue);
        }
        if (pathPart.startsWith(DOC_CONTEXT_PLACEHOLDER)) {
            pathPart = StringUtils.substringAfter((String)StringUtils.substringAfter((String)pathPart, (String)DOC_CONTEXT_PLACEHOLDER), (String)"/");
            isCmsContext = false;
        } else if (pathPart.startsWith(CMS_CONTEXT_PLACEHOLDER)) {
            Matcher m = this.cmsPatternWithContextPlaceholder.matcher(pathPart);
            if (!m.matches()) {
                logger.error("Cannot match URL : " + pathPart);
                return originalValue;
            }
            pathPart = m.group(5);
            isCmsContext = true;
        } else {
            return originalValue;
        }
        final String path = "/" + pathPart;
        return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspaceName, null, new JCRCallback<String>(){

            @Override
            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                String value = originalValue;
                try {
                    Matcher matcher = URLInterceptor.this.refPattern.matcher(path);
                    if (!matcher.matches()) {
                        logger.error("Cannot match value, should contain ##ref : " + path);
                        return originalValue;
                    }
                    String id = matcher.group(1);
                    String ext = matcher.group(2);
                    String uuid = (String)refs.get(new Long(id));
                    String nodePath = null;
                    JCRNodeWrapper node = null;
                    if (!StringUtils.isEmpty((String)uuid)) {
                        try {
                            node = session.getNodeByUUID(uuid);
                        }
                        catch (ItemNotFoundException itemNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (node == null) {
                        logger.warn("Cannot find referenced item : " + parent.getPath() + " -> " + path + " -> " + uuid);
                        return "#";
                    }
                    nodePath = Text.escapePath((String)node.getPath());
                    value = originalValue.replace(path, nodePath + ext);
                    value = isCmsContext ? CMS_CONTEXT_PLACEHOLDER_PATTERN.matcher(value).replaceAll(URLInterceptor.this.cmsContext) : DOC_CONTEXT_PLACEHOLDER_PATTERN.matcher(value).replaceAll(URLInterceptor.this.dmsContext);
                    if (logger.isDebugEnabled()) {
                        logger.debug("After replacePlaceholdersByRefs : " + value);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception when transforming placeholder for " + parent.getPath() + " -> " + path, (Throwable)e);
                }
                return value;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.dmsContext = Jahia.getContextPath() + "/files/";
        this.cmsContext = Jahia.getContextPath() + "/cms/";
        String pattern = "(((render|edit|live|contribute)/[a-zA-Z]+)|" + this.escape("{mode}") + ")/([a-zA-Z_]+|" + this.escape("{lang}") + ")/(.*)";
        this.refPattern = Pattern.compile("/##ref:link([0-9]+)##(.*)");
        this.cmsPattern = Pattern.compile(this.cmsContext + pattern);
        this.cmsPatternWithContextPlaceholder = Pattern.compile(this.escape(CMS_CONTEXT_PLACEHOLDER) + pattern);
    }
}

