/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.nodetypes.initializers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.content.nodetypes.renderer.AbstractChoiceListRenderer;
import org.jahia.services.render.RenderContext;

public class CountryChoiceListInitializerAndRendererImpl
extends AbstractChoiceListRenderer
implements ChoiceListInitializer {
    @Override
    public List<ChoiceListValue> getChoiceListValues(ExtendedPropertyDefinition declaringPropertyDefinition, String param, List<ChoiceListValue> values, Locale locale, Map<String, Object> context) {
        String[] iso = Locale.getISOCountries();
        ArrayList<ChoiceListValue> l = new ArrayList<ChoiceListValue>(iso.length);
        for (String anIso : iso) {
            l.add(new ChoiceListValue(new Locale("en", anIso).getDisplayCountry(locale), null, new ValueImpl(anIso, 1, false)));
        }
        Collections.sort(l);
        return l;
    }

    @Override
    public String getStringRendering(RenderContext context, JCRPropertyWrapper propertyWrapper) throws RepositoryException {
        String rendering = propertyWrapper.isMultiple() ? new Locale("en", propertyWrapper.getValues()[0].getString()).getDisplayCountry(context.getMainResource().getLocale()) : new Locale("en", propertyWrapper.getValue().getString()).getDisplayCountry(context.getMainResource().getLocale());
        return rendering;
    }

    @Override
    public String getStringRendering(Locale locale, ExtendedPropertyDefinition propDef, Object propertyValue) throws RepositoryException {
        return new Locale("en", propertyValue.toString()).getDisplayCountry(locale);
    }
}

