/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import javax.jcr.RepositoryException;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.ChangedPropertyFact;

public class DeletedPropertyFact {
    private String nodePath;
    private AddedNodeFact node;
    private String name;

    public DeletedPropertyFact(ChangedPropertyFact property, KnowledgeHelper drools) throws RepositoryException {
        this.name = property.getName();
        this.node = property.getNode();
        this.nodePath = this.node.getPath();
        property.getProperty().remove();
        drools.retract((Object)property);
    }

    public DeletedPropertyFact(AddedNodeFact node, String property) throws RepositoryException {
        this.node = node;
        this.nodePath = node.getPath();
        this.name = property;
    }

    public String getName() {
        return this.name;
    }

    public AddedNodeFact getNode() {
        return this.node;
    }

    public String toString() {
        return "deleted " + this.nodePath + "/" + this.name;
    }

    public String getOperationType() {
        return this.node.getOperationType();
    }
}

