/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.files.FileCacheManager;
import org.jahia.services.content.rules.BaseBackgroundAction;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushCacheOnNodeBackgroundAction
extends BaseBackgroundAction {
    private static Logger logger = LoggerFactory.getLogger(FlushCacheOnNodeBackgroundAction.class);
    private FileCacheManager fileCacheManager = FileCacheManager.getInstance();
    private ModuleCacheProvider cacheProvider;
    private int startLevel;
    private int levelsUp;

    public void setCacheProvider(ModuleCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    @Override
    public void executeBackgroundAction(JCRNodeWrapper node) {
        String workspace = "live";
        boolean log = logger.isDebugEnabled();
        try {
            JCRNodeWrapper currentNode = node;
            workspace = node.getSession().getWorkspace().getName();
            for (int level = 0; level <= this.startLevel + this.levelsUp; ++level) {
                if (level >= this.startLevel) {
                    String path = currentNode.getPath();
                    this.cacheProvider.invalidate(path);
                    this.cacheProvider.invalidate(currentNode.getIdentifier());
                    if (log) {
                        logger.debug("Flushed output caches for node {}", (Object)path);
                    }
                    if (currentNode.isFile()) {
                        this.fileCacheManager.invalidate(workspace, path);
                        if (log) {
                            logger.debug("Flushed file cache for node {}", (Object)path);
                        }
                    }
                    this.cacheProvider.flushRegexpDependenciesOfPath(path, true);
                    if (log) {
                        logger.debug("Flushed regexp dependencies for node {}", (Object)path);
                    }
                }
                currentNode = currentNode.getParent();
            }
        }
        catch (RepositoryException e) {
            String currentNodePath = node.getPath();
            for (int level = 0; level <= this.startLevel + this.levelsUp; ++level) {
                if (level >= this.startLevel) {
                    this.cacheProvider.invalidate(currentNodePath);
                    this.fileCacheManager.invalidate(workspace, currentNodePath);
                    if (log) {
                        logger.debug("Flushed output and file caches for node {}", (Object)currentNodePath);
                    }
                    this.cacheProvider.flushRegexpDependenciesOfPath(currentNodePath, true);
                    if (log) {
                        logger.debug("Flushed regexp dependencies for node {}", (Object)currentNodePath);
                    }
                }
                currentNodePath = StringUtils.substringBeforeLast((String)currentNodePath, (String)"/");
            }
        }
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    public void setLevelsUp(int endLevel) {
        this.levelsUp = endLevel;
    }
}

