/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.history;

import org.apache.commons.lang.StringUtils;
import org.jahia.services.history.NodeVersionHistoryHelper;
import org.jahia.services.history.UnusedVersionCheckStatus;
import org.jahia.services.history.VersionHistoryCheckStatus;
import org.jahia.services.scheduler.BackgroundJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedVersionHistoryJob
extends BackgroundJob {
    private static Logger logger = LoggerFactory.getLogger(UnusedVersionHistoryJob.class);

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        JobDataMap data = jobExecutionContext.getJobDetail().getJobDataMap();
        long maxUnused = Long.parseLong(StringUtils.defaultString((String)((String)data.get((Object)"maxUnused")), (String)"0"));
        long purgeOlderThanTimestamp = this.getPurgeOlderThanTimestamp(data);
        long timer = System.currentTimeMillis();
        UnusedVersionCheckStatus status = NodeVersionHistoryHelper.checkUnused(maxUnused, true, purgeOlderThanTimestamp, null);
        logger.info("Purged unused version histories in {} ms. Status: {}", (Object[])new String[]{String.valueOf(System.currentTimeMillis() - timer), ((VersionHistoryCheckStatus)status).toString()});
    }

    private long getPurgeOlderThanTimestamp(JobDataMap data) {
        long purgeOlderThanTimestamp = 0L;
        String ageValue = (String)data.get((Object)"ageInDays");
        if (ageValue != null) {
            long age = Long.parseLong(ageValue);
            purgeOlderThanTimestamp = age > 0L ? System.currentTimeMillis() - age * 24L * 60L * 60L * 1000L : 0L;
        } else {
            ageValue = (String)data.get((Object)"age");
            if (ageValue != null) {
                long age = Long.parseLong(ageValue);
                purgeOlderThanTimestamp = age > 0L ? System.currentTimeMillis() - age : 0L;
            } else {
                ageValue = (String)data.get((Object)"ageTimestamp");
                if (ageValue != null) {
                    long age = Long.parseLong(ageValue);
                    purgeOlderThanTimestamp = age > 0L ? age : 0L;
                }
            }
        }
        return purgeOlderThanTimestamp;
    }
}

