/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.htmlvalidator;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.JahiaMultiActionController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.exceptions.JahiaUnauthorizedException;
import org.jahia.services.htmlvalidator.ValidatorResults;
import org.jahia.services.htmlvalidator.WAIValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCAGController
extends JahiaMultiActionController {
    private static final XStream JSON_SERIALIZER = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver(){

        public HierarchicalStreamWriter createWriter(Writer writer) {
            return new JsonWriter(writer, 1);
        }
    });
    private static Logger logger = LoggerFactory.getLogger(WCAGController.class);

    private String toJSON(ValidatorResults validateResults) {
        return JSON_SERIALIZER.toXML((Object)validateResults);
    }

    public void validate(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.checkUserLoggedIn();
            String text = WCAGController.getParameter(request, "text");
            Locale locale = (Locale)request.getSession(true).getAttribute("org.jahia.services.multilang.uilocale");
            Locale locale2 = locale = locale != null ? locale : request.getLocale();
            if (logger.isDebugEnabled()) {
                logger.debug("Request received for validating text using locale '{}'. Text: {}", (Object)locale, (Object)text);
            }
            ValidatorResults validateResults = new WAIValidator(locale).validate(text);
            response.setContentType("application/json; charset=UTF-8");
            String serialized = this.toJSON(validateResults);
            if (logger.isDebugEnabled()) {
                logger.debug("Validation results: {}", (Object)serialized);
            }
            response.getWriter().append(serialized);
            response.setStatus(200);
        }
        catch (JahiaUnauthorizedException ue) {
            response.sendError(401, ue.getMessage());
        }
        catch (Exception e) {
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
    }
}

