/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.image;

import java.io.File;
import java.io.IOException;
import org.jahia.services.image.Image;
import org.jahia.services.image.JahiaImageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImageService
implements JahiaImageService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractImageService.class);

    public ResizeCoords getResizeCoords(JahiaImageService.ResizeType resizeType, int sourceWidth, int sourceHeight, int targetWidth, int targetHeight) {
        int resultTargetStartPosX = 0;
        int resultTargetStartPosY = 0;
        int resultTargetWidth = targetWidth;
        int resultTargetHeight = targetHeight;
        int resultSourceWidth = sourceWidth;
        int resultSourceHeight = sourceHeight;
        int resultSourceStartPosX = 0;
        int resultSourceStartPosY = 0;
        double xScaleRatio = (double)targetWidth / (double)sourceWidth;
        double yScaleRatio = (double)targetHeight / (double)sourceHeight;
        if (!JahiaImageService.ResizeType.SCALE_TO_FILL.equals((Object)resizeType)) {
            if (JahiaImageService.ResizeType.ADJUST_SIZE.equals((Object)resizeType)) {
                if (sourceWidth > sourceHeight) {
                    resultTargetWidth = targetWidth;
                    resultTargetHeight = sourceHeight * targetWidth / sourceWidth;
                } else {
                    resultTargetWidth = sourceWidth * targetHeight / sourceHeight;
                    resultTargetHeight = targetHeight;
                }
            } else if (JahiaImageService.ResizeType.ASPECT_FIT.equals((Object)resizeType)) {
                double scaleRatio = xScaleRatio;
                if ((double)sourceHeight * scaleRatio > (double)targetHeight) {
                    scaleRatio = yScaleRatio;
                }
                resultTargetWidth = (int)((double)sourceWidth * scaleRatio);
                resultTargetHeight = (int)((double)sourceHeight * scaleRatio);
                resultTargetStartPosX = (targetWidth - resultTargetWidth) / 2;
                resultTargetStartPosY = (targetHeight - resultTargetHeight) / 2;
            } else if (JahiaImageService.ResizeType.ASPECT_FILL.equals((Object)resizeType)) {
                double scaleRatio = xScaleRatio;
                if ((double)sourceHeight * scaleRatio < (double)targetHeight) {
                    scaleRatio = yScaleRatio;
                }
                resultSourceWidth = (int)((double)targetWidth / scaleRatio);
                resultSourceHeight = (int)((double)targetHeight / scaleRatio);
                resultSourceStartPosX = (sourceWidth - resultSourceWidth) / 2;
                resultSourceStartPosY = (sourceHeight - resultSourceHeight) / 2;
            }
        }
        return new ResizeCoords(resultTargetStartPosX, resultTargetStartPosY, resultTargetWidth, resultTargetHeight, resultSourceStartPosX, resultSourceStartPosY, resultSourceWidth, resultSourceHeight);
    }

    @Override
    public boolean createThumb(Image iw, File outputFile, int size, boolean square) throws IOException {
        try {
            if (square) {
                this.resizeImage(iw, outputFile, size, size, JahiaImageService.ResizeType.ASPECT_FILL);
            } else {
                this.resizeImage(iw, outputFile, size, size, JahiaImageService.ResizeType.ADJUST_SIZE);
            }
        }
        catch (Exception e) {
            logger.error("Error creating thumbnail of size " + size + " for image " + iw.getPath() + ":" + e.getLocalizedMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("Error creating thumbnail of size " + size + " for image " + iw.getPath(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean resizeImage(Image i, File outputFile, int width, int height) throws IOException {
        return this.resizeImage(i, outputFile, width, height, JahiaImageService.ResizeType.ADJUST_SIZE);
    }

    public class ResizeCoords {
        private int targetStartPosX;
        private int targetStartPosY;
        private int targetHeight;
        private int targetWidth;
        private int sourceStartPosX;
        private int sourceStartPosY;
        private int sourceWidth;
        private int sourceHeight;

        public ResizeCoords(int targetStartPosX, int targetStartPosY, int targetWidth, int targetHeight, int sourceStartPosX, int sourceStartPosY, int sourceWidth, int sourceHeight) {
            this.targetStartPosX = targetStartPosX;
            this.targetStartPosY = targetStartPosY;
            this.targetWidth = targetWidth;
            this.targetHeight = targetHeight;
            this.sourceStartPosX = sourceStartPosX;
            this.sourceStartPosY = sourceStartPosY;
            this.sourceWidth = sourceWidth;
            this.sourceHeight = sourceHeight;
        }

        public int getTargetStartPosX() {
            return this.targetStartPosX;
        }

        public int getTargetStartPosY() {
            return this.targetStartPosY;
        }

        public int getTargetHeight() {
            return this.targetHeight;
        }

        public int getTargetWidth() {
            return this.targetWidth;
        }

        public int getSourceStartPosX() {
            return this.sourceStartPosX;
        }

        public int getSourceStartPosY() {
            return this.sourceStartPosY;
        }

        public int getSourceWidth() {
            return this.sourceWidth;
        }

        public int getSourceHeight() {
            return this.sourceHeight;
        }
    }
}

