/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tika.io.IOUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRFileNode;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.sites.JahiaSite;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ImportJob
extends BackgroundJob {
    public static final String TARGET = "target";
    public static final String CONTENT_TYPE = "contentType";
    public static final String PUBLISH_ALL_AT_END = "publishAllAtEnd";
    public static final String URI = "uri";
    public static final String DESTINATION_PARENT_PATH = "destParentPath";
    public static final String FILENAME = "filename";
    public static final String DELETE_FILE = "delete";
    public static final String ORIGINATING_JAHIA_RELEASE = "originatingJahiaRelease";
    public static final String COPY_TO_JCR = "copyToJCR";
    public static final String REPLACE_CONTENT = "replaceContent";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        JahiaSite site = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey((String)jobDataMap.get((Object)"sitekey"));
        String uri = (String)jobDataMap.get((Object)URI);
        JCRSessionWrapper session = ServicesRegistry.getInstance().getJCRStoreService().getSessionFactory().getCurrentUserSession();
        JCRFileNode f = (JCRFileNode)session.getNode(uri);
        String destinationParentPath = (String)jobDataMap.get((Object)DESTINATION_PARENT_PATH);
        if (destinationParentPath == null) {
            if (f != null) {
                File file = JCRContentUtils.downloadFileContent(f, File.createTempFile("import", ".zip"));
                try {
                    if (file != null) {
                        ServicesRegistry.getInstance().getImportExportService().importSiteZip((Resource)new FileSystemResource(file), site, (Map<Object, Object>)jobDataMap);
                    }
                    f.remove();
                    session.save();
                }
                finally {
                    if (file != null) {
                        file.delete();
                    }
                }
            }
        } else if (f != null) {
            String filename = (String)jobDataMap.get((Object)FILENAME);
            File file = JCRContentUtils.downloadFileContent(f, File.createTempFile("import", "." + FilenameUtils.getExtension((String)filename)));
            if (jobDataMap.containsKey((Object)REPLACE_CONTENT)) {
                ImportJob.importContent(destinationParentPath, jobDataMap.getBoolean(REPLACE_CONTENT), file, f.getFileContent().getContentType());
            } else {
                ImportJob.importContent(destinationParentPath, false, file, f.getFileContent().getContentType());
            }
            FileUtils.deleteQuietly((File)file);
            f.remove();
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importContent(String parentPath, boolean replaceContent, File file, String contentType) throws IOException, RepositoryException, JahiaException {
        ImportExportBaseService importExport = ServicesRegistry.getInstance().getImportExportService();
        switch (contentType) {
            case "application/zip": {
                importExport.importZip(parentPath, (Resource)new FileSystemResource(file), 1);
                break;
            }
            case "application/xml": 
            case "text/xml": {
                FileInputStream is = new FileInputStream(file);
                try {
                    importExport.importXML(parentPath, is, 1);
                    break;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
    }
}

