/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRMultipleValueUtils;
import org.jahia.services.content.JCRValueFactoryImpl;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.importexport.validation.ConstraintsValidatorResult;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.utils.Patterns;
import org.xml.sax.Attributes;

public class ConstraintsValidator
implements ImportValidator {
    public static final String CONSTRAINT_SEPARATOR = "@@";
    private static final String COMMA_SPLIT_REGEX = "\\s*,\\s*";
    private Map<String, Set<String>> missingMandatoryProperties = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> missingMandatoryI18NProperties = new TreeMap<String, Set<String>>();
    private Map<String, String> otherConstraintViolations = new HashMap<String, String>();
    private Map<String, String> parentType = new HashMap<String, String>();
    private Map<String, Set<String>> parentMixins = new HashMap<String, Set<String>>();
    private String previousPath;

    @Override
    public ValidationResult getResult() {
        return new ConstraintsValidatorResult(this.missingMandatoryProperties, this.missingMandatoryI18NProperties, this.otherConstraintViolations);
    }

    @Override
    public void validate(String decodedLocalName, String decodedQName, String currentPath, Attributes atts) {
        boolean isI18n;
        if (!StringUtils.startsWith((String)(currentPath + "/"), (String)(this.previousPath + "/"))) {
            while (!StringUtils.startsWith((String)(currentPath + "/"), (String)(this.previousPath + "/")) && !StringUtils.isEmpty((String)this.previousPath)) {
                this.parentType.remove(this.previousPath);
                this.parentMixins.remove(this.previousPath);
                this.previousPath = StringUtils.substringBeforeLast((String)this.previousPath, (String)"/");
            }
        }
        this.previousPath = currentPath;
        String primaryType = atts.getValue("jcr:primaryType");
        String mixinTypes = atts.getValue("jcr:mixinTypes");
        HashSet<String> mixins = new HashSet<String>();
        if (mixinTypes != null) {
            mixins.addAll(Arrays.asList(mixinTypes.split(COMMA_SPLIT_REGEX)));
        }
        if (isI18n = "jnt:translation".equals(primaryType)) {
            if (this.parentMixins.get(currentPath = StringUtils.substringBeforeLast((String)currentPath, (String)"/")) != null) {
                mixins.addAll((Collection)this.parentMixins.get(currentPath));
            }
            primaryType = this.parentType.get(currentPath);
        } else {
            this.parentType.put(currentPath, primaryType);
            this.parentMixins.put(currentPath, mixins);
        }
        this.checkTypeConstraints(primaryType, currentPath, atts, isI18n);
        for (String mixin : mixins) {
            this.checkTypeConstraints(mixin, currentPath, atts, isI18n);
        }
    }

    private void checkTypeConstraints(String type, String currentPath, Attributes atts, boolean i18nEntry) {
        try {
            ExtendedPropertyDefinition[] extendedPropertyDefinitions;
            ExtendedNodeType typeToCheck = NodeTypeRegistry.getInstance().getNodeType(type);
            for (ExtendedPropertyDefinition extendedPropertyDefinition : extendedPropertyDefinitions = typeToCheck.getPropertyDefinitions()) {
                boolean isNotReference;
                boolean doCheck;
                String propertyName = extendedPropertyDefinition.getName();
                String value = atts.getValue(propertyName);
                boolean isMandatory = extendedPropertyDefinition.isMandatory() && !extendedPropertyDefinition.isAutoCreated() && !extendedPropertyDefinition.isProtected() && !extendedPropertyDefinition.hasDynamicDefaultValues();
                boolean bl = doCheck = extendedPropertyDefinition.isInternationalized() == i18nEntry;
                if (isMandatory && doCheck && !"jcr:data".equals(propertyName) && value == null) {
                    Set<String> missingProperties = this.missingMandatoryProperties.get(currentPath);
                    if (missingProperties == null) {
                        missingProperties = new TreeSet<String>();
                        this.missingMandatoryProperties.put(currentPath, missingProperties);
                    }
                    missingProperties.add(propertyName);
                }
                if (value == null || !doCheck) continue;
                String propertyPath = currentPath + "/" + propertyName;
                boolean hasConstraints = extendedPropertyDefinition.getValueConstraints() != null && extendedPropertyDefinition.getValueConstraints().length > 0;
                boolean bl2 = isNotReference = extendedPropertyDefinition.getRequiredType() != 10 && extendedPropertyDefinition.getRequiredType() != 9;
                if (!hasConstraints || !isNotReference) continue;
                if (!extendedPropertyDefinition.isMultiple()) {
                    if (typeToCheck.canSetProperty(propertyName, JCRValueFactoryImpl.getInstance().createValue(value))) continue;
                    this.otherConstraintViolations.put(propertyPath, propertyName + CONSTRAINT_SEPARATOR + value);
                    continue;
                }
                Object[] valuesAsString = "".equals(value) ? new String[]{} : Patterns.SPACE.split(value);
                Value[] values = new Value[valuesAsString.length];
                int i = 0;
                for (String string : valuesAsString) {
                    values[i++] = JCRValueFactoryImpl.getInstance().createValue(JCRMultipleValueUtils.decode(string));
                }
                if (typeToCheck.canSetProperty(propertyName, values)) continue;
                this.otherConstraintViolations.put(propertyPath, propertyName + CONSTRAINT_SEPARATOR + Arrays.toString(valuesAsString));
            }
        }
        catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            // empty catch block
        }
    }
}

