/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport.validation;

import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.importexport.validation.ImportValidator;
import org.jahia.services.importexport.validation.UserValidatorResult;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.xml.sax.Attributes;

public class UserValidator
implements ImportValidator {
    private Set<String> duplicateUsers = new TreeSet<String>();
    private JahiaUserManagerService userManagerService;

    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    @Override
    public ValidationResult getResult() {
        return new UserValidatorResult(this.duplicateUsers);
    }

    @Override
    public void validate(String decodedLocalName, String decodedQName, String currentPath, Attributes atts) {
        String type = atts.getValue("jcr:primaryType");
        if (type != null && type.equals("jnt:user")) {
            JCRUserNode userNode;
            String[] split;
            String site = null;
            if ((currentPath = StringUtils.substringAfter((String)currentPath, (String)"/content")).startsWith("/sites/") && (split = currentPath.split("/")).length > 2) {
                site = split[2];
            }
            if ((userNode = this.userManagerService.lookupUser(decodedLocalName, site)) != null && !userNode.getPath().equals(currentPath)) {
                this.duplicateUsers.add(decodedLocalName);
            }
        }
    }
}

