/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.jahia.osgi.BundleUtils;
import org.osgi.framework.Bundle;

@XmlType(propOrder={"groupId", "symbolicName", "version"})
public class BundleInfo
implements Serializable {
    private static final long serialVersionUID = -2594724069028562931L;
    private String groupId;
    private String key;
    private String symbolicName;
    private String version;

    public static BundleInfo fromBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle cannot be null");
        }
        return new BundleInfo(BundleUtils.getModuleGroupId(bundle), bundle.getSymbolicName(), bundle.getVersion().toString());
    }

    public static BundleInfo fromKey(String key) {
        if (key == null || key.indexOf(47) == -1) {
            throw new IllegalArgumentException("Illegal bundle key: " + key);
        }
        String version = StringUtils.substringAfterLast((String)key, (String)"/");
        String symbolicName = StringUtils.substringBeforeLast((String)key, (String)"/");
        String groupId = null;
        if (symbolicName.indexOf(47) != -1) {
            groupId = StringUtils.substringBefore((String)symbolicName, (String)"/");
            symbolicName = StringUtils.substringAfter((String)symbolicName, (String)"/");
        }
        return new BundleInfo(groupId, symbolicName, version);
    }

    public static BundleInfo fromModuleInfo(String moduleId, String moduleVersion) {
        if (moduleId == null || moduleVersion == null) {
            throw new IllegalArgumentException("Illegal module info (id/version): " + moduleId + '/' + moduleVersion);
        }
        Bundle bundle = BundleUtils.getBundle(moduleId, moduleVersion);
        return bundle != null ? BundleInfo.fromBundle(bundle) : null;
    }

    public BundleInfo(String symbolicName, String version) {
        this(null, symbolicName, version);
    }

    public BundleInfo(String groupId, String symbolicName, String version) {
        if (symbolicName == null || symbolicName.length() == 0 || version == null || version.length() == 0) {
            throw new IllegalArgumentException("Symbolic name and version for the bundle cannot be null or empty");
        }
        this.groupId = groupId;
        this.symbolicName = symbolicName;
        this.version = version;
        this.key = groupId != null ? groupId + '/' + symbolicName + '/' + version : symbolicName + '/' + version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getKey() {
        return this.key;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj.getClass() == this.getClass() && ((BundleInfo)obj).getKey().equals(this.getKey());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

