/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.impl;

import java.util.ArrayList;
import org.drools.core.util.StringUtils;
import org.jahia.osgi.BundleState;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.InvalidModuleException;
import org.jahia.services.modulemanager.InvalidModuleKeyException;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.ModuleManager;
import org.jahia.services.modulemanager.ModuleNotFoundException;
import org.jahia.services.modulemanager.OperationResult;
import org.jahia.services.modulemanager.persistence.BundlePersister;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.services.modulemanager.persistence.PersistentBundleInfoBuilder;
import org.jahia.services.modulemanager.spi.BundleService;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ModuleManagerImpl
implements ModuleManager {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManagerImpl.class);
    private BundleService bundleService;
    private BundlePersister persister;

    private static BundleInfo toBundleInfo(PersistentBundle persistentBundle) {
        return new BundleInfo(persistentBundle.getGroupId(), persistentBundle.getSymbolicName(), persistentBundle.getVersion());
    }

    private BundleInfo findTargetBundle(String bundleKey, String symbolicName, String version) {
        Bundle[] allBundles;
        BundleInfo targetInfo = null;
        ArrayList<Bundle> matches = new ArrayList<Bundle>();
        for (Bundle b : allBundles = FrameworkService.getBundleContext().getBundles()) {
            if (!symbolicName.equals(b.getSymbolicName()) || version != null && !version.equals(b.getVersion().toString()) || b.getState() == 1) continue;
            matches.add(b);
        }
        if (matches.size() > 1) {
            logger.warn("Found multiple bundles matching the key {}. Unable to uniquely identify target bundle", (Object)bundleKey);
        } else if (!matches.isEmpty()) {
            Bundle target = (Bundle)matches.get(0);
            targetInfo = new BundleInfo(BundleUtils.getModuleGroupId(target), target.getSymbolicName(), target.getVersion().toString());
        }
        return targetInfo;
    }

    private BundleInfo getBundleInfo(String bundleKey) {
        BundleInfo info = null;
        if (bundleKey.indexOf(47) != -1 && (info = BundleInfo.fromKey(bundleKey)).getGroupId() != null && info.getSymbolicName() != null && info.getVersion() != null) {
            return info;
        }
        return this.findTargetBundle(bundleKey, info != null ? info.getSymbolicName() : bundleKey, info != null ? info.getVersion() : null);
    }

    private OperationResult install(PersistentBundle info, String target, boolean start) throws ModuleManagementException {
        this.bundleService.install(info.getLocation(), target, start);
        return OperationResult.success(ModuleManagerImpl.toBundleInfo(info));
    }

    @Override
    public OperationResult install(Resource bundleResource, String target) throws ModuleManagementException {
        return this.install(bundleResource, target, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OperationResult install(Resource bundleResource, String target, boolean start) throws ModuleManagementException {
        Object object;
        Exception error;
        OperationResult result;
        long startTime;
        block10: {
            block9: {
                startTime = System.currentTimeMillis();
                logger.info("Performing installation for bundle {} on target {}", new Object[]{bundleResource, target});
                result = null;
                PersistentBundle bundleInfo = null;
                error = null;
                try {
                    boolean requiresHandling = !(bundleResource instanceof UrlResource) || !bundleResource.getURL().getProtocol().equals("dx");
                    bundleInfo = PersistentBundleInfoBuilder.build(bundleResource, requiresHandling, requiresHandling);
                    if (bundleInfo == null) {
                        throw new InvalidModuleException();
                    }
                    if (requiresHandling) {
                        this.persister.store(bundleInfo);
                    }
                    result = this.install(bundleInfo, target, start);
                    if (bundleInfo == null) break block9;
                }
                catch (ModuleManagementException e) {
                    try {
                        error = e;
                        throw e;
                        catch (Exception e2) {
                            error = e2;
                            throw new ModuleManagementException(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        Object info2 = bundleInfo != null ? ModuleManagerImpl.toBundleInfo(bundleInfo) : bundleResource;
                        long timeTaken = System.currentTimeMillis() - startTime;
                        if (error == null) {
                            logger.info("Installation completed for bundle {} on target {} in {} ms. Operation result: {}", new Object[]{info2, target, timeTaken, result});
                            throw throwable;
                        }
                        logger.info("Installation failed for bundle {} on target {} (took {} ms). Operation error: {}", new Object[]{info2, target, timeTaken, error});
                        throw throwable;
                    }
                }
                object = ModuleManagerImpl.toBundleInfo(bundleInfo);
                break block10;
            }
            object = bundleResource;
        }
        Object info = object;
        long timeTaken = System.currentTimeMillis() - startTime;
        if (error == null) {
            logger.info("Installation completed for bundle {} on target {} in {} ms. Operation result: {}", new Object[]{info, target, timeTaken, result});
            return result;
        }
        logger.info("Installation failed for bundle {} on target {} (took {} ms). Operation error: {}", new Object[]{info, target, timeTaken, error});
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OperationResult performOperation(String bundleKey, String target, BundleOperation operation) {
        Exception error;
        OperationResult result;
        long startTime;
        block8: {
            if (StringUtils.isEmpty((CharSequence)bundleKey)) {
                throw new IllegalArgumentException("Bundle '" + bundleKey + "' key in invalid");
            }
            startTime = System.currentTimeMillis();
            logger.info("Performing {} operation for bundle {} on target {}", new Object[]{operation.getName(), bundleKey, target});
            result = null;
            BundleInfo info = null;
            error = null;
            try {
                info = this.getBundleInfo(bundleKey);
                if (info == null) {
                    throw new ModuleNotFoundException(bundleKey);
                }
                operation.perform(info, target);
                result = OperationResult.success(info);
                if (error != null) break block8;
            }
            catch (ModuleManagementException e) {
                try {
                    error = e;
                    throw e;
                    catch (Exception e2) {
                        error = e2;
                        throw new ModuleManagementException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (error == null) {
                        logger.info("{} operation completed for bundle {} on target {} in {} ms. Opearation result: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, result});
                        throw throwable;
                    }
                    logger.info("{} operation failed for bundle {} on target {} (took {} ms). Opearation error: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, error});
                    throw throwable;
                }
            }
            logger.info("{} operation completed for bundle {} on target {} in {} ms. Opearation result: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, result});
            return result;
        }
        logger.info("{} operation failed for bundle {} on target {} (took {} ms). Opearation error: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, error});
        return result;
    }

    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    public void setPersister(BundlePersister persister) {
        this.persister = persister;
    }

    @Override
    public OperationResult start(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Start";
            }

            @Override
            public void perform(BundleInfo info, String target) throws ModuleManagementException {
                ModuleManagerImpl.this.bundleService.start(info, target);
            }
        });
    }

    @Override
    public OperationResult stop(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Stop";
            }

            @Override
            public void perform(BundleInfo info, String target) throws ModuleManagementException {
                ModuleManagerImpl.this.bundleService.stop(info, target);
            }
        });
    }

    @Override
    public OperationResult uninstall(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Uninstall";
            }

            @Override
            public void perform(BundleInfo info, String target) throws ModuleManagementException {
                ModuleManagerImpl.this.bundleService.uninstall(info, target);
            }
        });
    }

    @Override
    public OperationResult refresh(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Refresh";
            }

            @Override
            public void perform(BundleInfo info, String target) throws ModuleManagementException {
                ModuleManagerImpl.this.bundleService.refresh(info, target);
            }
        });
    }

    @Override
    public BundleState getLocalState(String bundleKey) throws ModuleManagementException {
        BundleInfo info;
        try {
            info = BundleInfo.fromKey(bundleKey);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidModuleKeyException(bundleKey);
        }
        Bundle bundle = BundleUtils.getBundleBySymbolicName(info.getSymbolicName(), info.getVersion());
        if (bundle == null) {
            throw new ModuleNotFoundException(info.getKey());
        }
        return BundleState.fromInt(bundle.getState());
    }

    private static interface BundleOperation {
        public String getName();

        public void perform(BundleInfo var1, String var2) throws ModuleManagementException;
    }
}

