/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.persistence;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.modulemanager.Constants;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.services.modulemanager.util.ModuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public final class PersistentBundleInfoBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PersistentBundleInfoBuilder.class);

    public static PersistentBundle build(Resource resource) throws IOException {
        return PersistentBundleInfoBuilder.build(resource, true, true);
    }

    public static PersistentBundle build(Resource resource, boolean calculateChecksum, boolean checkTransformationRequired) throws IOException {
        String groupId = null;
        String symbolicName = null;
        String version = null;
        String displayName = null;
        try (JarInputStream jarIs = new JarInputStream(resource.getInputStream());){
            Manifest mf = jarIs.getManifest();
            if (mf != null) {
                Attributes attrs = mf.getMainAttributes();
                groupId = attrs.getValue(Constants.ATTR_NAME_GROUP_ID);
                symbolicName = attrs.getValue(Constants.ATTR_NAME_BUNDLE_SYMBOLIC_NAME);
                version = StringUtils.defaultIfBlank((String)attrs.getValue(Constants.ATTR_NAME_BUNDLE_VERSION), (String)attrs.getValue(Constants.ATTR_NAME_IMPL_VERSION));
                displayName = StringUtils.defaultIfBlank((String)attrs.getValue(Constants.ATTR_NAME_IMPL_TITLE), (String)attrs.getValue(Constants.ATTR_NAME_BUNDLE_NAME));
            }
        }
        if (StringUtils.isBlank(symbolicName) || StringUtils.isBlank(version)) {
            logger.warn("Not a valid JAR or bundle information is missing for resource " + resource);
            return null;
        }
        PersistentBundle bundleInfo = new PersistentBundle(groupId, symbolicName, version);
        bundleInfo.setDisplayName(displayName);
        if (calculateChecksum) {
            bundleInfo.setChecksum(PersistentBundleInfoBuilder.calculateDigest(resource));
        }
        if (checkTransformationRequired) {
            bundleInfo.setTransformationRequired(PersistentBundleInfoBuilder.isTransformationRequired(resource));
        }
        bundleInfo.setResource(resource);
        return bundleInfo;
    }

    private static String calculateDigest(Resource resource) throws IOException {
        try (DigestInputStream digestInputStream = PersistentBundleInfoBuilder.toDigestInputStream(new BufferedInputStream(resource.getInputStream()));){
            byte[] b = new byte[8192];
            int read = 0;
            while (read != -1) {
                read = digestInputStream.read(b);
            }
            String string = Hex.encodeHexString((byte[])digestInputStream.getMessageDigest().digest());
            return string;
        }
    }

    private static boolean isTransformationRequired(Resource resource) throws IOException {
        try (JarInputStream is = new JarInputStream((InputStream)new BufferedInputStream(resource.getInputStream()), false);){
            boolean bl = ModuleUtils.requiresTransformation(is.getManifest().getMainAttributes());
            return bl;
        }
    }

    private static DigestInputStream toDigestInputStream(InputStream is) {
        try {
            return new DigestInputStream(is, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private PersistentBundleInfoBuilder() {
    }
}

