/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.spi.impl;

import org.jahia.osgi.BundleUtils;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.InvalidTargetException;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.ModuleNotFoundException;
import org.jahia.services.modulemanager.spi.BundleService;
import org.jahia.settings.SettingsBean;

public class BundleServiceDelegate
implements BundleService {
    private static final String CLUSTERED_SERVICE_FILTER = "(clustered=true)";
    private BundleService defaultBundleService;
    private SettingsBean settingsBean;

    @Override
    public void install(String uri, String target, boolean start) throws ModuleManagementException, InvalidTargetException {
        this.lookupService().install(uri, target, start);
    }

    @Override
    public void start(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().start(bundleInfo, target);
    }

    @Override
    public void stop(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().stop(bundleInfo, target);
    }

    @Override
    public void uninstall(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().uninstall(bundleInfo, target);
    }

    @Override
    public void refresh(BundleInfo bundleInfo, String target) throws ModuleManagementException, ModuleNotFoundException, InvalidTargetException {
        this.lookupService().refresh(bundleInfo, target);
    }

    private BundleService lookupService() {
        BundleService service = this.settingsBean.isClusterActivated() ? BundleUtils.getOsgiService(BundleService.class, CLUSTERED_SERVICE_FILTER) : null;
        return service != null ? service : this.defaultBundleService;
    }

    public void setDefaultBundleService(BundleService defaultBundleService) {
        this.defaultBundleService = defaultBundleService;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }
}

