/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.notification.CamelNotificationService;

public class CamelAppender
extends AppenderSkeleton {
    private CamelNotificationService notificationService;
    private String targetUri = "direct:logs";

    public CamelAppender() {
    }

    public CamelAppender(boolean isActive) {
        super(isActive);
    }

    protected void append(LoggingEvent event) {
        CamelNotificationService notificationService = this.getNotificationService();
        if (notificationService != null) {
            notificationService.queueMessagesWithBodyAndHeaders(this.targetUri, this.getLayout().format(event), null);
        }
    }

    public void close() {
    }

    private CamelNotificationService getNotificationService() {
        SpringContextSingleton springCtx;
        if (this.notificationService == null && (springCtx = SpringContextSingleton.getInstance()).isInitialized()) {
            this.notificationService = (CamelNotificationService)springCtx.getContext().getBean("camelNotificationService");
        }
        return this.notificationService;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }
}

