/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.jahia.ajax.gwt.client.widget.poller.ToolbarWarningEvent;
import org.jahia.services.atmosphere.AtmosphereServlet;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolbarWarningsService {
    private static final Logger logger = LoggerFactory.getLogger(ToolbarWarningsService.class);
    private List<Message> messages = Collections.synchronizedList(new ArrayList());

    public static ToolbarWarningsService getInstance() {
        return Holder.INSTANCE;
    }

    public void addMessage(String message) {
        this.addMessage(false, message, new Object[0]);
    }

    public void addMessage(boolean atTheTop, String message, Object ... args) {
        this.removeMessage(message);
        Message m = new Message(message, args);
        if (atTheTop) {
            this.messages.add(0, m);
            this.broadcastMessagesUpdate();
        } else {
            this.messages.add(m);
            this.broadcastMessagesUpdate();
        }
    }

    public void removeMessage(String message) {
        if (this.messages != null) {
            Iterator<Message> it = this.messages.iterator();
            while (it.hasNext()) {
                if (!it.next().key.equals(message)) continue;
                it.remove();
                this.broadcastMessagesUpdate();
            }
        }
    }

    private void broadcastMessagesUpdate() {
        BroadcasterFactory broadcasterFactory = AtmosphereServlet.getBroadcasterFactory();
        if (broadcasterFactory != null) {
            Broadcaster broadcaster = broadcasterFactory.lookup((Object)"org.jahia.broadcaster");
            if (broadcaster != null) {
                broadcaster.broadcast((Object)new ToolbarWarningEvent());
            } else {
                logger.debug("Fail to broadcast Toolbar warning message event update, because broadcaster not found");
            }
        } else {
            logger.debug("Fail to broadcast Toolbar warning message event update, because broadcaster factory not ready");
        }
    }

    public String getMessagesAsString() {
        return this.messages != null ? StringUtils.join(this.messages, (String)"||") : "";
    }

    public String getMessagesValueAsString(Locale locale) {
        if (this.messages == null) {
            return "";
        }
        ArrayList<String> translatedMessages = new ArrayList<String>();
        for (Message m : this.messages) {
            translatedMessages.add(m.args != null ? Messages.getInternalWithArguments(m.key, m.key, locale, m.args) : Messages.getInternal(m.key, locale, m.key));
        }
        return StringUtils.join(translatedMessages, (String)"||");
    }

    private static class Holder {
        static final ToolbarWarningsService INSTANCE = new ToolbarWarningsService();

        private Holder() {
        }
    }

    private class Message {
        private String key;
        private Object[] args;

        Message(String key, Object[] args) {
            this.key = key;
            this.args = args;
        }
    }
}

