/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import net.sf.ehcache.Element;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.render.filter.cache.CacheClusterEvent;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLResolverListener
extends DefaultEventListener {
    private static Logger logger = LoggerFactory.getLogger(URLResolverListener.class);
    private URLResolverFactory urlResolverFactory;
    private VanityUrlService vanityUrlService;
    private ModuleCacheProvider moduleCacheProvider;

    @Override
    public int getEventTypes() {
        return 63;
    }

    public void onEvent(EventIterator events) {
        if (this.urlResolverFactory == null) {
            return;
        }
        try {
            LinkedHashSet<String> pathsToFlush = null;
            boolean flushVanityUrlCache = false;
            while (events.hasNext()) {
                int pos;
                Event event = events.nextEvent();
                if (this.isExternal(event)) continue;
                String path = event.getPath();
                if (event.getType() != 1 && event.getType() != 2 && event.getType() != 32 && !path.endsWith("/j:published") && !path.contains("/vanityUrlMapping/")) continue;
                if ((event.getType() == 16 || event.getType() == 4 || event.getType() == 8) && (pos = (path = path.substring(0, path.lastIndexOf("/"))).lastIndexOf("/")) != -1 && path.substring(pos, path.length()).startsWith("/j:translation_")) {
                    path = path.substring(0, pos);
                }
                boolean bl = flushVanityUrlCache = flushVanityUrlCache || path.contains("vanityUrlMapping");
                if (pathsToFlush == null) {
                    pathsToFlush = new LinkedHashSet<String>();
                }
                pathsToFlush.add(path);
            }
            this.flushCaches(pathsToFlush, flushVanityUrlCache);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setUrlResolverFactory(URLResolverFactory urlResolverFactory) {
        this.urlResolverFactory = urlResolverFactory;
    }

    public void setVanityUrlService(VanityUrlService vanityUrlService) {
        this.vanityUrlService = vanityUrlService;
    }

    private void flushCaches(Set<String> pathsToFlush, boolean flushVanityUrlCache) {
        if (pathsToFlush != null) {
            this.urlResolverFactory.flushCaches(pathsToFlush);
        }
        if (flushVanityUrlCache) {
            this.vanityUrlService.flushCaches();
        }
        if ((pathsToFlush != null || flushVanityUrlCache) && SettingsBean.getInstance().isClusterActivated()) {
            LinkedList<Element> syncEvents = new LinkedList<Element>();
            if (pathsToFlush != null) {
                for (String path : pathsToFlush) {
                    syncEvents.add(new Element((Serializable)((Object)("FLUSH_URLRESOLVER-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(path, URLResolverListener.getClusterRevision())));
                }
            }
            if (flushVanityUrlCache) {
                syncEvents.add(new Element((Serializable)((Object)("FLUSH_VANITYURL-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent("", URLResolverListener.getClusterRevision())));
            }
            this.moduleCacheProvider.getSyncCache().putAll(syncEvents);
        }
    }

    private static long getClusterRevision() {
        return SpringJackrabbitRepository.getInstance().getClusterRevision();
    }

    public void setModuleCacheProvider(ModuleCacheProvider moduleCacheProvider) {
        this.moduleCacheProvider = moduleCacheProvider;
    }
}

