/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;

public class BaseAttributesFilter
extends AbstractFilter {
    public Set<String> configurationToSkipInResourceRenderedPath;

    @Override
    public String prepare(RenderContext context, Resource resource, RenderChain chain) throws Exception {
        HttpServletRequest request = context.getRequest();
        request.setAttribute("renderContext", (Object)context);
        chain.pushAttribute(request, "currentResource", resource);
        String contextPath = null;
        contextPath = context.isEditMode() && !context.isContributionMode() ? StringUtils.substringAfterLast((String)((EditConfiguration)SpringContextSingleton.getBean(context.getEditModeConfigName())).getDefaultUrlMapping(), (String)"/") : (context.isContributionMode() ? "contribute" : "render");
        String mode = contextPath + "/" + resource.getWorkspace();
        chain.pushAttribute(request, "currentLocale", resource.getLocale());
        chain.pushAttribute(request, "currentMode", mode);
        chain.pushAttribute(request, "currentUser", context.getMainResource().getNode().getSession().getUser());
        chain.pushAttribute(request, "currentAliasUser", context.getMainResource().getNode().getSession().getAliasedUser());
        if (!"include".equals(resource.getContextConfiguration())) {
            chain.pushAttribute(request, "url", new URLGenerator(context, resource));
        }
        boolean added = false;
        if (!this.configurationToSkipInResourceRenderedPath.contains(resource.getContextConfiguration())) {
            added = context.getRenderedPaths().add(resource.getNodePath());
        }
        chain.pushAttribute(request, "resourceAddedInRenderedPath", added);
        if (!resource.getContextConfiguration().equals("include")) {
            chain.pushAttribute(request, "moduleMap", new HashMap());
        }
        return null;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        if (renderContext.getRequest().getAttribute("resourceAddedInRenderedPath").equals(true)) {
            renderContext.getRenderedPaths().remove(resource.getNodePath());
        }
        return super.execute(previousOut, renderContext, resource, chain);
    }

    public void setConfigurationToSkipInResourceRenderedPath(Set<String> configurationToSkipInResourceRenderedPath) {
        this.configurationToSkipInResourceRenderedPath = configurationToSkipInResourceRenderedPath;
    }
}

