/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.list.UnmodifiableList;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.filter.RenderFilterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderChain {
    private static final Logger logger = LoggerFactory.getLogger(RenderChain.class);
    private List<RenderFilter> filters = new ArrayList<RenderFilter>();
    final Map<String, Object> oldPropertiesMap = new HashMap<String, Object>();

    public RenderChain() {
    }

    public RenderChain(Collection<RenderFilter> filters) {
        this.addFilters(filters);
    }

    public RenderChain(Collection<RenderFilter> filters1, Collection<RenderFilter> filters2) {
        this.filters.addAll(filters1);
        this.filters.addAll(filters2);
        Collections.sort(this.filters);
    }

    public RenderChain(RenderFilter ... filters) {
        this();
        for (RenderFilter renderFilter : filters) {
            this.filters.add(renderFilter);
        }
        Collections.sort(this.filters);
    }

    public void addFilter(RenderFilter filter) {
        this.filters.add(filter);
        Collections.sort(this.filters);
    }

    public void addFilters(Collection<RenderFilter> filters) {
        this.filters.addAll(filters);
        this.doSortFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doFilter(RenderContext renderContext, Resource resource) throws RenderFilterException {
        String out;
        block27: {
            long timer;
            RenderFilter filter;
            out = null;
            int index = 0;
            if (logger.isTraceEnabled()) {
                logger.trace("Configured filters:");
                for (RenderFilter filter2 : this.filters) {
                    logger.trace("  " + filter2.getClass().getName());
                }
            }
            String nodePath = "empty resource";
            if (resource != null) {
                nodePath = resource.getNodePath();
            }
            Integer finalFilterIndex = null;
            try {
                while (index < this.filters.size() && out == null && renderContext.getRedirect() == null && !renderContext.isPortletActionRequest()) {
                    filter = this.filters.get(index);
                    if (filter.areConditionsMatched(renderContext, resource)) {
                        timer = System.currentTimeMillis();
                        finalFilterIndex = index;
                        out = filter.prepare(renderContext, resource, this);
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: prepare filter {} done in {} ms", new Object[]{nodePath, filter.getClass().getName(), System.currentTimeMillis() - timer});
                        }
                    }
                    ++index;
                }
                --index;
                while (index >= 0 && renderContext.getRedirect() == null && !renderContext.isPortletActionRequest()) {
                    filter = this.filters.get(index);
                    if (filter.areConditionsMatched(renderContext, resource)) {
                        timer = System.currentTimeMillis();
                        out = filter.execute(out, renderContext, resource, this);
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: execute filter {} done in {} ms", new Object[]{nodePath, filter.getClass().getName(), System.currentTimeMillis() - timer});
                        }
                    }
                    --index;
                }
                if (finalFilterIndex == null) break block27;
            }
            catch (Exception e) {
                block28: {
                    try {
                        out = null;
                        logger.error("Error while rendering the resource: " + resource + " -> " + e.toString());
                        ++index;
                        while (index > 0 && renderContext.getRedirect() == null && out == null) {
                            RenderFilter filter3 = this.filters.get(index - 1);
                            if (filter3.areConditionsMatched(renderContext, resource)) {
                                long timer2 = System.currentTimeMillis();
                                out = filter3.getContentForError(renderContext, resource, this, e);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("{}: handling error for filter {} done in {} ms", new Object[]{nodePath, filter3.getClass().getName(), System.currentTimeMillis() - timer2});
                                }
                            }
                            --index;
                        }
                        if (out == null) {
                            throw new RenderFilterException(e);
                        }
                        if (finalFilterIndex == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (finalFilterIndex != null) {
                            for (index = 0; index <= finalFilterIndex; ++index) {
                                try {
                                    RenderFilter filter4 = this.filters.get(index);
                                    if (!filter4.areConditionsMatched(renderContext, resource)) continue;
                                    long timer3 = System.currentTimeMillis();
                                    filter4.finalize(renderContext, resource, this);
                                    if (!logger.isDebugEnabled()) continue;
                                    logger.debug("{}: finalizing filter {} done in {} ms", new Object[]{nodePath, filter4.getClass().getName(), System.currentTimeMillis() - timer3});
                                    continue;
                                }
                                catch (Exception e2) {
                                    logger.warn("Error during finalizing of filter", (Throwable)e2);
                                }
                            }
                        }
                        this.popAttributes(renderContext.getRequest());
                        throw throwable;
                    }
                    for (index = 0; index <= finalFilterIndex; ++index) {
                        try {
                            RenderFilter filter5 = this.filters.get(index);
                            if (!filter5.areConditionsMatched(renderContext, resource)) continue;
                            long timer4 = System.currentTimeMillis();
                            filter5.finalize(renderContext, resource, this);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("{}: finalizing filter {} done in {} ms", new Object[]{nodePath, filter5.getClass().getName(), System.currentTimeMillis() - timer4});
                            continue;
                        }
                        catch (Exception e3) {
                            logger.warn("Error during finalizing of filter", (Throwable)e3);
                        }
                    }
                }
                this.popAttributes(renderContext.getRequest());
            }
            for (index = 0; index <= finalFilterIndex; ++index) {
                try {
                    filter = this.filters.get(index);
                    if (!filter.areConditionsMatched(renderContext, resource)) continue;
                    timer = System.currentTimeMillis();
                    filter.finalize(renderContext, resource, this);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("{}: finalizing filter {} done in {} ms", new Object[]{nodePath, filter.getClass().getName(), System.currentTimeMillis() - timer});
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Error during finalizing of filter", (Throwable)e);
                }
            }
        }
        this.popAttributes(renderContext.getRequest());
        return out;
    }

    public void doSortFilters() {
        Collections.sort(this.filters);
    }

    public void pushAttribute(HttpServletRequest request, String key, Object value) {
        if (!this.oldPropertiesMap.containsKey(key)) {
            this.oldPropertiesMap.put(key, request.getAttribute(key));
        }
        request.setAttribute(key, value);
    }

    private void popAttributes(HttpServletRequest request) {
        for (Map.Entry<String, Object> entry : this.oldPropertiesMap.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public Object getPreviousValue(String key) {
        return this.oldPropertiesMap.get(key);
    }

    public List<RenderFilter> getFilters() {
        return UnmodifiableList.decorate(this.filters);
    }
}

