/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateNodeFilter
extends AbstractFilter {
    private static Logger logger = LoggerFactory.getLogger(TemplateNodeFilter.class);

    @Override
    public String prepare(RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String i;
        if (renderContext.getRequest().getAttribute("skipWrapper") == null && !renderContext.isAjaxRequest()) {
            chain.pushAttribute(renderContext.getRequest(), "inWrapper", Boolean.TRUE);
            Template template = null;
            Template previousTemplate = null;
            if (renderContext.getRequest().getAttribute("templateSet") == null) {
                template = this.service.resolveTemplate(resource, renderContext);
                if (template == null) {
                    throw new TemplateNotFoundException(resource.getTemplate());
                }
                renderContext.getRequest().setAttribute("templateSet", (Object)Boolean.TRUE);
                if (logger.isDebugEnabled()) {
                    logger.debug("Template set to : " + template.serialize() + " for resource " + resource);
                }
            } else if (renderContext.getRequest().getAttribute("cachedTemplate") != null) {
                template = (Template)renderContext.getRequest().getAttribute("cachedTemplate");
                renderContext.getRequest().removeAttribute("cachedTemplate");
                if (logger.isDebugEnabled()) {
                    logger.debug("Restoring cached template to : " + template.serialize() + " for resource " + resource);
                }
            } else {
                previousTemplate = (Template)renderContext.getRequest().getAttribute("previousTemplate");
                if (previousTemplate != null) {
                    template = previousTemplate.next;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using Previous Template : " + previousTemplate.serialize() + " for resource " + resource);
                        if (template != null) {
                            logger.debug("Setting Template to use to : " + template.serialize() + " for resource " + resource);
                        } else {
                            logger.debug("Template has been set to null for resource " + resource);
                        }
                    }
                }
            }
            if (template != null && template.node != null) {
                JCRNodeWrapper templateNode = resource.getNode().getSession().getNodeByIdentifier(template.node);
                renderContext.getRequest().setAttribute("previousTemplate", (Object)template);
                renderContext.getRequest().setAttribute("wrappedResource", (Object)resource);
                Resource wrapperResource = new Resource(templateNode, resource.getTemplateType(), template.view, "wrapper");
                if (this.service.hasView(templateNode, template.getView(), resource.getTemplateType(), renderContext)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Calling render service with template : " + template.serialize() + " templateNode path : " + templateNode.getPath() + " for wrapperresource " + wrapperResource);
                    }
                    String output = RenderService.getInstance().render(wrapperResource, renderContext);
                    renderContext.getRequest().setAttribute("previousTemplate", (Object)previousTemplate);
                    return output;
                }
                logger.warn("Cannot get wrapper " + template);
            }
        } else if (renderContext.isAjaxRequest() && resource.getContextConfiguration().equals("page") && (i = renderContext.getRequest().getParameter("jarea")) != null) {
            JCRNodeWrapper area = resource.getNode().getSession().getNodeByUUID(i);
            Resource wrapperResource = new Resource(area, resource.getTemplateType(), null, "module");
            String output = RenderService.getInstance().render(wrapperResource, renderContext);
            return output;
        }
        chain.pushAttribute(renderContext.getRequest(), "inWrapper", renderContext.isAjaxRequest() ? Boolean.TRUE : (renderContext.getRequest().getAttribute("inArea") != null ? Boolean.TRUE : Boolean.FALSE));
        return null;
    }
}

