/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderException;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperFilter
extends AbstractFilter {
    private static Logger logger = LoggerFactory.getLogger(WrapperFilter.class);
    private String wrapper;

    public void setWrapper(String wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        JCRNodeWrapper node = resource.getNode();
        if (this.wrapper == null) {
            while (resource.hasWrapper()) {
                String wrapper = resource.popWrapper();
                previousOut = this.wrap(renderContext, resource, previousOut, node, wrapper);
            }
        } else {
            previousOut = this.wrap(renderContext, resource, previousOut, node, this.wrapper);
        }
        return previousOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String wrap(RenderContext renderContext, Resource resource, String output, JCRNodeWrapper node, String wrapper) throws RepositoryException {
        block7: {
            try {
                Resource wrapperResource = new Resource(node, resource.getTemplateType(), wrapper, "wrapper");
                if (this.service.hasView(node, wrapper, resource.getTemplateType(), renderContext)) {
                    Object wrappedContent = renderContext.getRequest().getAttribute("wrappedContent");
                    try {
                        renderContext.getRequest().setAttribute("wrappedContent", (Object)output);
                        output = RenderService.getInstance().render(wrapperResource, renderContext);
                        break block7;
                    }
                    finally {
                        renderContext.getRequest().setAttribute("wrappedContent", wrappedContent);
                    }
                }
                logger.warn("Cannot get wrapper " + wrapper);
            }
            catch (TemplateNotFoundException e) {
                logger.debug("Cannot find wrapper " + wrapper, (Throwable)e);
            }
            catch (RenderException e) {
                logger.error("Cannot execute wrapper " + wrapper, (Throwable)e);
            }
        }
        return output;
    }
}

