/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.RenderContextTuner;

public class InAreaCacheKeyPartGenerator
implements CacheKeyPartGenerator,
RenderContextTuner {
    @Override
    public String getKey() {
        return "inArea";
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        HttpServletRequest request = renderContext.getRequest();
        Object inArea = request.getAttribute("inArea");
        return inArea != null ? inArea.toString() : "";
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        return keyPart;
    }

    @Override
    public Object prepareContextForContentGeneration(String value, Resource resource, RenderContext renderContext) {
        Object original = renderContext.getRequest().getAttribute("inArea");
        if (StringUtils.isEmpty((String)value)) {
            renderContext.getRequest().removeAttribute("inArea");
        } else {
            renderContext.getRequest().setAttribute("inArea", (Object)Boolean.valueOf(value));
        }
        return original;
    }

    @Override
    public void restoreContextAfterContentGeneration(String value, Resource resource, RenderContext renderContext, Object original) {
        if (original != null) {
            renderContext.getRequest().setAttribute("inArea", original);
        } else {
            renderContext.getRequest().removeAttribute("inArea");
        }
    }
}

