/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.Policy;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.ehcache.DependenciesCacheEvictionPolicy;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.impl.jackrabbit.SpringJackrabbitRepository;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.render.filter.cache.CacheClusterEvent;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;

public class ModuleCacheProvider
implements InitializingBean,
ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent> {
    private static final String CACHE_NAME = "HTMLCache";
    private static final String CACHE_SYNC_NAME = "HTMLCacheEventSync";
    private static final String DEPS_CACHE_NAME = "HTMLDependenciesCache";
    private static final String REGEXPDEPS_CACHE_NAME = "HTMLREGEXPDependenciesCache";
    private static Logger logger = LoggerFactory.getLogger(ModuleCacheProvider.class);
    private Cache regexpDependenciesCache;
    private Cache htmlCache;
    private EhCacheProvider cacheProvider;
    private Cache dependenciesCache;
    private Cache syncCache;
    private Set<String> nonCacheableFragments = Collections.newSetFromMap(new ConcurrentHashMap());
    private CacheKeyGenerator keyGenerator;
    private JCRSessionFactory jcrSessionFactory;
    private AggregateCacheFilter aggregateCacheFilter;

    public static ModuleCacheProvider getInstance() {
        return (ModuleCacheProvider)SpringContextSingleton.getBean("ModuleCacheProvider");
    }

    public void afterPropertiesSet() throws Exception {
        CacheManager cacheManager = this.cacheProvider.getCacheManager();
        this.htmlCache = cacheManager.getCache(CACHE_NAME);
        if (this.htmlCache == null) {
            cacheManager.addCache(CACHE_NAME);
            this.htmlCache = cacheManager.getCache(CACHE_NAME);
        }
        this.dependenciesCache = cacheManager.getCache(DEPS_CACHE_NAME);
        if (this.dependenciesCache == null) {
            cacheManager.addCache(DEPS_CACHE_NAME);
            this.dependenciesCache = cacheManager.getCache(DEPS_CACHE_NAME);
        }
        this.dependenciesCache.setMemoryStoreEvictionPolicy((Policy)new DependenciesCacheEvictionPolicy());
        this.regexpDependenciesCache = cacheManager.getCache(REGEXPDEPS_CACHE_NAME);
        if (this.regexpDependenciesCache == null) {
            cacheManager.addCache(REGEXPDEPS_CACHE_NAME);
            this.regexpDependenciesCache = cacheManager.getCache(REGEXPDEPS_CACHE_NAME);
        }
        this.regexpDependenciesCache.setMemoryStoreEvictionPolicy((Policy)new DependenciesCacheEvictionPolicy());
        if (SettingsBean.getInstance().isClusterActivated()) {
            this.syncCache = cacheManager.getCache(CACHE_SYNC_NAME);
            if (this.syncCache == null) {
                cacheManager.addCache(CACHE_SYNC_NAME);
                this.syncCache = cacheManager.getCache(CACHE_SYNC_NAME);
            }
        }
    }

    public void invalidate(String nodePathOrIdentifier) {
        this.invalidate(nodePathOrIdentifier, true);
    }

    public void invalidate(String nodePathOrIdentifier, boolean propagateToOtherClusterNodes) {
        Element element = this.dependenciesCache.get((Serializable)((Object)nodePathOrIdentifier));
        if (element != null) {
            Set deps = (Set)element.getObjectValue();
            if (deps.contains("ALL")) {
                this.htmlCache.removeAll(true);
            } else {
                this.htmlCache.removeAll((Collection)deps);
            }
        }
        if (propagateToOtherClusterNodes) {
            this.propagatePathFlushToCluster(nodePathOrIdentifier);
        }
    }

    public void invalidate(Collection<String> nodePathOrIdentifiers, boolean propagateToOtherClusterNodes) {
        HashSet all = new HashSet();
        for (String nodePathOrIdentifier : nodePathOrIdentifiers) {
            Element element = this.dependenciesCache.get((Serializable)((Object)nodePathOrIdentifier));
            if (element == null) continue;
            Set deps = (Set)element.getObjectValue();
            if (deps.contains("ALL")) {
                this.htmlCache.removeAll(true);
                all.clear();
                break;
            }
            all.addAll(deps);
        }
        this.htmlCache.removeAll(all);
        if (propagateToOtherClusterNodes) {
            for (String nodePathOrIdentifier : nodePathOrIdentifiers) {
                this.propagatePathFlushToCluster(nodePathOrIdentifier);
            }
        }
    }

    public Cache getCache() {
        return this.htmlCache;
    }

    public Cache getDependenciesCache() {
        return this.dependenciesCache;
    }

    public CacheKeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setCacheProvider(EhCacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void setKeyGenerator(CacheKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void flushCaches() {
        this.htmlCache.removeAll();
        this.htmlCache.flush();
        this.dependenciesCache.removeAll();
        this.dependenciesCache.flush();
        this.regexpDependenciesCache.removeAll();
        this.regexpDependenciesCache.flush();
    }

    public Cache getRegexpDependenciesCache() {
        return this.regexpDependenciesCache;
    }

    public void invalidateRegexp(String key) {
        this.invalidateRegexp(key, true);
    }

    public void invalidateRegexp(String key, boolean propagateToOtherClusterNodes) {
        Element element = this.regexpDependenciesCache.get((Serializable)((Object)key));
        if (element != null) {
            Set deps = (Set)element.getObjectValue();
            this.htmlCache.removeAll((Collection)deps);
        }
        if (propagateToOtherClusterNodes && this.syncCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending flush of regexp {} across cluster", (Object)key);
            }
            this.syncCache.put(new Element((Serializable)((Object)("FLUSH_REGEXP-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(key, this.getClusterRevision())));
        }
    }

    public void propagateFlushRegexpDependenciesOfPath(String key, boolean propagateToOtherClusterNodes) {
        if (propagateToOtherClusterNodes && this.syncCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending flush of regexp dependencies {} across cluster", (Object)key);
            }
            this.syncCache.put(new Element((Serializable)((Object)("FLUSH_REGEXPDEP-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(key, this.getClusterRevision())));
        }
    }

    public void propagateChildrenDependenciesFlushToCluster(String path, boolean propagateToOtherClusterNodes) {
        if (propagateToOtherClusterNodes && this.syncCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending flush of children of {} across cluster", (Object)path);
            }
            this.syncCache.put(new Element((Serializable)((Object)("FLUSH_CHILDS-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(path, this.getClusterRevision())));
        }
    }

    public void flushChildrenDependenciesOfPath(String path, boolean propagateToOtherClusterNodes) {
        if (logger.isDebugEnabled()) {
            logger.debug("Flushing dependencies for path: {}", (Object)path);
        }
        List keys = this.dependenciesCache.getKeys();
        String pathWithTrailingSlash = null;
        if (!keys.isEmpty()) {
            pathWithTrailingSlash = path + '/';
        }
        for (String key : keys) {
            if (!key.equals(path) && !key.startsWith(pathWithTrailingSlash)) continue;
            this.invalidate(key, propagateToOtherClusterNodes);
        }
        if (SettingsBean.getInstance().isClusterActivated()) {
            this.propagateChildrenDependenciesFlushToCluster(path, propagateToOtherClusterNodes);
        }
    }

    public void flushRegexpDependenciesOfPath(String path, boolean propagateToOtherClusterNodes) {
        if (logger.isDebugEnabled()) {
            logger.debug("Flushing dependencies for path: {}", (Object)path);
        }
        List keys = this.getRegexpDependenciesCache().getKeys();
        for (String key : keys) {
            if (!path.matches(key)) continue;
            this.invalidateRegexp(key, propagateToOtherClusterNodes);
        }
        if (propagateToOtherClusterNodes && SettingsBean.getInstance().isClusterActivated()) {
            this.propagateFlushRegexpDependenciesOfPath(path, propagateToOtherClusterNodes);
        }
    }

    public void addNonCacheableFragment(String key) {
        this.nonCacheableFragments.add(key);
    }

    public void removeNonCacheableFragmentsByEncodedPath(String key) {
        if (this.aggregateCacheFilter.isDisabled()) {
            Map<String, String> keyAttrs = this.keyGenerator.parse(key);
            String path = keyAttrs.get("path");
            ArrayList<String> removableKeys = new ArrayList<String>();
            for (String nonCacheableKey : this.nonCacheableFragments) {
                if (!nonCacheableKey.contains(path)) continue;
                removableKeys.add(nonCacheableKey);
            }
            for (String removableKey : removableKeys) {
                this.nonCacheableFragments.remove(removableKey);
            }
        } else {
            this.aggregateCacheFilter.removeNotCacheableFragment(key);
        }
    }

    public void flushNonCacheableFragments() {
        if (this.aggregateCacheFilter.isDisabled()) {
            this.nonCacheableFragments.clear();
        } else {
            AggregateCacheFilter.flushNotCacheableFragment();
        }
    }

    public boolean isNonCacheableFragment(String key) {
        return this.nonCacheableFragments.contains(key);
    }

    public void propagatePathFlushToCluster(String nodePathOrIdentifier) {
        if (this.syncCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending flush of {} across cluster", (Object)nodePathOrIdentifier);
            }
            this.syncCache.put(new Element((Serializable)((Object)("FLUSH_PATH-" + UUID.randomUUID())), (Serializable)new CacheClusterEvent(nodePathOrIdentifier, this.getClusterRevision())));
        }
    }

    private long getClusterRevision() {
        return SpringJackrabbitRepository.getInstance().getClusterRevision();
    }

    public void setJcrSessionFactory(JCRSessionFactory jcrSessionFactory) {
        this.jcrSessionFactory = jcrSessionFactory;
    }

    public Cache getSyncCache() {
        return this.syncCache;
    }

    public void setAggregateCacheFilter(AggregateCacheFilter aggregateCacheFilter) {
        this.aggregateCacheFilter = aggregateCacheFilter;
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent templatePackageRedeployedEvent) {
        this.flushNonCacheableFragments();
    }
}

