/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.cache.CacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.RenderContextTuner;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleParamsCacheKeyPartGenerator
implements CacheKeyPartGenerator,
RenderContextTuner {
    private static final Logger logger = LoggerFactory.getLogger(ModuleParamsCacheKeyPartGenerator.class);
    private static final String ENCODED_DOUBLE_AT = "&dblAt;";
    private static final String ENCODED_DOUBLE_QUOTES = "&dblQuote;";
    private static final String ENCODED_PREFIX = "&amp;";

    @Override
    public String getKey() {
        return "moduleParams";
    }

    @Override
    public String getValue(Resource resource, RenderContext renderContext, Properties properties) {
        Map<String, Serializable> params = resource.getModuleParams();
        return params.size() == 0 ? "" : ModuleParamsCacheKeyPartGenerator.encodeString(new OrderedJsonObject(params).toString());
    }

    @Override
    public String replacePlaceholders(RenderContext renderContext, String keyPart) {
        return keyPart;
    }

    protected static String encodeString(String toBeEncoded) {
        return toBeEncoded != null ? toBeEncoded.replace("&", ENCODED_PREFIX).replace("@@", ENCODED_DOUBLE_AT).replace("\"", ENCODED_DOUBLE_QUOTES) : null;
    }

    protected static String decodeString(String toBeDecoded) {
        return toBeDecoded != null && toBeDecoded.contains("&") ? toBeDecoded.replace(ENCODED_DOUBLE_AT, "@@").replace(ENCODED_DOUBLE_QUOTES, "\"").replace(ENCODED_PREFIX, "&") : toBeDecoded;
    }

    @Override
    public Object prepareContextForContentGeneration(String value, Resource resource, RenderContext renderContext) {
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                OrderedJsonObject map = new OrderedJsonObject(ModuleParamsCacheKeyPartGenerator.decodeString(value));
                Iterator<?> keys = map.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    resource.getModuleParams().put(key, (Serializable)map.get(key));
                }
            }
            catch (JSONException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void restoreContextAfterContentGeneration(String value, Resource resource, RenderContext renderContext, Object original) {
    }

    private static class OrderedJsonObject
    extends JSONObject {
        public OrderedJsonObject(Map<?, ?> map) {
            super(map);
        }

        public OrderedJsonObject(String source) throws JSONException {
            super(source);
        }

        public Iterator<?> keys() {
            TreeSet keys = new TreeSet();
            Iterator it = super.keys();
            while (it.hasNext()) {
                keys.add(it.next());
            }
            return keys.iterator();
        }
    }
}

