/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.scheduler;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.utils.ScriptEngineUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR223ScriptJob
extends BackgroundJob {
    private static final Logger logger = LoggerFactory.getLogger(JSR223ScriptJob.class);
    public static final String JOB_SCRIPT_PATH = "jobScriptPath";
    public static final String JOB_SCRIPT_ABSOLUTE_PATH = "jobScriptAbsolutePath";
    public static final String JOB_SCRIPT_OUTPUT = "jobScriptOutput";

    @Override
    public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
        String jobScriptPath;
        JobDataMap map = jobExecutionContext.getJobDetail().getJobDataMap();
        boolean isAbsolutePath = false;
        if (map.containsKey((Object)JOB_SCRIPT_ABSOLUTE_PATH)) {
            isAbsolutePath = true;
            jobScriptPath = map.getString(JOB_SCRIPT_ABSOLUTE_PATH);
        } else {
            jobScriptPath = map.getString(JOB_SCRIPT_PATH);
        }
        logger.info("Start executing JSR223 script job {}", (Object)jobScriptPath);
        ScriptEngine scriptEngine = ScriptEngineUtils.getInstance().scriptEngine(FilenameUtils.getExtension((String)jobScriptPath));
        if (scriptEngine != null) {
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("jobDataMap", (Object)map);
            InputStream scriptInputStream = !isAbsolutePath ? JahiaContextLoaderListener.getServletContext().getResourceAsStream(jobScriptPath) : FileUtils.openInputStream((File)new File(jobScriptPath));
            if (scriptInputStream != null) {
                InputStreamReader scriptContent = null;
                try {
                    scriptContent = new InputStreamReader(scriptInputStream);
                    StringWriter out = new StringWriter();
                    scriptContext.setWriter(out);
                    bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
                    scriptContext.setBindings(bindings, 100);
                    scriptContext.setBindings(scriptEngine.getContext().getBindings(200), 200);
                    scriptEngine.eval((Reader)scriptContent, (ScriptContext)scriptContext);
                    map.put(JOB_SCRIPT_OUTPUT, out.toString());
                    logger.info("...JSR-223 script job {} execution finished", (Object)jobScriptPath);
                }
                catch (ScriptException e) {
                    logger.error("Error during execution of the JSR-223 script job " + jobScriptPath + " execution failed with error " + e.getMessage(), (Throwable)e);
                    throw new Exception("Error during execution of script " + jobScriptPath, e);
                }
                finally {
                    if (scriptContent != null) {
                        IOUtils.closeQuietly((Reader)scriptContent);
                    }
                }
            }
        }
    }
}

