/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.MatchInfo;

public class LinkGenerator {
    private static final String RESOLVE_CONTEXT = "/resolve/";

    public static String composeLink(MatchInfo info, RenderContext context) {
        Objects.requireNonNull(info);
        String contextPath = context != null ? context.getURLGenerator().getContext() + "/cms" : null;
        String initialPath = StringUtils.isEmpty(contextPath) ? RESOLVE_CONTEXT : contextPath + RESOLVE_CONTEXT;
        return initialPath + info.getWorkspace() + "/" + info.getLang() + "/" + info.getId();
    }

    public static MatchInfo decomposeLink(String link) {
        Objects.requireNonNull(link);
        int context = link.indexOf(RESOLVE_CONTEXT);
        if (context != -1) {
            Object[] components = link.substring(context + RESOLVE_CONTEXT.length()).split("/");
            if (components.length != 3) {
                throw new IllegalArgumentException("Wrong format: " + link + " doesn't contain the appropriate (workspace, language, path) components. Components were: " + StringUtils.join((Object[])components));
            }
            return new MatchInfo(components[2], components[0], components[1]);
        }
        throw new IllegalArgumentException("Wrong format: " + link + " cannot be decomposed as a MatchInfo.");
    }
}

