/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.jcr;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Render;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.utils.Url;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanityUrlMapper {
    private static final Logger logger = LoggerFactory.getLogger(VanityUrlMapper.class);
    public static final String VANITY_KEY = "org.jahia.services.seo.jcr.VanityUrl";

    public void checkVanityUrl(HttpServletRequest hsRequest, String outboundContext, String outboundUrl) {
        block19: {
            hsRequest.removeAttribute(VANITY_KEY);
            URLResolverFactory urlResolverFactory = (URLResolverFactory)SpringContextSingleton.getBean("urlResolverFactory");
            VanityUrlService vanityUrlService = (VanityUrlService)SpringContextSingleton.getBean("org.jahia.services.seo.jcr.VanityUrlService");
            String ctx = StringUtils.defaultIfEmpty((String)hsRequest.getContextPath(), (String)"");
            String fullUrl = ctx + Render.getRenderServletPath() + outboundUrl;
            hsRequest.setAttribute(VANITY_KEY, (Object)fullUrl);
            if (StringUtils.isNotEmpty((String)outboundUrl) && !Url.isLocalhost(hsRequest.getServerName())) {
                String serverName = null;
                String siteKey = null;
                String contextToCheck = outboundContext;
                int schemaDelimiterIndex = outboundContext.indexOf("://");
                if (schemaDelimiterIndex != -1) {
                    try {
                        URI uri = new URI(outboundContext);
                        siteKey = VanityUrlMapper.lookupSiteKeyByServerName(uri.getHost());
                        if (siteKey != null) {
                            contextToCheck = uri.getPath();
                            StringBuffer sb = new StringBuffer().append(uri.getScheme()).append("://").append(uri.getHost());
                            if (uri.getPort() != -1) {
                                sb.append(':').append(uri.getPort());
                            }
                            serverName = sb.toString();
                        }
                    }
                    catch (URISyntaxException uri) {}
                } else if (StringUtils.isNotEmpty((String)((String)hsRequest.getAttribute("jahiaSeoServernameForLink")))) {
                    String host = (String)hsRequest.getAttribute("jahiaSeoServernameForLink");
                    host = StringUtils.substringBefore((String)StringUtils.substringAfter((String)host, (String)"://"), (String)":");
                    siteKey = VanityUrlMapper.lookupSiteKeyByServerName(host);
                }
                if (StringUtils.equals((String)ctx, (String)contextToCheck)) {
                    String url = "/render" + outboundUrl;
                    try {
                        url = URLDecoder.decode(url, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    URLResolver urlResolver = urlResolverFactory.createURLResolver(url, hsRequest.getServerName(), hsRequest);
                    try {
                        JCRNodeWrapper node = urlResolver.getNode();
                        if (urlResolver.isMapped()) {
                            VanityUrl vanityUrl;
                            RenderContext context = (RenderContext)hsRequest.getAttribute("renderContext");
                            if (siteKey == null) {
                                String string = siteKey = context != null ? context.getSite().getSiteKey() : node.getResolveSite().getSiteKey();
                            }
                            if ((vanityUrl = vanityUrlService.getVanityUrlForWorkspaceAndLocale(node, urlResolver.getWorkspace(), urlResolver.getLocale(), siteKey)) != null && vanityUrl.isActive()) {
                                String macroExtension = "";
                                if (fullUrl.matches("(.?)*##[a-zA-Z]*##$")) {
                                    macroExtension = "##" + StringUtils.substringBetween((String)fullUrl, (String)"##") + "##";
                                }
                                hsRequest.setAttribute(VANITY_KEY, (Object)(ctx + Render.getRenderServletPath() + "/" + urlResolver.getWorkspace() + vanityUrl.getUrl() + macroExtension));
                                if (serverName != null) {
                                    hsRequest.setAttribute("jahiaSeoServernameForLink", (Object)serverName);
                                }
                            }
                        }
                    }
                    catch (RepositoryException e) {
                        logger.debug("Error when trying to obtain vanity url", (Throwable)e);
                        if (serverName == null) break block19;
                        hsRequest.setAttribute("jahiaSeoServernameForLink", (Object)serverName);
                    }
                }
            }
        }
    }

    private static String lookupSiteKeyByServerName(String host) {
        JahiaSite site = null;
        if (SpringContextSingleton.getInstance().isInitialized()) {
            try {
                site = JahiaSitesService.getInstance().getSiteByServerName(host);
            }
            catch (JahiaException e) {
                logger.error("Error resolving site by server name '" + host + "'", (Throwable)e);
            }
        }
        return site != null ? site.getSiteKey() : "";
    }
}

