/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.jcr;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.URLResolverListener;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanityUrlService {
    private static Logger logger = LoggerFactory.getLogger(VanityUrlService.class);
    private VanityUrlManager vanityUrlManager;
    private Cache<String, List<VanityUrl>> cacheByUrl;
    public static final String CACHE_BY_URL = "vanityUrlByUrlCache";
    private static final String KEY_SEPARATOR = "___";

    public VanityUrl getVanityUrlForWorkspaceAndLocale(final JCRNodeWrapper contentNode, String workspace, Locale locale, final String siteKey) throws RepositoryException {
        return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, locale, new JCRCallback<VanityUrl>(){

            @Override
            public VanityUrl doInJCR(JCRSessionWrapper session) throws RepositoryException {
                return VanityUrlService.this.vanityUrlManager.getVanityUrlForCurrentLocale(contentNode, siteKey, session);
            }
        });
    }

    public List<VanityUrl> getVanityUrlsForCurrentLocale(JCRNodeWrapper contentNode, JCRSessionWrapper session) throws RepositoryException {
        return this.getVanityUrls(contentNode, session.getLocale().toString(), session);
    }

    public List<VanityUrl> getVanityUrls(JCRNodeWrapper contentNode, String languageCode, JCRSessionWrapper session) throws RepositoryException {
        return this.vanityUrlManager.getVanityUrls(contentNode, languageCode, session);
    }

    public boolean removeVanityUrlMapping(JCRNodeWrapper contentNode, VanityUrl vanityUrl) throws RepositoryException {
        this.cacheByUrl.flush();
        return this.vanityUrlManager.removeVanityUrlMapping(contentNode, vanityUrl, contentNode.getSession());
    }

    public boolean removeVanityUrlMappings(JCRNodeWrapper contentNode, String languageCode) throws RepositoryException {
        this.cacheByUrl.flush();
        return this.vanityUrlManager.removeVanityUrlMappings(contentNode, languageCode, contentNode.getSession());
    }

    public boolean saveVanityUrlMapping(JCRNodeWrapper contentNode, VanityUrl vanityUrl) throws RepositoryException {
        this.cacheByUrl.flush();
        return this.vanityUrlManager.saveVanityUrlMapping(contentNode, vanityUrl, contentNode.getSession());
    }

    public boolean saveVanityUrlMappings(JCRNodeWrapper contentNode, List<VanityUrl> vanityUrls, Set<String> updatedLocales) throws RepositoryException {
        this.cacheByUrl.flush();
        return this.vanityUrlManager.saveVanityUrlMappings(contentNode, vanityUrls, updatedLocales, contentNode.getSession());
    }

    public List<VanityUrl> findExistingVanityUrls(final String url, final String site, String workspace) throws RepositoryException {
        final String cacheKey = this.getCacheByUrlKey(url, site, workspace);
        List<VanityUrl> result = this.cacheByUrl.get(cacheKey);
        if (result != null) {
            return result;
        }
        return JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, workspace, null, new JCRCallback<List<VanityUrl>>(){

            @Override
            public List<VanityUrl> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                List<VanityUrl> vanityUrls = VanityUrlService.this.vanityUrlManager.findExistingVanityUrls(url, site, session);
                VanityUrlService.this.cacheByUrl.put(cacheKey, vanityUrls);
                return vanityUrls;
            }
        });
    }

    public void setVanityUrlManager(VanityUrlManager vanityUrlManager) {
        this.vanityUrlManager = vanityUrlManager;
    }

    public void setCacheService(CacheService cacheService) {
        try {
            this.cacheByUrl = cacheService.getCache(CACHE_BY_URL, true);
        }
        catch (JahiaInitializationException e) {
            logger.error("Error while creating cache: vanityUrlByUrlCache");
        }
    }

    public String getCacheByUrlKey(String url, String site, String workspace) {
        StringBuilder builder = new StringBuilder(url);
        builder.append(KEY_SEPARATOR);
        builder.append(site);
        builder.append(KEY_SEPARATOR);
        builder.append(workspace);
        return builder.toString();
    }

    public void setUrlResolverListener(URLResolverListener urlResolverListener) {
        urlResolverListener.setVanityUrlService(this);
    }

    public void flushCaches() {
        this.cacheByUrl.flush();
    }

    public void flushCacheEntry(String key) {
        this.cacheByUrl.remove(key);
    }
}

