/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.seo.urlrewrite;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.services.seo.urlrewrite.SessionidRemovalResponseWrapper;
import org.jahia.services.seo.urlrewrite.UrlRewriteEngine;
import org.jahia.services.seo.urlrewrite.UrlRewriteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.urlrewrite.Status;
import org.tuckey.web.filters.urlrewrite.UrlRewriteWrappedResponse;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.ServerNameMatcher;

public class UrlRewriteFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(UrlRewriteFilter.class);
    private boolean enabled = true;
    private boolean outboundRulesEnabled = true;
    private boolean statusEnabled = true;
    private String statusPath = "/modules/tools/rewrite-status";
    private ServerNameMatcher statusServerNameMatcher;
    private UrlRewriteService urlRewriteService;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled) {
            chain.doFilter(request, response);
            return;
        }
        UrlRewriteEngine urlRewriter = this.urlRewriteService.getEngine();
        HttpServletRequest hsRequest = (HttpServletRequest)request;
        Object hsResponse = this.outboundRulesEnabled ? new UrlRewriteWrappedResponse((HttpServletResponse)response, hsRequest, (UrlRewriter)urlRewriter) : (HttpServletResponse)response;
        hsResponse = new SessionidRemovalResponseWrapper(hsRequest, (HttpServletResponse)hsResponse);
        String uri = hsRequest.getRequestURI();
        logger.debug("Handling {}", (Object)uri);
        if (this.statusEnabled && uri != null && uri.startsWith(hsRequest.getContextPath() + this.statusPath) && (this.statusServerNameMatcher == null || this.statusServerNameMatcher.isMatch(request.getServerName()))) {
            this.showStatus(hsRequest, (HttpServletResponse)hsResponse);
            return;
        }
        this.urlRewriteService.prepareInbound(hsRequest, (HttpServletResponse)hsResponse);
        if (!urlRewriter.processRequest(hsRequest, (HttpServletResponse)hsResponse, chain)) {
            chain.doFilter((ServletRequest)hsRequest, (ServletResponse)hsResponse);
        } else if (hsRequest.getAttribute("UrlRewriteFilter.sendError") != null) {
            hsResponse.sendError(Integer.valueOf((String)hsRequest.getAttribute("UrlRewriteFilter.sendError")).intValue());
        }
    }

    public void init(FilterConfig cfg) throws ServletException {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setOutboundRulesEnabled(boolean outboundRulesEnabled) {
        this.outboundRulesEnabled = outboundRulesEnabled;
    }

    public void setUrlRewriteService(UrlRewriteService urlRewriteService) {
        this.urlRewriteService = urlRewriteService;
    }

    protected void showStatus(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Status status = new Status(this.urlRewriteService.getEngine().getConf());
        status.displayStatusInContainer(request);
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(status.getBuffer().length());
        PrintWriter out = response.getWriter();
        out.write(status.getBuffer().toString());
        out.close();
    }
}

