/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistry {
    private static final Ordering<String> CASE_INSENSITIVE_ORDERING = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER);
    private static Logger logger = LoggerFactory.getLogger(ComponentRegistry.class);

    private static boolean allowType(ExtendedNodeType t, List<String> includeTypeList, List<String> excludeTypeList) {
        boolean include = true;
        String typeName = t.getName();
        if (excludeTypeList != null && !excludeTypeList.isEmpty()) {
            boolean bl = include = !excludeTypeList.contains(typeName);
            if (include) {
                for (String s : excludeTypeList) {
                    if (!t.isNodeType(s)) continue;
                    include = false;
                    break;
                }
            }
        }
        if (!include) {
            return false;
        }
        if (includeTypeList != null && !includeTypeList.isEmpty()) {
            include = false;
            include = includeTypeList.contains(typeName);
            if (!include) {
                for (String s : includeTypeList) {
                    if (!t.isNodeType(s)) continue;
                    include = true;
                    break;
                }
            }
        }
        return include;
    }

    public static Map<String, String> getComponentTypes(JCRNodeWrapper node, List<String> includeTypeList, List<String> excludeTypeList, Locale displayLocale) throws PathNotFoundException, RepositoryException {
        long timer = System.currentTimeMillis();
        if (displayLocale == null) {
            displayLocale = node.getSession().getLocale();
        }
        HashMap<String, String> finalComponents = new HashMap<String, String>();
        JCRSiteNode resolvedSite = node.getResolveSite();
        String[] constraints = Patterns.SPACE.split(ConstraintsHelper.getConstraints(node));
        HashSet<String> l = new HashSet<String>();
        l.add("system-jahia");
        if (resolvedSite != null) {
            l.addAll(resolvedSite.getInstalledModulesWithAllDependencies());
        }
        for (String aPackage : l) {
            block1: for (ExtendedNodeType type : NodeTypeRegistry.getInstance().getNodeTypes(aPackage)) {
                if (!ComponentRegistry.allowType(type, includeTypeList, excludeTypeList)) continue;
                for (String s : constraints) {
                    if (finalComponents.containsKey(type.getName()) || !type.isNodeType(s)) continue;
                    finalComponents.put(type.getName(), type.getLabel(displayLocale));
                    continue block1;
                }
            }
        }
        TreeMap<String, String> sortedComponents = new TreeMap<String, String>((Comparator<String>)CASE_INSENSITIVE_ORDERING.onResultOf(Functions.forMap(finalComponents)));
        sortedComponents.putAll(finalComponents);
        if (logger.isDebugEnabled()) {
            logger.debug("Execution took {} ms", (Object)(System.currentTimeMillis() - timer));
        }
        return sortedComponents;
    }

    private boolean registerComponent(JCRNodeWrapper components, ExtendedNodeType nt) throws RepositoryException {
        if (!Arrays.asList(nt.getDeclaredSupertypeNames()).contains("jmix:accessControllableContent")) {
            return false;
        }
        boolean updated = false;
        String name = "component-" + nt.getName().replace(':', '_');
        if (!components.hasNode(name)) {
            components.addNode(name, "jnt:permission");
            updated = true;
        }
        return updated;
    }

    public int registerComponents(JahiaTemplatesPackage pkg, JCRSessionWrapper session) throws RepositoryException {
        int count = 0;
        JCRNodeWrapper modules = null;
        modules = !session.nodeExists("/modules") ? session.getRootNode().addNode("modules", "jnt:modules") : session.getNode("/modules");
        ArrayList<ExtendedNodeType> types = new ArrayList<ExtendedNodeType>();
        for (String s : pkg.getDefinitionsFiles()) {
            try {
                if (pkg.getResource(s) == null) continue;
                types.addAll(NodeTypeRegistry.getInstance().getDefinitionsFromFile(pkg.getResource(s), pkg.getId()));
            }
            catch (ParseException e) {
                logger.error("Cannot parse definitions file " + s, (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Cannot parse definitions file " + s, (Throwable)e);
            }
        }
        if (modules.hasNode(pkg.getIdWithVersion())) {
            JCRNodeWrapper permissions;
            JCRNodeWrapper module = modules.getNode(pkg.getIdWithVersion());
            boolean emptyPermissions = false;
            if (!module.hasNode("permissions")) {
                emptyPermissions = true;
                module.addNode("permissions", "jnt:permission");
            }
            if (!(permissions = module.getNode("permissions")).hasNode("components")) {
                permissions.addNode("components", "jnt:permission");
            }
            JCRNodeWrapper components = permissions.getNode("components");
            if (pkg.isDefault()) {
                NodeTypeRegistry.JahiaNodeTypeIterator nti = NodeTypeRegistry.getInstance().getNodeTypes("system-jahia");
                while (nti.hasNext()) {
                    if (!this.registerComponent(components, (ExtendedNodeType)nti.nextNodeType())) continue;
                    ++count;
                }
            }
            for (ExtendedNodeType type : types) {
                if (!this.registerComponent(components, type)) continue;
                ++count;
            }
            if (count == 0) {
                components.remove();
                if (emptyPermissions) {
                    permissions.remove();
                }
            }
        } else {
            logger.warn("Unable to find module node for path {}. Skip registering components for module {}.", (Object)(modules.getPath() + "/" + pkg.getId()), (Object)pkg.getName());
        }
        session.save();
        return count;
    }
}

