/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.jahia.bin.Action;
import org.jahia.bin.errors.ErrorHandler;
import org.jahia.commons.Version;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleReleaseInfo;
import org.jahia.data.templates.ModuleState;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.rules.BackgroundAction;
import org.jahia.services.modulemanager.ModuleManager;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.templates.ForgeHelper;
import org.jahia.services.templates.ModuleBuildHelper;
import org.jahia.services.templates.ModuleInstallationHelper;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.templates.SourceControlFactory;
import org.jahia.services.templates.SourceControlHelper;
import org.jahia.services.templates.SourceControlManagement;
import org.jahia.services.templates.TemplatePackageDeployer;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.utils.DateUtils;
import org.jahia.utils.PomUtils;
import org.jahia.utils.i18n.ResourceBundles;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class JahiaTemplateManagerService
extends JahiaService
implements ApplicationEventPublisherAware,
ApplicationListener<ApplicationEvent> {
    private static final Logger logger = LoggerFactory.getLogger(JahiaTemplateManagerService.class);
    public static final Set<String> DEFAULT_MODULES_WITH_NO_DEFAUL_DEPENDENCY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("default", "jquery", "ckeditor", "assets")));
    public static final String MODULE_TYPE_MODULE = "module";
    public static final String MODULE_TYPE_SYSTEM = "system";
    public static final String MODULE_TYPE_TEMPLATES_SET = "templatesSet";
    public static final Comparator<JahiaTemplatesPackage> TEMPLATE_PACKAGE_NAME_COMPARATOR = new Comparator<JahiaTemplatesPackage>(){

        @Override
        public int compare(JahiaTemplatesPackage o1, JahiaTemplatesPackage o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    };
    private Map<Bundle, ModuleState> moduleStates = new ConcurrentSkipListMap<Bundle, ModuleState>();
    private final Map<Bundle, JahiaTemplatesPackage> registeredBundles = new ConcurrentHashMap<Bundle, JahiaTemplatesPackage>();
    private final Set<Bundle> installedBundles = Sets.newConcurrentHashSet();
    private final Set<Bundle> initializedBundles = Sets.newConcurrentHashSet();
    private final Map<String, List<Bundle>> toBeResolved = new ConcurrentHashMap<String, List<Bundle>>();
    private final OutputFormat prettyPrint = OutputFormat.createPrettyPrint();
    private TemplatePackageDeployer templatePackageDeployer;
    private TemplatePackageRegistry templatePackageRegistry;
    private JahiaSitesService siteService;
    private ApplicationEventPublisher applicationEventPublisher;
    private ModuleBuildHelper moduleBuildHelper;
    private ModuleInstallationHelper moduleInstallationHelper;
    private SourceControlHelper scmHelper;
    private ForgeHelper forgeHelper;
    private List<String> nonManageableModules;
    private Set<String> modulesWithNoDefaultDependency = DEFAULT_MODULES_WITH_NO_DEFAUL_DEPENDENCY;
    private Set<String> knownFragmentHosts = Collections.emptySet();
    private ModuleManager moduleManager;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setSiteService(JahiaSitesService siteService) {
        this.siteService = siteService;
    }

    public void setTemplatePackageRegistry(TemplatePackageRegistry registry) {
        this.templatePackageRegistry = registry;
    }

    public void setTemplatePackageDeployer(TemplatePackageDeployer deployer) {
        this.templatePackageDeployer = deployer;
        deployer.setService(this);
    }

    public TemplatePackageDeployer getTemplatePackageDeployer() {
        return this.templatePackageDeployer;
    }

    public TemplatePackageRegistry getTemplatePackageRegistry() {
        return this.templatePackageRegistry;
    }

    public SourceControlFactory getSourceControlFactory() {
        return this.scmHelper.getSourceControlFactory();
    }

    public void setXmlIndentation(int i) {
        this.prettyPrint.setIndentSize(i);
    }

    public List<String> getNonManageableModules() {
        return this.nonManageableModules;
    }

    public void setNonManageableModules(List<String> nonManageableModules) {
        this.nonManageableModules = nonManageableModules;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof TemplatePackageRedeployedEvent) {
            ResourceBundles.flushCache();
            NodeTypeRegistry.getInstance().flushLabels();
        }
    }

    public JCRNodeWrapper checkoutModule(File moduleSources, String scmURI, String branchOrTag, String moduleId, String version, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        return this.scmHelper.checkoutModule(moduleSources, scmURI, branchOrTag, moduleId, version, session);
    }

    public File checkoutTempModule(String scmURI, String branchOrTag, String moduleId, String version) throws RepositoryException, XmlPullParserException, DocumentException, IOException {
        return this.scmHelper.checkoutTmpModule(moduleId, version, scmURI, branchOrTag);
    }

    public JahiaTemplatesPackage duplicateModule(String moduleName, String moduleId, String groupId, String srcPath, String scmURI, String branchOrTag, String srcModuleId, String srcModuleVersion, boolean uninstallSrcModule, String dstPath, boolean deleteSrcFolder, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        return this.moduleBuildHelper.duplicateModule(moduleName, moduleId, groupId, srcPath, scmURI, branchOrTag, srcModuleId, srcModuleVersion, uninstallSrcModule, dstPath, deleteSrcFolder, session);
    }

    public JCRNodeWrapper createModule(String moduleName, String artifactId, String groupId, String moduleType, File sources, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        return this.moduleBuildHelper.createModule(moduleName, artifactId, groupId, moduleType, sources, session);
    }

    public JahiaTemplatesPackage deployModule(File warFile, JCRSessionWrapper session) throws RepositoryException {
        return this.templatePackageDeployer.deployModule(warFile, session);
    }

    public JahiaTemplatesPackage compileAndDeploy(String moduleId, File sources, JCRSessionWrapper session) throws RepositoryException, IOException, BundleException {
        JahiaTemplatesPackage templatesPackage = this.moduleBuildHelper.compileAndDeploy(moduleId, sources, session);
        File file = new File(sources, "src/main/import/repository.xml.generated");
        if (file.exists()) {
            file.delete();
        }
        this.regenerateImportFile(moduleId, sources, session);
        return templatesPackage;
    }

    public File compileModule(File sources) throws IOException {
        return this.moduleBuildHelper.compileModule(sources).getFile();
    }

    public JCRNodeWrapper installFromSources(File sources, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        if (!sources.exists()) {
            return null;
        }
        File pom = new File(sources, "pom.xml");
        try {
            Model model = PomUtils.read(pom);
            JahiaTemplatesPackage pack = this.compileAndDeploy(model.getArtifactId(), sources, session);
            pack.setSourcesFolder(sources);
            JCRNodeWrapper node = session.getNode("/modules/" + pack.getIdWithVersion());
            node.getNode("j:versionInfo").setProperty("j:sourcesFolder", sources.getPath());
            session.save();
            return node;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Cannot parse pom.xml file at " + pom, e);
        }
    }

    public File getSources(JahiaTemplatesPackage pack, JCRSessionWrapper session) throws RepositoryException {
        File sources;
        JCRNodeWrapper vi;
        if (pack.getSourcesFolder() != null) {
            return pack.getSourcesFolder();
        }
        JCRNodeWrapper n = session.getNode("/modules/" + pack.getIdWithVersion());
        if (n.hasNode("j:versionInfo") && (vi = n.getNode("j:versionInfo")).hasProperty("j:sourcesFolder") && this.checkValidSources(pack, sources = new File(vi.getProperty("j:sourcesFolder").getString()))) {
            pack.setSourcesFolder(sources);
            return sources;
        }
        return null;
    }

    public void sendToSourceControl(String moduleId, String scmURI, String scmType, JCRSessionWrapper session) throws RepositoryException, IOException {
        this.scmHelper.sendToSourceControl(moduleId, scmURI, scmType, session);
    }

    public Map<String, String> listTags(String scmURI) throws IOException {
        return this.scmHelper.listTags(scmURI);
    }

    public Map<String, String> listBranches(String scmURI) throws IOException {
        return this.scmHelper.listBranches(scmURI);
    }

    public String guessBranchOrTag(String moduleVersion, String scm, Set<String> branchOrTags) {
        return this.scmHelper.guessBranchOrTag(moduleVersion, scm, branchOrTags);
    }

    public boolean checkValidSources(JahiaTemplatesPackage pack, File sources) {
        return this.scmHelper.checkValidSources(pack, sources);
    }

    public File releaseModule(String moduleId, ModuleReleaseInfo releaseInfo, JCRSessionWrapper session) throws RepositoryException, IOException, BundleException {
        File sources;
        JahiaTemplatesPackage pack = this.templatePackageRegistry.lookupById(moduleId);
        if (pack.getVersion().isSnapshot() && releaseInfo != null && releaseInfo.getNextVersion() != null && (sources = this.getSources(pack, session)) != null) {
            SourceControlManagement scm;
            JCRNodeWrapper vi = session.getNode("/modules/" + pack.getIdWithVersion() + "/j:versionInfo");
            this.regenerateImportFile(moduleId, sources, session);
            if (vi.hasProperty("j:scmURI") && (scm = pack.getSourceControl()) != null) {
                scm.update();
                scm.commit("Release");
                return this.releaseModule(pack, releaseInfo, sources, vi.getProperty("j:scmURI").getString(), session);
            }
            return this.releaseModule(pack, releaseInfo, sources, null, session);
        }
        return null;
    }

    public File releaseModule(JahiaTemplatesPackage module, ModuleReleaseInfo releaseInfo, File sources, String scmUrl, JCRSessionWrapper session) throws RepositoryException, IOException, BundleException {
        File generatedWar;
        Model model;
        File pom = new File(sources, "pom.xml");
        try {
            model = PomUtils.read(pom);
            if (scmUrl != null && !StringUtils.equals((String)model.getScm().getConnection(), (String)scmUrl)) {
                PomUtils.updateScm(pom, scmUrl);
                module.getSourceControl().add(pom);
                module.getSourceControl().commit("restore pom scm uri before release");
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        String lastVersion = PomUtils.getVersion(model);
        if (!lastVersion.endsWith("-SNAPSHOT")) {
            throw new IOException("Cannot release a non-SNAPSHOT version");
        }
        String releaseVersion = StringUtils.substringBefore((String)lastVersion, (String)"-SNAPSHOT");
        try {
            generatedWar = this.moduleBuildHelper.releaseModuleInternal(model, lastVersion, releaseVersion, releaseInfo, sources, scmUrl);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        File releasedModules = new File(this.settingsBean.getJahiaVarDiskPath(), "released-modules");
        if (!generatedWar.exists()) {
            throw new IOException("Module release failed.");
        }
        FileUtils.moveFileToDirectory((File)generatedWar, (File)releasedModules, (boolean)true);
        generatedWar = new File(releasedModules, generatedWar.getName());
        this.moduleManager.install((Resource)new FileSystemResource(generatedWar), null);
        JahiaTemplatesPackage pack = this.compileAndDeploy(module.getId(), sources, session);
        JCRNodeWrapper node = session.getNode("/modules/" + pack.getIdWithVersion());
        node.getNode("j:versionInfo").setProperty("j:sourcesFolder", sources.getPath());
        if (scmUrl != null) {
            node.getNode("j:versionInfo").setProperty("j:scmURI", scmUrl);
        }
        session.save();
        this.undeployModule(module);
        this.activateModuleVersion(module.getId(), releaseInfo.getNextVersion());
        if (releaseInfo.isPublishToMaven() || releaseInfo.isPublishToForge()) {
            releaseInfo.setArtifactUrl(this.forgeHelper.computeModuleJarUrl(releaseVersion, releaseInfo, model));
            if (releaseInfo.isPublishToForge() && releaseInfo.getForgeUrl() != null) {
                String forgeModuleUrl = this.forgeHelper.createForgeModule(releaseInfo, generatedWar);
                releaseInfo.setForgeModulePageUrl(forgeModuleUrl);
            } else if (releaseInfo.isPublishToMaven() && releaseInfo.getRepositoryUrl() != null) {
                this.deployToMaven(PomUtils.getGroupId(model), model.getArtifactId(), releaseInfo, generatedWar);
            }
        }
        return generatedWar;
    }

    public void deployToMaven(String groupId, String artifactId, ModuleReleaseInfo releaseInfo, File generatedWar) throws IOException {
        this.moduleBuildHelper.deployToMaven(groupId, artifactId, releaseInfo, generatedWar);
    }

    public List<File> regenerateImportFile(final String moduleId, final File sources, JCRSessionWrapper session) throws RepositoryException {
        logger.info("Re-generating initial import file for module {} in source folder {}", (Object)moduleId, (Object)sources);
        long startTime = System.currentTimeMillis();
        final ArrayList<File> modifiedFiles = new ArrayList<File>();
        if (session.getLocale() != null) {
            logger.error("Cannot generated export with i18n session");
            return modifiedFiles;
        }
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(session.getUser(), null, null, new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper localSession) throws RepositoryException {
                JahiaTemplatesPackage aPackage = JahiaTemplateManagerService.this.getTemplatePackageById(moduleId);
                SourceControlManagement scm = null;
                try {
                    scm = JahiaTemplateManagerService.this.getTemplatePackageById(moduleId).getSourceControl();
                }
                catch (Exception e) {
                    logger.error("Cannot get SCM", (Throwable)e);
                }
                try {
                    JahiaTemplateManagerService.this.moduleBuildHelper.regenerateImportFile(localSession, modifiedFiles, sources, moduleId, aPackage.getIdWithVersion());
                    if (scm != null) {
                        try {
                            scm.add(modifiedFiles);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                catch (IOException | RepositoryException | TransformerException | SAXException e1) {
                    logger.error(e1.getMessage(), e1);
                }
                return null;
            }
        });
        logger.info("Initial import for module {} re-generated in {}", (Object)moduleId, (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - startTime));
        return modifiedFiles;
    }

    private void setDependenciesInPom(File sources, List<String> dependencies, boolean useProperties) {
        File pom = new File(sources, "pom.xml");
        try {
            PomUtils.updateJahiaDepends(pom, StringUtils.join(dependencies, (String)","), useProperties);
        }
        catch (Exception e) {
            logger.error("Unable to updated dependencies in pom file: " + pom, (Throwable)e);
        }
    }

    public void updateDependencies(JahiaTemplatesPackage pack, List<String> depends) {
        pack.getDepends().clear();
        pack.getDepends().addAll(depends);
        this.templatePackageRegistry.computeDependencies(pack);
        if (pack.getSourcesFolder() != null) {
            this.setDependenciesInPom(pack.getSourcesFolder(), depends, this.shouldUsePropertiesInPom(pack));
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ModuleDependenciesEvent(pack.getId(), this));
    }

    private boolean shouldUsePropertiesInPom(JahiaTemplatesPackage pack) {
        boolean useProperties = false;
        String jahiaRequiredVersion = (String)pack.getBundle().getHeaders().get("Jahia-Required-Version");
        if (StringUtils.isNotEmpty((String)jahiaRequiredVersion) && new Version(jahiaRequiredVersion).compareTo(new Version("7.1.0.0")) >= 0) {
            useProperties = true;
        }
        return useProperties;
    }

    public void fireTemplatePackageRedeployedEvent(JahiaTemplatesPackage aPackage) {
        SpringContextSingleton.getInstance().publishEvent(new TemplatePackageRedeployedEvent(aPackage.getId()));
    }

    public void setSourcesFolderInPackage(JahiaTemplatesPackage pack, File sources) {
        this.scmHelper.setSourcesFolderInPackage(pack, sources);
    }

    public List<JahiaTemplatesPackage> getInstalledModulesForSite(String siteKey, boolean includeTemplateSet, boolean includeDirectDependencies, boolean includeTransitiveDependencies) throws JahiaException {
        JahiaSite site = this.siteService.getSiteByKey(siteKey);
        if (site == null) {
            throw new JahiaException("Site cannot be found for key " + siteKey, "Site cannot be found for key " + siteKey, 40, 2);
        }
        List<String> installedModules = site.getInstalledModules();
        if (!includeTemplateSet) {
            if (installedModules.size() > 1) {
                installedModules = installedModules.subList(1, installedModules.size());
                Collections.sort(installedModules);
            } else {
                installedModules = Collections.emptyList();
            }
        }
        TreeSet<String> modules = new TreeSet<String>();
        if (includeDirectDependencies) {
            modules.addAll(installedModules);
        }
        if (includeTransitiveDependencies) {
            this.includeTransitiveModuleDependencies(installedModules, modules);
        }
        Map<String, SortedMap<ModuleVersion, JahiaTemplatesPackage>> all = this.templatePackageRegistry.getAllModuleVersions();
        LinkedList packages = new LinkedList();
        for (String m : modules) {
            JahiaTemplatesPackage pkg = this.getTemplatePackageById(m);
            JahiaTemplatesPackage jahiaTemplatesPackage = pkg = pkg != null ? pkg : this.getTemplatePackage(m);
            if (pkg == null && all.containsKey(m)) {
                pkg = (JahiaTemplatesPackage)all.get(m).get(all.get(m).firstKey());
            }
            if (pkg == null) continue;
            packages.add(pkg);
        }
        return packages.isEmpty() ? Collections.emptyList() : packages;
    }

    private void includeTransitiveModuleDependencies(List<String> installedModules, Set<String> modules) {
        for (String m : installedModules) {
            JahiaTemplatesPackage pkg = this.getTemplatePackageById(m);
            pkg = pkg != null ? pkg : this.getTemplatePackage(m);
            if (pkg == null) continue;
            for (JahiaTemplatesPackage deps : pkg.getDependencies()) {
                if (installedModules.contains(deps.getId())) continue;
                modules.add(deps.getId());
            }
        }
    }

    public void autoInstallModulesToSites(JahiaTemplatesPackage module, JCRSessionWrapper session) throws RepositoryException {
        this.moduleInstallationHelper.autoInstallModulesToSites(module, session);
    }

    public void installModuleOnAllSites(JahiaTemplatesPackage module, JCRSessionWrapper sessionWrapper, List<JCRNodeWrapper> sites) throws RepositoryException {
        this.moduleInstallationHelper.installModuleOnAllSites(module, sessionWrapper, sites);
    }

    public void installModule(String moduleId, String sitePath, String username) throws RepositoryException {
        this.moduleInstallationHelper.installModule(moduleId, sitePath, username);
    }

    public void installModule(String moduleId, String version, String sitePath, String username) throws RepositoryException {
        this.moduleInstallationHelper.installModule(moduleId, version, sitePath, username);
    }

    public void installModule(JahiaTemplatesPackage module, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        this.installModules(Collections.singletonList(module), sitePath, session);
    }

    public void installModules(List<JahiaTemplatesPackage> modules, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        this.moduleInstallationHelper.installModules(modules, sitePath, session);
    }

    public void synchro(JCRNodeWrapper source, JCRNodeWrapper destinationNode, JCRSessionWrapper session, String moduleName, Map<String, List<String>> references) throws RepositoryException {
        this.moduleInstallationHelper.synchro(source, destinationNode, session, moduleName, references);
    }

    public void templatesSynchro(JCRNodeWrapper source, JCRNodeWrapper destinationNode, JCRSessionWrapper session, Map<String, List<String>> references, boolean doUpdate, boolean doChildren) throws RepositoryException {
        this.moduleInstallationHelper.templatesSynchro(source, destinationNode, session, references, doUpdate, doChildren);
    }

    public void uninstallModule(String module, String sitePath, String username, boolean purgeAllContent) throws RepositoryException {
        this.moduleInstallationHelper.uninstallModule(module, sitePath, username, purgeAllContent);
    }

    public void uninstallModule(JahiaTemplatesPackage module, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        this.uninstallModules(Collections.singletonList(module), sitePath, session);
    }

    public void uninstallModules(List<JahiaTemplatesPackage> modules, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (JahiaTemplatesPackage module : modules) {
            moduleIds.add(module.getId());
        }
        this.moduleInstallationHelper.uninstallModules(moduleIds, sitePath, session);
    }

    public void uninstallModulesByIds(List<String> moduleIds, String sitePath, JCRSessionWrapper session) throws RepositoryException {
        this.moduleInstallationHelper.uninstallModules(moduleIds, sitePath, session);
    }

    public void uninstallModulesFromAllSites(String module, String username, boolean purgeAllContent) throws RepositoryException {
        this.moduleInstallationHelper.uninstallModulesFromAllSites(module, username, purgeAllContent);
    }

    public void uninstallModulesFromAllSites(String module, JCRSessionWrapper session) throws RepositoryException {
        this.uninstallModulesFromAllSites(Collections.singletonList(module), session);
    }

    public void uninstallModulesFromAllSites(List<String> modules, JCRSessionWrapper session) throws RepositoryException {
        this.moduleInstallationHelper.uninstallModulesFromAllSites(modules, session);
    }

    public boolean checkExistingContent(String module) throws RepositoryException {
        return this.moduleInstallationHelper.checkExistingContent(module);
    }

    public List<JahiaTemplatesPackage> getAvailableTemplatePackages() {
        return this.templatePackageRegistry.getAvailablePackages();
    }

    public List<JahiaTemplatesPackage> getNonSystemTemplateSetPackages() {
        int packagesCount = this.getAvailableTemplatePackagesCount();
        if (packagesCount > 0) {
            ArrayList<JahiaTemplatesPackage> result = new ArrayList<JahiaTemplatesPackage>(packagesCount);
            for (JahiaTemplatesPackage templatePackage : this.getAvailableTemplatePackages()) {
                if (!templatePackage.getModuleType().equals(MODULE_TYPE_TEMPLATES_SET) || templatePackage.getId().equals("templates-system")) continue;
                result.add(templatePackage);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<JahiaTemplatesPackage> getNonSystemModulePackages() {
        int packagesCount = this.getAvailableTemplatePackagesCount();
        if (packagesCount > 0) {
            ArrayList<JahiaTemplatesPackage> result = new ArrayList<JahiaTemplatesPackage>(packagesCount);
            for (JahiaTemplatesPackage templatePackage : this.getAvailableTemplatePackages()) {
                if (templatePackage.getModuleType().equals(MODULE_TYPE_TEMPLATES_SET) || templatePackage.getModuleType().equals(MODULE_TYPE_SYSTEM)) continue;
                result.add(templatePackage);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public int getAvailableTemplatePackagesCount() {
        return this.templatePackageRegistry.getAvailablePackagesCount();
    }

    public Map<String, Action> getActions() {
        return this.templatePackageRegistry.getActions();
    }

    public Map<String, BackgroundAction> getBackgroundActions() {
        return this.templatePackageRegistry.getBackgroundActions();
    }

    public List<ErrorHandler> getErrorHandler() {
        return this.templatePackageRegistry.getErrorHandlers();
    }

    public JahiaTemplatesPackage getTemplatePackageByFileName(String fileName) {
        return this.getTemplatePackageById(fileName);
    }

    public JahiaTemplatesPackage getTemplatePackageById(String moduleId) {
        return this.templatePackageRegistry.lookupById(moduleId);
    }

    public List<RenderFilter> getRenderFilters() {
        return this.templatePackageRegistry.getRenderFilters();
    }

    public Set<JahiaTemplatesPackage> getModulesWithViewsForComponent(String componentName) {
        Set<JahiaTemplatesPackage> r = this.templatePackageRegistry.getModulesWithViewsPerComponents().get(StringUtils.replaceChars((String)componentName, (char)':', (char)'_'));
        return r != null ? r : Collections.emptySet();
    }

    public JahiaTemplatesPackage getTemplatePackage(String packageName) {
        return this.templatePackageRegistry.lookup(packageName);
    }

    public Map<String, JahiaTemplatesPackage> getTemplatePackageByNodeName() {
        return LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return JahiaTemplateManagerService.this.templatePackageRegistry.lookupById(String.valueOf(input));
            }
        });
    }

    public JahiaTemplatesPackage getAnyDeployedTemplatePackage(String templatePackage) {
        Set<ModuleVersion> versions;
        JahiaTemplatesPackage pack = this.getTemplatePackageById(templatePackage);
        if (pack == null && !(versions = this.getTemplatePackageRegistry().getAvailableVersionsForModule(templatePackage)).isEmpty() && (pack = this.getTemplatePackageRegistry().lookupByIdAndVersion(templatePackage, versions.iterator().next())) == null) {
            pack = this.getTemplatePackageRegistry().lookupByNameAndVersion(templatePackage, versions.iterator().next());
        }
        return pack;
    }

    public Set<String> getTemplateSetNames() {
        try {
            return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Set<String>>(){

                @Override
                public Set<String> doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    QueryManagerWrapper qm = session.getWorkspace().getQueryManager();
                    TreeSet<String> templateSets = new TreeSet<String>();
                    NodeIterator nodes = qm.createQuery("select * from [jnt:module] as module inner join [jnt:moduleVersion] as version on ischildnode(version,module) where isdescendantnode(module,'/modules') and name(module) <> 'templates-system' and version.[j:moduleType]='templatesSet'", "JCR-SQL2").execute().getNodes();
                    while (nodes.hasNext()) {
                        Node node = nodes.nextNode();
                        if (JahiaTemplateManagerService.this.getTemplatePackageById(node.getName()) == null) continue;
                        templateSets.add(node.getName());
                    }
                    return templateSets;
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Unable to get template set names. Cause: " + e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    public JahiaTemplatesPackage activateModuleVersion(String moduleId, String version) throws RepositoryException, BundleException {
        JahiaTemplatesPackage module = this.templatePackageRegistry.lookupByIdAndVersion(moduleId, new ModuleVersion(version));
        module.getBundle().start();
        return module;
    }

    public JahiaTemplatesPackage stopModule(String moduleId) throws RepositoryException, BundleException {
        JahiaTemplatesPackage module = this.templatePackageRegistry.lookupById(moduleId);
        module.getBundle().stop();
        return module;
    }

    public void undeployModule(String moduleId, String version) throws RepositoryException {
        this.templatePackageDeployer.undeployModule(moduleId, version);
    }

    public void undeployModule(JahiaTemplatesPackage pack) throws RepositoryException {
        this.templatePackageDeployer.undeployModule(pack.getId(), pack.getVersion().toString());
    }

    public boolean isTemplatePresent(String templateName, String templateSetName) {
        return this.isTemplatePresent(templateName, (Set<String>)ImmutableSet.of((Object)templateSetName));
    }

    public boolean isTemplatePresent(final String templateName, final Set<String> templateSetNames) {
        long timer = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Checking presense of the template {} in modules {}", (Object)templateName, templateSetNames);
        }
        if (StringUtils.isEmpty((String)templateName)) {
            throw new IllegalArgumentException("Template path is either null or empty");
        }
        if (templateSetNames == null || templateSetNames.isEmpty()) {
            throw new IllegalArgumentException("The template/module set to check is empty");
        }
        boolean present = true;
        try {
            present = JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Boolean>(){

                @Override
                public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    return JahiaTemplateManagerService.this.isTemplatePresent(templateName, templateSetNames, session);
                }
            });
        }
        catch (RepositoryException e) {
            logger.error("Unable to check presence of the template '" + templateName + "' in the modules '" + templateSetNames + "'. Cause: " + e.getMessage(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Template {} {} in modules {} in {} ms", (Object[])new String[]{templateName, present ? "found" : "cannot be found", templateSetNames.toString(), String.valueOf(System.currentTimeMillis() - timer)});
        }
        return present;
    }

    private boolean isTemplatePresent(String templateName, Set<String> templateSetNames, JCRSessionWrapper session) throws RepositoryException {
        QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
        StringBuilder query = new StringBuilder(512);
        query.append("select * from [jnt:template] as t inner join [jnt:virtualsite] as ts on isdescendantnode(t, ts) where isdescendantnode(ts, '/modules') and name(t)='");
        query.append(templateName).append("' and (");
        boolean first = true;
        for (String module : templateSetNames) {
            if (!first) {
                query.append(" OR ");
            } else {
                first = false;
            }
            query.append("name(ts)='").append(module).append("'");
        }
        query.append(")");
        if (logger.isDebugEnabled()) {
            logger.debug("Executing query {}", (Object)query.toString());
        }
        return queryManager.createQuery(query.toString(), "JCR-SQL2").execute().getNodes().hasNext();
    }

    public Map<Bundle, ModuleState> getModuleStates() {
        return this.moduleStates;
    }

    public Map<Bundle, JahiaTemplatesPackage> getRegisteredBundles() {
        return this.registeredBundles;
    }

    public Set<Bundle> getInstalledBundles() {
        return this.installedBundles;
    }

    public Set<Bundle> getInitializedBundles() {
        return this.initializedBundles;
    }

    public Map<String, List<Bundle>> getToBeResolved() {
        return this.toBeResolved;
    }

    public List<Bundle> getModulesByState(ModuleState.State state) {
        LinkedList<Bundle> modules = new LinkedList<Bundle>();
        for (Map.Entry<Bundle, ModuleState> entry : this.moduleStates.entrySet()) {
            if (!entry.getValue().getState().equals((Object)state)) continue;
            modules.add(entry.getKey());
        }
        return !modules.isEmpty() ? modules : Collections.emptyList();
    }

    public void setModuleStates(Map<Bundle, ModuleState> moduleStates) {
        this.moduleStates = moduleStates;
    }

    public boolean differentModuleWithSameIdExists(String symbolicName, String groupId) {
        SortedMap<ModuleVersion, JahiaTemplatesPackage> moduleVersions = this.templatePackageRegistry.getAllModuleVersions().get(symbolicName);
        return moduleVersions != null && !moduleVersions.isEmpty() && !((JahiaTemplatesPackage)moduleVersions.get(moduleVersions.firstKey())).getGroupId().equals(groupId);
    }

    public void setModuleInstallationHelper(ModuleInstallationHelper moduleInstallationHelper) {
        this.moduleInstallationHelper = moduleInstallationHelper;
    }

    public final boolean hasEncounteredIssuesWithDefinitions() {
        return this.templatePackageRegistry.hasEncounteredIssuesWithDefinitions();
    }

    public void setSourceControlHelper(SourceControlHelper scmHelper) {
        this.scmHelper = scmHelper;
    }

    public void setModuleBuildHelper(ModuleBuildHelper moduleBuildHelper) {
        this.moduleBuildHelper = moduleBuildHelper;
    }

    public void setForgeHelper(ForgeHelper forgeHelper) {
        this.forgeHelper = forgeHelper;
    }

    public Set<String> getModulesWithNoDefaultDependency() {
        return this.modulesWithNoDefaultDependency;
    }

    public void setModulesWithNoDefaultDependency(Set<String> modulesWithNoDefaultDependency) {
        if (modulesWithNoDefaultDependency != null && !modulesWithNoDefaultDependency.isEmpty()) {
            HashSet<String> modules = new HashSet<String>(modulesWithNoDefaultDependency);
            modules.add("default");
            this.modulesWithNoDefaultDependency = Collections.unmodifiableSet(modules);
        } else {
            this.modulesWithNoDefaultDependency = DEFAULT_MODULES_WITH_NO_DEFAUL_DEPENDENCY;
        }
    }

    public Set<String> getKnownFragmentHosts() {
        return this.knownFragmentHosts;
    }

    public void setKnownFragmentHosts(Set<String> knownFragmentHosts) {
        this.knownFragmentHosts = knownFragmentHosts;
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public static class ModuleDependenciesEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -6693201714720533228L;
        private final String moduleName;

        public ModuleDependenciesEvent(String moduleName, Object source) {
            super(source);
            this.moduleName = moduleName;
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }

    public static class ModuleDeployedOnSiteEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -6693201714720533228L;
        private final String targetSitePath;

        public ModuleDeployedOnSiteEvent(String targetSitePath, Object source) {
            super(source);
            this.targetSitePath = targetSitePath;
        }

        public String getTargetSitePath() {
            return this.targetSitePath;
        }
    }

    public static class TemplatePackageRedeployedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 789720524077775537L;

        public TemplatePackageRedeployedEvent(Object source) {
            super(source);
        }
    }
}

