/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.xml.transform.TransformerException;
import name.fraser.neil.plaintext.DiffMatchPatch;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.dom4j.DocumentException;
import org.jahia.commons.Version;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleReleaseInfo;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.BundleLifecycleUtils;
import org.jahia.osgi.BundleUtils;
import org.jahia.security.license.LicenseCheckException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.ModuleManager;
import org.jahia.services.modulemanager.OperationResult;
import org.jahia.services.modulemanager.util.ModuleUtils;
import org.jahia.services.notification.ToolbarWarningsService;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.templates.ScmUnavailableModuleIdException;
import org.jahia.services.templates.SourceControlException;
import org.jahia.services.templates.SourceControlHelper;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.PomUtils;
import org.jahia.utils.ProcessHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class ModuleBuildHelper
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ModuleBuildHelper.class);
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u([0-9A-Fa-f]{2})([0-9A-Fa-f]{2})");
    private String mavenExecutable;
    private String ignoreSnapshots;
    private boolean ignoreSnapshotsFlag;
    private String mavenArchetypeCatalog;
    private String mavenArchetypeVersion;
    private String mavenMinRequiredVersion;
    private String mavenReleasePlugin;
    private String mavenWarnIfVersionIsOlderThan;
    private ModuleManager moduleManager;
    private int moduleStartLevel;
    private SourceControlHelper scmHelper;
    private SettingsBean settingsBean;
    private TemplatePackageRegistry templatePackageRegistry;
    private ToolbarWarningsService toolbarWarningsService;

    private static void warnOldMavenVersion(String mvnVersionString) {
        logger.warn("");
        logger.warn("************************* DEPRECATION *************************");
        logger.warn("*                                                             *");
        logger.warn("* The version of Maven ({}), you are using, is deprecated. *", (Object)mvnVersionString);
        logger.warn("* Please, switch to a more recent one (e.g. 3.3.x).           *");
        logger.warn("*                                                             *");
        logger.warn("***************************************************************");
        logger.warn("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JahiaTemplatesPackage compileAndDeploy(String moduleId, File sources, JCRSessionWrapper session) throws RepositoryException, IOException, BundleException {
        CompiledModuleInfo moduleInfo = this.compileModule(sources);
        Bundle bundle = BundleUtils.getBundle(moduleId, moduleInfo.getVersion());
        if (bundle != null) {
            FileInputStream is = new FileInputStream(moduleInfo.getFile());
            try {
                bundle.update(ModuleUtils.addModuleDependencies(is));
                bundle.start();
                BundleLifecycleUtils.refreshBundle(bundle);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            if (BundleUtils.getContextStartException(bundle.getSymbolicName()) != null && BundleUtils.getContextStartException(bundle.getSymbolicName()) instanceof LicenseCheckException) {
                throw new IOException(BundleUtils.getContextStartException(bundle.getSymbolicName()).getLocalizedMessage());
            }
            return this.templatePackageRegistry.lookupByIdAndVersion(moduleInfo.getModuleName(), new ModuleVersion(moduleInfo.getVersion()));
        }
        OperationResult operationResult = this.moduleManager.install((Resource)new FileSystemResource(moduleInfo.getFile()), null, true);
        BundleInfo bundleInfo = operationResult.getBundleInfos().get(0);
        bundle = BundleUtils.getBundleBySymbolicName(bundleInfo.getSymbolicName(), bundleInfo.getVersion());
        JahiaTemplatesPackage pkg = BundleUtils.getModule(bundle);
        if (pkg == null) {
            throw new IOException("Cannot deploy module");
        }
        if (BundleUtils.getContextStartException(bundle.getSymbolicName()) != null && BundleUtils.getContextStartException(bundle.getSymbolicName()) instanceof LicenseCheckException) {
            throw new IOException(BundleUtils.getContextStartException(bundle.getSymbolicName()).getLocalizedMessage());
        }
        return this.templatePackageRegistry.lookupByIdAndVersion(moduleInfo.getModuleName(), new ModuleVersion(moduleInfo.getVersion()));
    }

    public CompiledModuleInfo compileModule(File sources) throws IOException {
        if (!this.isMavenConfigured()) {
            throw new JahiaRuntimeException("Cannot compile module, either current instance is not in development mode or maven configuration is not good");
        }
        File pom = new File(sources, "pom.xml");
        try {
            Model model = PomUtils.read(pom);
            String artifactId = model.getArtifactId();
            String version = PomUtils.getVersion(model);
            if (StringUtils.isEmpty((String)version)) {
                throw new IOException("No version found in pom.xml file " + pom);
            }
            StringBuilder out = new StringBuilder();
            int r = 0;
            try {
                r = ProcessHelper.execute(this.mavenExecutable, new String[]{"clean", "install", "-Dmaven.test.skip=true"}, null, sources, out, null);
            }
            catch (JahiaRuntimeException e) {
                logger.error(e.getCause().getMessage(), e.getCause());
                throw e;
            }
            if (r > 0) {
                logger.error("Compilation error, returned status " + r);
                logger.error("Maven out : " + out);
                throw new IOException(out.toString());
            }
            File file = new File(sources.getPath() + "/target/" + artifactId + "-" + version + ".jar");
            if (file.exists()) {
                return new CompiledModuleInfo(file, artifactId, version);
            }
            throw new IOException("Cannot find a module archive to deploy in folder " + file.getParentFile().getAbsolutePath());
        }
        catch (XmlPullParserException e) {
            logger.error("Error parsing pom.xml file at " + pom, (Throwable)e);
            throw new IOException("Cannot parse pom.xml file " + pom, e);
        }
    }

    public JCRNodeWrapper createModule(String moduleName, String artifactId, String groupId, String moduleType, File moduleSources, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        if (!this.isMavenConfigured()) {
            throw new JahiaRuntimeException("Cannot create module, either current instance is not in development mode or maven configuration is not good");
        }
        if (StringUtils.isBlank((String)moduleName)) {
            throw new RepositoryException("Cannot create module because no module name has been specified");
        }
        if (StringUtils.isBlank((String)artifactId)) {
            artifactId = JCRContentUtils.generateNodeName(moduleName);
        }
        if (this.templatePackageRegistry.containsId(artifactId)) {
            throw new RepositoryException("Cannot create module " + artifactId + " because another module with the same artifactId exists");
        }
        File sources = moduleSources;
        if (sources == null && !(sources = new File(SettingsBean.getInstance().getModulesSourcesDiskPath())).exists() && !sources.mkdirs()) {
            throw new IOException("Unable to create path for: " + sources);
        }
        String finalFolderName = null;
        if (!sources.exists()) {
            finalFolderName = sources.getName();
            if ((sources = sources.getParentFile()) == null) {
                sources = new File(SettingsBean.getInstance().getModulesSourcesDiskPath());
            }
            if (!sources.exists() && !sources.mkdirs()) {
                throw new IOException("Unable to create path for: " + sources);
            }
        }
        ArrayList<String> archetypeParams = new ArrayList<String>();
        archetypeParams.add("archetype:generate");
        archetypeParams.add("-DarchetypeCatalog=" + this.mavenArchetypeCatalog + ",local");
        archetypeParams.add("-DarchetypeGroupId=org.jahia.archetypes");
        archetypeParams.add("-DarchetypeArtifactId=jahia-" + moduleType + "-archetype");
        archetypeParams.add("-DarchetypeVersion=" + this.mavenArchetypeVersion);
        archetypeParams.add("-Dversion=1.0-SNAPSHOT");
        archetypeParams.add("\"-DmoduleName=" + moduleName + "\"");
        archetypeParams.add("-DartifactId=" + artifactId);
        if (StringUtils.isNotBlank((String)groupId)) {
            archetypeParams.add("-DgroupId=" + groupId);
        }
        archetypeParams.add("-DdigitalFactoryVersion=7.2.0.0");
        archetypeParams.add("-DinteractiveMode=false");
        StringBuilder out = new StringBuilder();
        int ret = ProcessHelper.execute(this.mavenExecutable, archetypeParams.toArray(new String[archetypeParams.size()]), null, sources, out, out);
        if (ret > 0) {
            logger.error("Maven archetype call returned " + ret);
            logger.error("Maven out : " + out);
            return null;
        }
        File path = new File(sources, artifactId);
        if (finalFolderName != null && !path.getName().equals(finalFolderName)) {
            try {
                File newPath = new File(sources, finalFolderName);
                FileUtils.moveDirectory((File)path, (File)newPath);
                path = newPath;
            }
            catch (IOException e) {
                logger.error("Cannot rename folder", (Throwable)e);
            }
        }
        JahiaTemplatesPackage pack = this.compileAndDeploy(artifactId, path, session);
        JCRNodeWrapper node = session.getNode("/modules/" + pack.getIdWithVersion());
        this.scmHelper.setSourcesFolderInPackageAndNode(pack, path, node);
        session.save();
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployToMaven(String groupId, String artifactId, ModuleReleaseInfo releaseInfo, File generatedJar) throws IOException {
        if (!this.isMavenConfigured()) {
            throw new JahiaRuntimeException("Cannot deploy module to maven, either current instance is not in development mode or maven configuration is not good");
        }
        File settings = null;
        File pomFile = null;
        try {
            Model pom;
            if (!StringUtils.isEmpty((String)releaseInfo.getUsername()) && !StringUtils.isEmpty((String)releaseInfo.getPassword())) {
                settings = File.createTempFile("settings", ".xml");
                BufferedWriter w = new BufferedWriter(new FileWriter(settings));
                w.write("<settings><servers><server><id>" + releaseInfo.getRepositoryId() + "</id><username>");
                w.write(releaseInfo.getUsername());
                w.write("</username><password>");
                w.write(releaseInfo.getPassword());
                w.write("</password></server></servers></settings>");
                w.close();
            }
            JarFile jar = new JarFile(generatedJar);
            pomFile = PomUtils.extractPomFromJar(jar, groupId, artifactId);
            jar.close();
            try {
                pom = PomUtils.read(pomFile);
            }
            catch (XmlPullParserException e) {
                throw new IOException(e);
            }
            String version = pom.getVersion();
            if (version == null) {
                version = pom.getParent().getVersion();
            }
            if (version == null) {
                throw new IOException("unable to read project version");
            }
            Object[] deployParams = new String[]{"deploy:deploy-file", "-Dfile=" + generatedJar, "-DrepositoryId=" + releaseInfo.getRepositoryId(), "-Durl=" + releaseInfo.getRepositoryUrl(), "-DpomFile=" + pomFile.getPath(), "-Dpackaging=" + StringUtils.substringAfterLast((String)generatedJar.getName(), (String)"."), "-DgroupId=" + PomUtils.getGroupId(pom), "-DartifactId=" + pom.getArtifactId(), "-Dversion=" + version};
            if (settings != null) {
                deployParams = (String[])ArrayUtils.addAll((Object[])deployParams, (Object[])new String[]{"--settings", settings.getPath()});
            }
            StringBuilder out = new StringBuilder();
            int ret = ProcessHelper.execute(this.mavenExecutable, (String[])deployParams, null, generatedJar.getParentFile(), out, out);
            if (ret > 0) {
                String s = this.getMavenError(out.toString());
                logger.error("Maven archetype call returned " + ret);
                logger.error("Maven out : " + out);
                throw new IOException("Maven invocation failed\n" + s);
            }
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(settings);
            FileUtils.deleteQuietly(pomFile);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)settings);
        FileUtils.deleteQuietly((File)pomFile);
    }

    private String getMavenError(String out) {
        Matcher m = Pattern.compile("^\\[ERROR\\](.*)$", 8).matcher(out);
        StringBuilder s = new StringBuilder();
        while (m.find()) {
            s.append(m.group(1)).append("\n");
        }
        return s.toString();
    }

    private String getMavenHome() throws IOException {
        String home;
        String string = home = System.getenv().get("M2_HOME") != null ? System.getenv().get("M2_HOME") : "/usr/share/maven";
        if (!new File(home).exists()) {
            throw new IOException("Maven home not found, please set your M2_HOME environment variable");
        }
        return home;
    }

    protected File releaseModuleInternal(Model model, String lastVersion, String releaseVersion, ModuleReleaseInfo releaseInfo, File sources, String scmUrl) throws IOException, XmlPullParserException {
        File generatedJar;
        if (!this.isMavenConfigured()) {
            throw new JahiaRuntimeException("Cannot release module, either current instance is not in development mode or maven configuration is not good");
        }
        String nextVersion = releaseInfo.getNextVersion();
        String artifactId = model.getArtifactId();
        File pom = new File(sources, "pom.xml");
        if (scmUrl != null) {
            String tag = StringUtils.replace((String)releaseVersion, (String)".", (String)"_");
            File tmpRepo = new File(System.getProperty("java.io.tmpdir"), "repo");
            tmpRepo.mkdir();
            String[] installParams = new String[]{this.mavenReleasePlugin + ":prepare", this.mavenReleasePlugin + ":stage", this.mavenReleasePlugin + ":clean", "-Dmaven.home=" + this.getMavenHome(), "-Dtag=" + tag, "-DreleaseVersion=" + releaseVersion, "-DdevelopmentVersion=" + nextVersion, "-DignoreSnapshots=" + this.ignoreSnapshotsFlag, "-DstagingRepository=tmp::default::" + tmpRepo.toURI().toString(), "--batch-mode"};
            StringBuilder out = new StringBuilder();
            int ret = ProcessHelper.execute(this.mavenExecutable, installParams, null, sources, out, out);
            FileUtils.deleteDirectory((File)tmpRepo);
            if (ret > 0) {
                String s = this.getMavenError(out.toString());
                logger.error("Maven release call returnedError release, maven out : " + out);
                logger.error("Error when releasing, maven out : " + out);
                ProcessHelper.execute(this.mavenExecutable, new String[]{this.mavenReleasePlugin + ":rollback"}, null, sources, out, out);
                logger.error("Rollback release : " + out);
                throw new IOException("Maven invocation failed\n" + s);
            }
            File oldJar = new File(this.settingsBean.getJahiaModulesDiskPath(), artifactId + "-" + lastVersion + ".jar");
            if (oldJar.exists()) {
                oldJar.delete();
            }
            generatedJar = new File(sources.getPath() + "/target/checkout/target/" + artifactId + "-" + releaseVersion + ".jar");
        } else {
            PomUtils.updateVersion(pom, releaseVersion);
            generatedJar = this.compileModule(sources).getFile();
            PomUtils.updateVersion(pom, nextVersion);
        }
        return generatedJar;
    }

    public void setIgnoreSnapshots(String ignoreSnapshots) {
        this.ignoreSnapshots = ignoreSnapshots;
    }

    public void setMavenArchetypeCatalog(String mavenArchetypeCatalog) {
        this.mavenArchetypeCatalog = mavenArchetypeCatalog;
    }

    public void setSettingsBean(SettingsBean settingsBean) {
        this.settingsBean = settingsBean;
    }

    public void setSourceControlHelper(SourceControlHelper scmHelper) {
        this.scmHelper = scmHelper;
    }

    public void setTemplatePackageRegistry(TemplatePackageRegistry registry) {
        this.templatePackageRegistry = registry;
    }

    private boolean isMavenConfigured() {
        return this.settingsBean.isDevelopmentMode() && this.settingsBean.isMavenExecutableSet();
    }

    private void checkMavenExecutable() {
        if (this.settingsBean.isDevelopmentMode()) {
            this.settingsBean.setMavenExecutableSet(false);
            String mavenExecutable = this.mavenExecutable;
            StringBuilder resultOut = new StringBuilder();
            try {
                String[] args = new String[]{"-version"};
                int res = 0;
                if (System.getProperty("os.name").toLowerCase().startsWith("windows") && !mavenExecutable.endsWith(".bat") && !mavenExecutable.endsWith(".cmd")) {
                    try {
                        res = ProcessHelper.execute(mavenExecutable + ".cmd", args, null, null, resultOut, null);
                        if (res == 0) {
                            mavenExecutable = mavenExecutable + ".cmd";
                        }
                    }
                    catch (JahiaRuntimeException e) {
                        mavenExecutable = mavenExecutable + ".bat";
                    }
                }
                if (res > 0 || resultOut.length() == 0) {
                    res = ProcessHelper.execute(mavenExecutable, args, null, null, resultOut, null);
                }
                if (res > 0) {
                    this.toolbarWarningsService.addMessage("warning.maven.missing");
                    logger.error("Cannot set maven executable to " + mavenExecutable + ", please check your configuration");
                    return;
                }
                String mvnVersionString = StringUtils.substringBefore((String)StringUtils.substringBetween((String)resultOut.toString(), (String)"Apache Maven ", (String)"\n"), (String)" ");
                Object[] mvnVersion = StringUtils.split((String)mvnVersionString, (String)".");
                String[] requiredVersion = StringUtils.split((String)this.mavenMinRequiredVersion, (String)".");
                boolean isValid = true;
                for (int i = 0; i < mvnVersion.length; ++i) {
                    boolean bl = isValid = Integer.parseInt(mvnVersion[i]) >= Integer.parseInt(requiredVersion[i]);
                    if (!isValid || i == requiredVersion.length - 1) break;
                }
                if (isValid) {
                    this.mavenExecutable = mavenExecutable;
                    this.settingsBean.setMavenExecutableSet(true);
                    if (new Version(mvnVersionString).compareTo(new Version(this.mavenWarnIfVersionIsOlderThan)) < 0) {
                        ModuleBuildHelper.warnOldMavenVersion(mvnVersionString);
                    }
                } else {
                    this.toolbarWarningsService.addMessage("warning.maven.wrong.version");
                    logger.error("Detected Maven Version: " + StringUtils.join((Object[])mvnVersion, (String)".") + " do not match the minimum required version " + this.mavenMinRequiredVersion);
                }
            }
            catch (Exception e) {
                this.toolbarWarningsService.addMessage("warning.maven.missing");
                logger.error("Cannot set maven executable to " + mavenExecutable + ", please check your configuration", (Throwable)e);
            }
            if (!this.settingsBean.isMavenExecutableSet()) {
                logger.error("Until maven executable is correctly set, the studio will not be available");
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.checkMavenExecutable();
        boolean isProjectInSnapshotVersion = "7.2.0.0".contains("-SNAPSHOT");
        if (this.mavenArchetypeCatalog == null || this.mavenArchetypeCatalog.length() == 0) {
            if (isProjectInSnapshotVersion) {
                this.mavenArchetypeCatalog = "https://devtools.jahia.com/nexus/content/repositories/jahia-snapshots/archetype-catalog.xml";
                if (!this.mavenArchetypeVersion.endsWith("-SNAPSHOT")) {
                    Version v = new Version(this.mavenArchetypeVersion);
                    v.getOrderedVersionNumbers().set(v.getOrderedVersionNumbers().size() - 1, (Integer)v.getOrderedVersionNumbers().get(v.getOrderedVersionNumbers().size() - 1) + 1);
                    this.mavenArchetypeVersion = v.toString() + "-SNAPSHOT";
                }
            } else {
                this.mavenArchetypeCatalog = "https://devtools.jahia.com/nexus/content/repositories/jahia-releases/archetype-catalog.xml";
            }
        }
        logger.info("Using version {} for the module archetypes from catalog {}", (Object)this.mavenArchetypeVersion, (Object)this.mavenArchetypeCatalog);
        this.ignoreSnapshotsFlag = this.ignoreSnapshots == null || this.ignoreSnapshots.length() == 0 ? isProjectInSnapshotVersion : Boolean.valueOf(this.ignoreSnapshots.trim());
        if (this.mavenReleasePlugin == null || this.mavenReleasePlugin.length() == 0) {
            this.mavenReleasePlugin = "release";
        }
    }

    public void setMavenReleasePlugin(String mavenReleasePlugin) {
        this.mavenReleasePlugin = mavenReleasePlugin;
    }

    public void setMavenMinRequiredVersion(String mavenRequiredVersion) {
        this.mavenMinRequiredVersion = mavenRequiredVersion;
    }

    public void setMavenExecutable(String mavenExecutable) {
        this.mavenExecutable = mavenExecutable;
    }

    public void setToolbarWarningsService(ToolbarWarningsService toolbarWarningsService) {
        this.toolbarWarningsService = toolbarWarningsService;
    }

    public JahiaTemplatesPackage duplicateModule(String dstModuleName, String dstModuleId, String dstGroupId, String srcPath, String scmURI, String branchOrTag, String srcModuleId, String srcModuleVersion, boolean uninstallSrcModule, String dstPath, boolean deleteSrcFolder, JCRSessionWrapper session) throws IOException, RepositoryException, BundleException {
        CompiledModuleInfo compiledModuleInfo;
        File srcFolder;
        File parentDir;
        if (StringUtils.isBlank((String)dstModuleName)) {
            throw new SourceControlException("Cannot create module because no module name has been specified");
        }
        if (StringUtils.isBlank((String)dstModuleId)) {
            dstModuleId = JCRContentUtils.generateNodeName(dstModuleName);
        }
        if (StringUtils.isBlank((String)dstGroupId)) {
            dstGroupId = "org.jahia.modules";
        }
        if (this.templatePackageRegistry.containsId(dstModuleId)) {
            throw new ScmUnavailableModuleIdException("Cannot create module " + dstModuleId + " because another module with the same artifactId exists");
        }
        if (StringUtils.isBlank((String)dstPath)) {
            dstPath = SettingsBean.getInstance().getModulesSourcesDiskPath();
        }
        if (!(parentDir = new File(dstPath)).exists() && !parentDir.mkdirs()) {
            throw new SourceControlException("Unable to create path for: " + parentDir);
        }
        File dstFolder = new File(parentDir, dstModuleId);
        int i = 0;
        while (dstFolder.exists()) {
            dstFolder = new File(parentDir, dstModuleId + "_" + ++i);
        }
        if (srcPath == null) {
            try {
                srcFolder = this.scmHelper.checkoutTmpModule(srcModuleId, srcModuleVersion, scmURI, branchOrTag);
            }
            catch (XmlPullParserException e) {
                throw new IOException(e);
            }
            catch (DocumentException e) {
                throw new IOException(e);
            }
            deleteSrcFolder = true;
        } else {
            srcFolder = new File(srcPath);
        }
        FileUtils.copyDirectory((File)srcFolder, (File)dstFolder);
        if (deleteSrcFolder) {
            FileUtils.deleteQuietly((File)srcFolder);
        }
        try {
            String dstVersion = "1.0-SNAPSHOT";
            this.updateDuplicatedPom(dstModuleName, dstModuleId, dstGroupId, dstVersion, dstFolder);
            this.cleanScmFiles(dstFolder);
            JahiaTemplatesPackage srcModule = this.templatePackageRegistry.lookupByIdAndVersion(srcModuleId, new ModuleVersion(srcModuleVersion));
            this.updateDuplicatedImportFiles(srcModule, dstModuleName, dstModuleId, dstVersion, dstFolder, session);
            this.renameDuplicatedResourceBundle(srcModule, dstModuleId, dstFolder);
            compiledModuleInfo = this.compileModule(dstFolder);
            if (uninstallSrcModule) {
                this.undeployAllModuleVersions(srcModuleId);
            }
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)dstFolder);
            throw e;
        }
        catch (RepositoryException e) {
            FileUtils.deleteQuietly((File)dstFolder);
            throw e;
        }
        catch (BundleException e) {
            FileUtils.deleteQuietly((File)dstFolder);
            throw e;
        }
        catch (RuntimeException e) {
            FileUtils.deleteQuietly((File)dstFolder);
            throw e;
        }
        OperationResult operationResult = this.moduleManager.install((Resource)new FileSystemResource(compiledModuleInfo.getFile()), null, true);
        BundleInfo bundleInfo = operationResult.getBundleInfos().get(0);
        Bundle bundle = BundleUtils.getBundleBySymbolicName(bundleInfo.getSymbolicName(), bundleInfo.getVersion());
        JahiaTemplatesPackage pkg = BundleUtils.getModule(bundle);
        if (pkg == null) {
            FileUtils.deleteQuietly((File)dstFolder);
            throw new IOException("Cannot deploy module");
        }
        if (BundleUtils.getContextStartException(bundle.getSymbolicName()) != null && BundleUtils.getContextStartException(bundle.getSymbolicName()) instanceof LicenseCheckException) {
            throw new BundleException(BundleUtils.getContextStartException(bundle.getSymbolicName()).getLocalizedMessage());
        }
        return this.templatePackageRegistry.lookupByIdAndVersion(compiledModuleInfo.getModuleName(), new ModuleVersion(compiledModuleInfo.getVersion()));
    }

    private void undeployAllModuleVersions(String srcModuleId) throws BundleException {
        Set<ModuleVersion> availableVersionsForModule = this.templatePackageRegistry.getAvailableVersionsForModule(srcModuleId);
        ModuleVersion[] versions = availableVersionsForModule.toArray(new ModuleVersion[availableVersionsForModule.size()]);
        for (int j = 0; j < versions.length; ++j) {
            Bundle bundle = this.templatePackageRegistry.lookupByIdAndVersion(srcModuleId, versions[j]).getBundle();
            int state = bundle.getState();
            if (state == 32 || state == 8) {
                bundle.stop();
            }
            bundle.uninstall();
        }
    }

    private void renameDuplicatedResourceBundle(JahiaTemplatesPackage srcModule, String dstModuleId, File dstFolder) {
        File rbFolder = new File(dstFolder, "src/main/resources/resources");
        if (rbFolder.exists()) {
            Pattern rbPattern = Pattern.compile("(" + srcModule.getId() + "|" + StringUtils.replace((String)srcModule.getName(), (String)" ", (String)"") + "|" + StringUtils.replace((String)srcModule.getName(), (String)" ", (String)"_") + ")(_[a-z]{2}(-[A-Z]{2})?)?.properties");
            File[] files = rbFolder.listFiles();
            if (files != null) {
                for (File f : files) {
                    Matcher m = rbPattern.matcher(f.getName());
                    if (!m.matches()) continue;
                    if (m.group(2) == null) {
                        f.renameTo(new File(rbFolder, dstModuleId + ".properties"));
                        continue;
                    }
                    f.renameTo(new File(rbFolder, dstModuleId + m.group(2) + ".properties"));
                }
            }
        }
    }

    private void updateDuplicatedImportFiles(JahiaTemplatesPackage srcModule, String dstModuleName, String dstModuleId, String dstVersion, File dstFolder, JCRSessionWrapper session) throws RepositoryException, IOException {
        JCRNodeWrapper srcModuleNode = session.getNode("/modules/" + srcModule.getIdWithVersion());
        JCRNodeWrapper dstModuleNode = session.getNode("/modules");
        dstModuleNode = dstModuleNode.hasNode(dstModuleId) ? dstModuleNode.getNode(dstModuleId) : dstModuleNode.addNode(dstModuleId, "jnt:module");
        dstModuleNode = dstModuleNode.hasNode(dstVersion) ? dstModuleNode.getNode(dstVersion) : dstModuleNode.addNode(dstVersion, "jnt:moduleVersion");
        for (JCRNodeWrapper node : srcModuleNode.getNodes()) {
            if (node.isNodeType("jnt:moduleVersionFolder") || node.isNodeType("jnt:versionInfo")) continue;
            node.copy(dstModuleNode.getPath());
        }
        dstModuleNode.setProperty("j:title", dstModuleName);
        if (srcModuleNode.hasProperty("j:installedModules")) {
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (JCRValueWrapper value : srcModuleNode.getProperty("j:installedModules").getValues()) {
                if (srcModule.getId().equals(value.getString())) {
                    newValues.add(new ValueImpl(dstModuleId));
                    continue;
                }
                newValues.add(value);
            }
            dstModuleNode.setProperty("j:installedModules", newValues.toArray(new Value[newValues.size()]));
        }
        session.save();
        FileUtils.deleteQuietly((File)new File(dstFolder, "src/main/import/content/modules/" + srcModule.getId()));
        try {
            this.regenerateImportFile(session, new ArrayList<File>(), dstFolder, dstModuleId, dstModuleId + "/" + dstVersion);
        }
        catch (TransformerException | SAXException e) {
            throw new IOException("Unable to generate import files in " + dstFolder);
        }
        finally {
            session.getNode("/modules/" + dstModuleId).remove();
            session.save();
        }
    }

    private void cleanScmFiles(File dstFolder) throws IOException {
        FileUtils.deleteQuietly((File)new File(dstFolder, ".git"));
        FileUtils.deleteQuietly((File)new File(dstFolder, ".gitignore"));
        new SvnCleaner().clean(dstFolder);
    }

    private void updateDuplicatedPom(String moduleName, String artifactId, String groupId, String dstVersion, File dstFolder) throws IOException {
        Model pom = null;
        try {
            pom = PomUtils.read(new File(dstFolder, "pom.xml"));
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        if (!"bundle".equals(pom.getPackaging())) {
            throw new IOException("This module is not compatible with the current version of Jahia.");
        }
        pom.setArtifactId(artifactId);
        pom.setGroupId(groupId);
        pom.setVersion(dstVersion);
        pom.setName(moduleName);
        Scm scm = new Scm();
        scm.setConnection("scm:dummy:uri");
        scm.setDeveloperConnection("scm:dummy:uri");
        pom.setScm(scm);
        pom.setDistributionManagement(null);
        pom.getProperties().remove("jahia-private-app-store");
        PomUtils.write(pom, new File(dstFolder, "pom.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void regenerateImportFile(JCRSessionWrapper session, List<File> modifiedFiles, File sources, String moduleId, String moduleIdWithVersion) throws RepositoryException, SAXException, IOException, TransformerException {
        File f = File.createTempFile("import", null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("xsl_path", SettingsBean.getInstance().getJahiaEtcDiskPath() + "/repository/export/templatesCleanup.xsl");
        FileOutputStream out = new FileOutputStream(f);
        try {
            ImportExportBaseService.getInstance().exportZip(session.getNode("/modules/" + moduleIdWithVersion), session.getRootNode(), out, params);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        String importFileBasePath = "content/modules/" + moduleId + "/";
        String filesNodePath = "/modules/" + moduleIdWithVersion;
        JCRNodeWrapper filesNode = null;
        if (session.nodeExists(filesNodePath)) {
            filesNode = session.getNode(filesNodePath);
        }
        File sourcesImportFolder = new File(sources, "src/main/import");
        sourcesImportFolder.mkdirs();
        File filesDirectory = new File(sourcesImportFolder.getPath() + "/" + importFileBasePath);
        Collection files = null;
        files = filesDirectory.exists() ? FileUtils.listFiles((File)filesDirectory, null, (boolean)true) : new ArrayList();
        ZipInputStream zis = null;
        try {
            ZipEntry zipentry;
            zis = new ZipInputStream(new FileInputStream(f));
            while ((zipentry = zis.getNextEntry()) != null) {
                if (zipentry.isDirectory()) continue;
                try {
                    String name = zipentry.getName();
                    name = name.replace(moduleIdWithVersion, moduleId);
                    File sourceFile = new File(sourcesImportFolder, name);
                    boolean nodeMoreRecentThanSourceFile = true;
                    if (sourceFile.exists() && name.startsWith(importFileBasePath)) {
                        JCRNodeWrapper node;
                        String relPath = name.substring(importFileBasePath.length());
                        if (relPath.endsWith(sourceFile.getName() + "/" + sourceFile.getName())) {
                            relPath = StringUtils.substringBeforeLast((String)relPath, (String)"/");
                        }
                        if (filesNode != null && filesNode.hasNode(relPath) && (node = filesNode.getNode(relPath)).hasProperty("jcr:lastModified")) {
                            boolean bl = nodeMoreRecentThanSourceFile = node.getProperty("jcr:lastModified").getDate().getTimeInMillis() > sourceFile.lastModified();
                        }
                    }
                    if (nodeMoreRecentThanSourceFile && this.saveFile(zis, sourceFile)) {
                        modifiedFiles.add(sourceFile);
                    }
                    files.remove(sourceFile);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            for (File file : files) {
                try {
                    this.deleteFileAndEmptyParents(file, sourcesImportFolder.getPath());
                }
                catch (Exception e) {
                    logger.error("Cannot delete file " + file, (Throwable)e);
                }
            }
            if (zis == null) return;
        }
        catch (Exception e) {
            try {
                logger.error("Cannot patch import file", (Throwable)e);
                if (zis == null) return;
            }
            catch (Throwable throwable) {
                if (zis == null) throw throwable;
                IOUtils.closeQuietly(zis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)zis);
            return;
        }
        IOUtils.closeQuietly((InputStream)zis);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean saveFile(InputStream source, File target) throws IOException {
        FileOutputStream output;
        FileInputStream input;
        block17: {
            boolean bl;
            Charset transCodeTarget = null;
            if (target.getParentFile().getName().equals("resources") && target.getName().endsWith(".properties")) {
                transCodeTarget = Charsets.ISO_8859_1;
            }
            if (!target.exists()) {
                if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                    throw new IOException("Unable to create path for: " + target.getParentFile());
                }
                if (target.getParentFile().isFile()) {
                    target.getParentFile().delete();
                    target.getParentFile().mkdirs();
                }
                if (transCodeTarget != null) {
                    FileUtils.writeLines((File)target, (String)transCodeTarget.name(), this.convertToNativeEncoding(IOUtils.readLines((InputStream)source, (Charset)Charsets.UTF_8), transCodeTarget), (String)"\n");
                } else {
                    FileOutputStream output2 = FileUtils.openOutputStream((File)target);
                    try {
                        IOUtils.copy((InputStream)source, (OutputStream)output2);
                        output2.close();
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)output2);
                    }
                }
                if (!target.getName().equals("repository.xml")) return true;
                FileUtils.copyFile((File)target, (File)new File(target.getPath() + ".generated"));
                return true;
            }
            List targetContent = FileUtils.readLines((File)target, (Charset)(transCodeTarget != null ? transCodeTarget : Charsets.UTF_8));
            if (!this.isBinary(targetContent)) {
                File previouslyGenerated = new File(target.getPath() + ".generated");
                List previouslyGeneratedContent = targetContent;
                if (previouslyGenerated.exists()) {
                    previouslyGeneratedContent = FileUtils.readLines((File)previouslyGenerated, (Charset)(transCodeTarget != null ? transCodeTarget : Charsets.UTF_8));
                }
                DiffMatchPatch dmp = new DiffMatchPatch();
                List<String> sourceContent = IOUtils.readLines((InputStream)source, (Charset)Charsets.UTF_8);
                if (transCodeTarget != null) {
                    sourceContent = this.convertToNativeEncoding(sourceContent, transCodeTarget);
                }
                LinkedList<DiffMatchPatch.Patch> l = dmp.patch_make(StringUtils.join((Collection)previouslyGeneratedContent, (String)"\n"), StringUtils.join(sourceContent, (String)"\n"));
                if (target.getName().equals("repository.xml")) {
                    FileUtils.writeLines((File)new File(target.getPath() + ".generated"), (String)(transCodeTarget != null ? transCodeTarget.name() : "UTF-8"), sourceContent);
                }
                if (l.isEmpty()) return false;
                Object[] objects = dmp.patch_apply(l, StringUtils.join((Collection)targetContent, (String)"\n"));
                for (boolean b : (boolean[])objects[1]) {
                    if (b) continue;
                    throw new IOException("Cannot apply modification on " + target.getName() + ", check generated file at : " + target.getPath() + ".generated");
                }
                FileUtils.write((File)target, (CharSequence)((CharSequence)objects[0]), (String)(transCodeTarget != null ? transCodeTarget.name() : "UTF-8"));
                return true;
            }
            byte[] sourceArray = IOUtils.toByteArray((InputStream)source);
            input = new FileInputStream(target);
            output = null;
            try {
                byte[] targetArray = IOUtils.toByteArray((InputStream)input);
                if (Arrays.equals(sourceArray, targetArray)) break block17;
                output = new FileOutputStream(target);
                IOUtils.write((byte[])sourceArray, (OutputStream)output);
                bl = true;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)input);
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
            return bl;
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly(output);
        return false;
    }

    private void deleteFileAndEmptyParents(File file, String rootPath) throws IOException {
        if (rootPath.equals(file.getPath())) {
            return;
        }
        FileUtils.forceDelete((File)file);
        File parentFile = file.getParentFile();
        File[] files = parentFile.listFiles((FileFilter)HiddenFileFilter.VISIBLE);
        if (files == null || files.length == 0) {
            this.deleteFileAndEmptyParents(parentFile, rootPath);
        }
    }

    private List<String> convertToNativeEncoding(List<String> sourceContent, Charset charset) throws UnsupportedEncodingException {
        ArrayList<String> targetContent = new ArrayList<String>();
        for (String s : sourceContent) {
            Matcher m = UNICODE_PATTERN.matcher(s);
            int start = 0;
            while (m.find(start)) {
                String replacement = new String(new byte[]{(byte)Integer.parseInt(m.group(1), 16), (byte)Integer.parseInt(m.group(2), 16)}, "UTF-16");
                if (charset.decode(charset.encode(replacement)).toString().equals(replacement)) {
                    s = m.replaceFirst(replacement);
                }
                start = m.start() + 1;
                m = UNICODE_PATTERN.matcher(s);
            }
            targetContent.add(s);
        }
        return targetContent;
    }

    private boolean isBinary(List<String> text) {
        for (String s : text) {
            if (!s.contains("\u0000")) continue;
            return true;
        }
        return false;
    }

    public void setMavenArchetypeVersion(String mavenArchetypeVersion) {
        this.mavenArchetypeVersion = mavenArchetypeVersion;
    }

    public int getModuleStartLevel() {
        return this.moduleStartLevel;
    }

    public void setModuleStartLevel(int moduleStartLevel) {
        this.moduleStartLevel = moduleStartLevel;
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public void setMavenWarnIfVersionIsOlderThan(String mavenWarnIfVersionIsOlderThan) {
        this.mavenWarnIfVersionIsOlderThan = mavenWarnIfVersionIsOlderThan;
    }

    public static class SvnCleaner
    extends DirectoryWalker<File> {
        public List<File> clean(File startDirectory) throws IOException {
            ArrayList<File> results = new ArrayList<File>();
            this.walk(startDirectory, results);
            return results;
        }

        protected boolean handleDirectory(File directory, int depth, Collection<File> results) {
            if (".svn".equals(directory.getName())) {
                FileUtils.deleteQuietly((File)directory);
                results.add(directory);
                return false;
            }
            return true;
        }
    }

    static class CompiledModuleInfo {
        private final File file;
        private final String moduleName;
        private final String version;

        public CompiledModuleInfo(File file, String moduleName, String version) {
            this.file = file;
            this.moduleName = moduleName;
            this.version = version;
        }

        public File getFile() {
            return this.file;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

