/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRObservationManager;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.templates.ComponentRegistry;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class TemplatePackageDeployer {
    private static Logger logger = LoggerFactory.getLogger(TemplatePackageDeployer.class);
    protected JahiaTemplateManagerService service;
    private TemplatePackageRegistry templatePackageRegistry;
    private ComponentRegistry componentRegistry;
    private ImportExportBaseService importExportService;

    public void setComponentRegistry(ComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public void setImportExportService(ImportExportBaseService importExportService) {
        this.importExportService = importExportService;
    }

    public void setService(JahiaTemplateManagerService service) {
        this.service = service;
    }

    public void setTemplatePackageRegistry(TemplatePackageRegistry tmplPackageRegistry) {
        this.templatePackageRegistry = tmplPackageRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeModuleContent(JahiaTemplatesPackage aPackage, JCRSessionWrapper session) throws RepositoryException {
        this.resetModuleNodes(aPackage, session);
        logger.info("Starting import for the module package '" + aPackage.getName() + "' including: " + aPackage.getInitialImports());
        for (String imp : aPackage.getInitialImports()) {
            Resource importFile;
            block15: {
                String targetPath = "/" + StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)imp, (String)"."), (String)"import-").replace('-', '/');
                importFile = aPackage.getResource(imp);
                logger.info("... importing " + importFile + " into " + targetPath);
                session.getPathMapping().put("/templateSets/", "/modules/");
                session.getPathMapping().put("/modules/" + aPackage.getId() + "/", "/modules/" + aPackage.getId() + "/" + aPackage.getVersion() + "/");
                try {
                    if (imp.toLowerCase().endsWith(".xml")) {
                        BufferedInputStream is = null;
                        try {
                            is = new BufferedInputStream(importFile.getInputStream());
                            session.importXML(targetPath, is, 0, 0);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)is);
                        break block15;
                    }
                    if (imp.toLowerCase().contains("/importsite")) {
                        this.importExportService.importSiteZip(importFile, session);
                    } else {
                        this.importExportService.importZip(targetPath, importFile, 0, session, new HashSet<String>(Arrays.asList("permissions.xml", "roles.xml")), false);
                        if (targetPath.equals("/")) {
                            HashSet<String> s;
                            ArrayList<String> fileList = new ArrayList<String>();
                            HashMap<String, Long> sizes = new HashMap<String, Long>();
                            this.importExportService.getFileList(importFile, sizes, fileList);
                            if (sizes.containsKey("permissions.xml")) {
                                s = new HashSet<String>(sizes.keySet());
                                s.remove("permissions.xml");
                                if (!session.itemExists("/modules/" + aPackage.getIdWithVersion() + "/permissions")) {
                                    session.getNode("/modules/" + aPackage.getIdWithVersion()).addNode("permissions", "jnt:permission");
                                }
                                this.importExportService.importZip("/modules/" + aPackage.getIdWithVersion(), importFile, 0, session, s, false);
                            }
                            if (sizes.containsKey("roles.xml")) {
                                s = new HashSet(sizes.keySet());
                                s.remove("roles.xml");
                                session.getPathMapping().put("/permissions", "/modules/" + aPackage.getIdWithVersion() + "/permissions");
                                this.importExportService.importZip("/", importFile, 0, session, s, false);
                                session.getPathMapping().remove("/permissions");
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            File realImportFile = null;
            try {
                realImportFile = importFile.getFile();
            }
            catch (IOException ioe) {
                realImportFile = null;
            }
            if (realImportFile != null) {
                realImportFile.delete();
            }
            session.save(13);
        }
        this.cloneModuleInLive(aPackage);
        logger.info("... finished initial import for module package '" + aPackage.getName() + "'.");
        this.componentRegistry.registerComponents(aPackage, session);
        session.save();
    }

    private synchronized void cloneModuleInLive(final JahiaTemplatesPackage pack) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(null, "live", null, new JCRCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    JCRObservationManager.setEventListenersAvailableDuringPublishOnly(true);
                    if (!session.itemExists("/modules")) {
                        JahiaAccessManager.setDeniedPaths(Arrays.asList("/modules/" + pack.getIdWithVersion() + "/sources"));
                        session.getWorkspace().clone("default", "/modules", "/modules", true);
                    } else if (!session.itemExists("/modules/" + pack.getId())) {
                        JahiaAccessManager.setDeniedPaths(Arrays.asList("/modules/" + pack.getIdWithVersion() + "/sources"));
                        session.getWorkspace().clone("default", "/modules/" + pack.getId(), "/modules/" + pack.getId(), true);
                    } else {
                        if (session.itemExists("/modules/" + pack.getIdWithVersion())) {
                            session.getNode("/modules/" + pack.getIdWithVersion()).remove();
                            session.save();
                        }
                        JahiaAccessManager.setDeniedPaths(Arrays.asList("/modules/" + pack.getIdWithVersion() + "/sources"));
                        session.getWorkspace().clone("default", "/modules/" + pack.getIdWithVersion(), "/modules/" + pack.getIdWithVersion(), true);
                    }
                }
                finally {
                    JCRObservationManager.setEventListenersAvailableDuringPublishOnly(false);
                    JahiaAccessManager.setDeniedPaths(null);
                }
                return null;
            }
        });
    }

    private void resetModuleNodes(JahiaTemplatesPackage pkg, JCRSessionWrapper session) throws RepositoryException {
        this.clearModuleNodes(pkg, session);
        if (this.initModuleNode(session, pkg, true)) {
            this.resetModuleAttributes(session, pkg);
        }
        session.save();
    }

    public void clearModuleNodes(JahiaTemplatesPackage pkg, JCRSessionWrapper session) throws RepositoryException {
        String modulePath = "/modules/" + pkg.getId() + "/" + pkg.getVersion();
        if (session.nodeExists(modulePath)) {
            JCRNodeWrapper moduleNode = session.getNode(modulePath);
            JCRNodeIteratorWrapper nodeIterator = moduleNode.getNodes();
            while (nodeIterator.hasNext()) {
                JCRNodeWrapper next = (JCRNodeWrapper)nodeIterator.next();
                if (next.isNodeType("jnt:versionInfo") || next.isNodeType("jnt:moduleVersionFolder")) continue;
                next.remove();
            }
            session.save();
        }
    }

    private boolean initModuleNode(JCRSessionWrapper session, JahiaTemplatesPackage pack, boolean updateDeploymentDate) throws RepositoryException {
        JCRNodeWrapper v;
        JCRNodeWrapper m;
        JCRNodeWrapper modules;
        boolean modified = false;
        if (!session.nodeExists("/modules")) {
            session.getRootNode().addNode("modules", "jnt:modules");
            modified = true;
        }
        if (!(modules = session.getNode("/modules")).hasNode(pack.getId())) {
            modified = true;
            m = modules.addNode(pack.getId(), "jnt:module");
        } else {
            m = modules.getNode(pack.getId());
        }
        if (!m.hasNode(pack.getVersion().toString())) {
            modified = true;
            m = m.addNode(pack.getVersion().toString(), "jnt:moduleVersion");
        } else {
            m = m.getNode(pack.getVersion().toString());
        }
        if (!m.hasNode("j:versionInfo")) {
            v = m.addNode("j:versionInfo", "jnt:versionInfo");
            modified = true;
        } else {
            v = m.getNode("j:versionInfo");
        }
        if (!v.hasProperty("j:version")) {
            v.setProperty("j:version", pack.getVersion().toString());
            modified = true;
        }
        if (pack.getSourcesFolder() != null) {
            v.setProperty("j:sourcesFolder", pack.getSourcesFolder().getPath());
        }
        if (pack.getScmURI() != null && !"scm:dummy:uri".equals(pack.getScmURI())) {
            try {
                v.setProperty("j:scmURI", pack.getScmURI());
                if (pack.getScmTag() != null) {
                    v.setProperty("j:scmTag", pack.getScmTag());
                }
            }
            catch (Exception e) {
                logger.error("Cannot get SCM url");
            }
        }
        if (updateDeploymentDate) {
            v.setProperty("j:deployementDate", new GregorianCalendar());
            modified = true;
        }
        if (!m.hasNode("portlets")) {
            modified = true;
            m.addNode("portlets", "jnt:portletFolder");
        }
        if (!m.hasNode("files")) {
            modified = true;
            m.addNode("files", "jnt:folder");
        }
        if (!m.hasNode("contents")) {
            modified = true;
            m.addNode("contents", "jnt:contentFolder");
        }
        if (!m.hasNode("templates")) {
            modified = true;
            JCRNodeWrapper tpls = m.addNode("templates", "jnt:templatesFolder");
            if ("module".equals(pack.getModuleType())) {
                tpls.setProperty("j:rootTemplatePath", "/base");
            }
            tpls.addNode("files", "jnt:folder");
            tpls.addNode("contents", "jnt:contentFolder");
        }
        return modified;
    }

    private void resetModuleAttributes(JCRSessionWrapper session, JahiaTemplatesPackage pack) throws RepositoryException {
        JCRNodeWrapper tpls;
        JCRNodeWrapper perms;
        JCRNodeWrapper modules = session.getNode("/modules");
        JCRNodeWrapper m = modules.getNode(pack.getIdWithVersion());
        m.setProperty("j:title", pack.getName());
        if (pack.getModuleType() != null) {
            m.setProperty("j:moduleType", pack.getModuleType());
        }
        m.setProperty("j:modulePriority", pack.getModulePriority());
        ArrayList<Value> l = new ArrayList<Value>();
        for (String d : pack.getDepends()) {
            String v = this.templatePackageRegistry.getModuleId(d);
            if (v != null) {
                l.add(session.getValueFactory().createValue(v));
                continue;
            }
            logger.warn("Cannot find dependency {} for package '{}'", (Object)d, (Object)pack.getName());
        }
        Value[] values = new Value[pack.getDepends().size()];
        m.setProperty("j:dependencies", l.toArray(values));
        if (pack.getModuleType() == null) {
            String moduleType = this.guessModuleType(session, pack);
            pack.setModuleType(moduleType);
        }
        if (!m.hasNode("templates")) {
            m.addNode("templates", "jnt:templatesFolder");
        }
        if (!m.hasNode("permissions")) {
            m.addNode("permissions", "jnt:permission");
        }
        if (!(perms = m.getNode("permissions")).hasNode("components")) {
            perms.addNode("components", "jnt:permission");
        }
        if (!perms.hasNode("templates")) {
            perms.addNode("templates", "jnt:permission");
        }
        if (!(tpls = m.getNode("templates")).hasProperty("j:rootTemplatePath") && "module".equals(pack.getModuleType())) {
            tpls.setProperty("j:rootTemplatePath", "/base");
        }
        if (pack.getResourceBundleName() != null) {
            Resource[] resources;
            ArrayList<String> langs = new ArrayList<String>();
            for (Resource resource : resources = pack.getResources("resources")) {
                try {
                    String langCode;
                    String key = resource.getURI().getPath().substring(1).replace("/", ".");
                    if (!key.startsWith(pack.getResourceBundleName()) || (langCode = StringUtils.substringBetween((String)key, (String)(pack.getResourceBundleName() + "_"), (String)".properties")) == null) continue;
                    langs.add(langCode);
                }
                catch (IOException e) {
                    logger.error("Cannot get resources", (Throwable)e);
                }
            }
            JCRNodeWrapper moduleNode = m.getParent();
            if (moduleNode.hasProperty("j:languages")) {
                JCRValueWrapper[] oldValues;
                for (JCRValueWrapper value : oldValues = m.getParent().getProperty("j:languages").getValues()) {
                    if (langs.contains(value.getString())) continue;
                    langs.add(value.getString());
                }
            }
            moduleNode.setProperty("j:languages", langs.toArray(new String[langs.size()]));
        }
    }

    private String guessModuleType(JCRSessionWrapper session, JahiaTemplatesPackage pack) throws RepositoryException {
        String moduleType = "module";
        if (session.itemExists("/modules/" + pack.getIdWithVersion() + "/j:moduleType")) {
            moduleType = session.getNode("/modules/" + pack.getIdWithVersion()).getProperty("j:moduleType").getValue().getString();
        } else {
            String[] fileNames = new File(pack.getFilePath()).list();
            if (fileNames != null) {
                ArrayList<String> files = new ArrayList<String>(Arrays.asList(fileNames));
                files.removeAll(Arrays.asList("META-INF", "WEB-INF", "resources"));
                if (files.isEmpty()) {
                    moduleType = "system";
                }
            }
        }
        return moduleType;
    }

    public JahiaTemplatesPackage deployModule(File jarFile, JCRSessionWrapper session) throws RepositoryException {
        try {
            String location = jarFile.toURI().toString();
            Bundle bundle = FrameworkService.getBundleContext().installBundle(location);
            bundle.update();
            bundle.start();
            String moduleId = BundleUtils.getModuleId(bundle);
            String version = BundleUtils.getModuleVersion(bundle);
            return this.service.getTemplatePackageRegistry().lookupByIdAndVersion(moduleId, new ModuleVersion(version));
        }
        catch (BundleException e) {
            logger.error("Cannot deploy module", (Throwable)e);
            return null;
        }
    }

    public void undeployModule(String id, String version) throws RepositoryException {
        Bundle[] bundles;
        for (Bundle bundle : bundles = FrameworkService.getBundleContext().getBundles()) {
            String moduleId = BundleUtils.getModuleId(bundle);
            String moduleVersion = BundleUtils.getModuleVersion(bundle);
            if (!moduleId.equals(id) || !moduleVersion.equals(version)) continue;
            try {
                bundle.uninstall();
                return;
            }
            catch (BundleException e) {
                logger.error("Cannot undeploy module", (Throwable)e);
            }
        }
    }
}

