/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean.contentmanager;

import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.uicomponents.bean.Visibility;
import org.jahia.services.usermanager.JahiaUser;

public class ProviderKeyColumnVisibility
extends Visibility {
    private JCRSessionFactory sessionFactory;
    private boolean alsoCountDynamicProviders;

    @Override
    public boolean getRealValue(JCRNodeWrapper contextNode, JahiaUser jahiaUser, Locale locale, HttpServletRequest request) {
        boolean visible = false;
        List<JCRStoreProvider> providers = this.sessionFactory.getProviderList();
        if (providers.size() > 1) {
            if (this.alsoCountDynamicProviders) {
                visible = true;
            } else {
                int count = 0;
                for (JCRStoreProvider jcrStoreProvider : providers) {
                    if (jcrStoreProvider.isDynamicallyMounted() || ++count <= 1) continue;
                    visible = true;
                    break;
                }
            }
        }
        return visible;
    }

    public void setJcrSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setAlsoCountDynamicProviders(boolean alsoCountDynamicProviders) {
        this.alsoCountDynamicProviders = alsoCountDynamicProviders;
    }
}

