/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.usermanager;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.QueryParser;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.osgi.FrameworkService;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.JahiaService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.pwd.PasswordService;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.usermanager.BridgeEvents;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerProvider;
import org.jahia.services.usermanager.JahiaUserSplittingRule;
import org.jahia.services.usermanager.UserCacheHelper;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.EncryptionUtils;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class JahiaUserManagerService
extends JahiaService
implements JahiaAfterInitializationService,
ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(JahiaUserManagerService.class);
    private static final String ROOT_PWD_RESET_FILE = "root.pwd";
    private static final String ROOT_PWD_RESET_FILE_PATH = "/WEB-INF/etc/config/root.pwd";
    public static final String GUEST_USERNAME = "guest";
    public static final String GUEST_USERPATH = "/users/guest";
    public static final String MULTI_CRITERIA_SEARCH_OPERATION = "multi_criteria_search_op";
    public static final String COUNT_LIMIT = "countLimit";
    private JahiaUserSplittingRule userSplittingRule;
    private ServletContext servletContext;
    private String rootUserName;
    private Map<String, JahiaUserManagerProvider> legacyUserProviders = new HashMap<String, JahiaUserManagerProvider>();
    private UserCacheHelper cacheHelper;
    private PasswordService passwordService;

    private static Pattern getUserNamePattern() {
        return PatternHolder.INSTANCE;
    }

    public static JahiaUserManagerService getInstance() {
        return Holder.INSTANCE;
    }

    public JahiaUserSplittingRule getUserSplittingRule() {
        return this.userSplittingRule;
    }

    public void setUserSplittingRule(JahiaUserSplittingRule userSplittingRule) {
        this.userSplittingRule = userSplittingRule;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    public JCRUserNode lookupUserByKey(String userKey) {
        return this.lookupUserByPath(userKey);
    }

    public JCRUserNode lookupUserByPath(String path) {
        JCRUserNode userNode = this.lookupUserByPath(path, "live");
        if (userNode == null) {
            userNode = this.lookupUserByPath(path, "default");
        }
        return userNode;
    }

    private JCRUserNode lookupUserByPath(String path, String workspace) {
        try {
            return this.lookupUserByPath(path, JCRSessionFactory.getInstance().getCurrentSystemSession(workspace, null, null));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JCRUserNode lookupUserByPath(String userKey, JCRSessionWrapper session) {
        try {
            return (JCRUserNode)session.getNode(userKey);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JCRUserNode lookupUser(String name) {
        return this.lookupUser(name, null, false);
    }

    public JCRUserNode lookupUser(String name, String site) {
        return this.lookupUser(name, site, true);
    }

    public JCRUserNode lookupUser(String name, String site, boolean checkSiteAndGlobalUsers) {
        JCRUserNode userNode = null;
        try {
            userNode = this.lookupUser(name, site, checkSiteAndGlobalUsers, "live");
            if (userNode == null) {
                userNode = this.lookupUser(name, site, checkSiteAndGlobalUsers, "default");
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return userNode;
    }

    private JCRUserNode lookupUser(String name, String site, boolean checkSiteAndGlobalUsers, String workspace) throws RepositoryException {
        JCRSessionWrapper s = JCRSessionFactory.getInstance().getCurrentSystemSession(workspace, null, null);
        JCRUserNode userNode = null;
        if (checkSiteAndGlobalUsers && site != null) {
            userNode = this.lookupUser(name, null, s);
        }
        if (userNode == null) {
            userNode = this.lookupUser(name, site, s);
        }
        return userNode;
    }

    public JCRUserNode lookupUser(String name, JCRSessionWrapper session) {
        return this.lookupUser(name, null, session);
    }

    public JCRUserNode lookupUser(String name, String site, JCRSessionWrapper session) {
        if (StringUtils.isBlank((String)name)) {
            logger.error("Should not be looking for empty name user");
            return null;
        }
        String path = this.getUserPath(name, site);
        if (path == null) {
            return null;
        }
        return this.lookupUserByPath(path, session);
    }

    public String getUserPath(String name) {
        return this.getUserPath(name, "");
    }

    public String getUserPath(String name, String site) {
        return this.cacheHelper.getUserPath(name, site);
    }

    public boolean userExists(String name) {
        return this.lookupUser(name) != null;
    }

    public boolean userExists(String name, String siteKey) {
        return this.lookupUser(name, siteKey) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRootUserName() {
        if (this.rootUserName == null) {
            JahiaUserManagerService jahiaUserManagerService = this;
            synchronized (jahiaUserManagerService) {
                if (this.rootUserName == null) {
                    this.rootUserName = this.lookupRootUser().getName();
                }
            }
        }
        return this.rootUserName;
    }

    public JCRUserNode lookupRootUser() {
        try {
            return this.lookupRootUser(JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null));
        }
        catch (RepositoryException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            return null;
        }
    }

    public JCRUserNode lookupRootUser(JCRSessionWrapper session) {
        try {
            return (JCRUserNode)session.getNodeByIdentifier("b32d306a-6c74-11de-b3ef-001e4fead50b");
        }
        catch (RepositoryException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            return null;
        }
    }

    public List<String> getUserList() {
        return this.getUserList(null);
    }

    public List<String> getUserList(String siteKey) {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null);
            ArrayList<String> users = new ArrayList<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                String query = siteKey == null ? "SELECT [j:nodename] FROM [jnt:user] AS username WHERE isdescendantnode(username,'/users/') ORDER BY localname(username)" : "SELECT [j:nodename] FROM [jnt:user] AS username WHERE isdescendantnode(username,'/sites/" + siteKey + "/users/') ORDER BY localname(username)";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    String userPath;
                    Row row = rows.nextRow();
                    if (row.getNode() == null || users.contains(userPath = row.getPath())) continue;
                    users.add(userPath);
                }
            }
            return users;
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving user list", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> getUsernameList() {
        return this.getUsernameList(null);
    }

    public List<String> getUsernameList(String siteKey) {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null);
            TreeSet<String> users = new TreeSet<String>();
            if (session.getWorkspace().getQueryManager() != null) {
                String usersPath = siteKey == null ? "/users/" : "/sites/" + siteKey + "/users/";
                String query = "SELECT [j:nodename] FROM [jnt:user] where isdescendantnode('" + usersPath + "')";
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                QueryResult qr = q.execute();
                RowIterator rows = qr.getRows();
                while (rows.hasNext()) {
                    Row row = rows.nextRow();
                    String userName = row.getValue("j:nodename").getString();
                    users.add(userName);
                }
            }
            return new ArrayList<String>(users);
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving user name list", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public Set<JCRUserNode> searchUsers(Properties searchCriterias) {
        try {
            return this.searchUsers(searchCriterias, JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null));
        }
        catch (RepositoryException e) {
            logger.error("Error while searching for users", (Throwable)e);
            return new HashSet<JCRUserNode>();
        }
    }

    public Set<JCRUserNode> searchUsers(Properties searchCriterias, String[] providers) {
        try {
            return this.searchUsers(searchCriterias, providers, JCRSessionFactory.getInstance().getCurrentSystemSession("live", null, null));
        }
        catch (RepositoryException e) {
            logger.error("Error while searching for users", (Throwable)e);
            return new HashSet<JCRUserNode>();
        }
    }

    public Set<JCRUserNode> searchUsers(Properties searchCriterias, JCRSessionWrapper session) {
        return this.searchUsers(searchCriterias, null, session);
    }

    public Set<JCRUserNode> searchUsers(Properties searchCriterias, String[] providerKeys, JCRSessionWrapper session) {
        return this.searchUsers(searchCriterias, null, providerKeys, session);
    }

    public Set<JCRUserNode> searchUsers(Properties searchCriterias, String siteKey, String[] providerKeys, JCRSessionWrapper session) {
        return this.searchUsers(searchCriterias, siteKey, providerKeys, false, session);
    }

    public Set<JCRUserNode> searchUsers(Properties searchCriterias, String siteKey, String[] providerKeys, boolean excludeProtected, JCRSessionWrapper session) {
        try {
            int limit = 0;
            HashSet<JCRUserNode> users = new HashSet<JCRUserNode>();
            if (session.getWorkspace().getQueryManager() != null) {
                StringBuilder query = new StringBuilder();
                if (providerKeys != null) {
                    List<JCRStoreProvider> providers = this.getProviders(siteKey, providerKeys, session);
                    if (!providers.isEmpty()) {
                        query.append("(");
                        for (JCRStoreProvider provider : providers) {
                            query.append(query.length() > 1 ? " OR " : "");
                            if (provider.isDefault()) {
                                query.append("u.[j:external] = false");
                                continue;
                            }
                            query.append("ISDESCENDANTNODE('").append(provider.getMountPoint()).append("')");
                        }
                        query.append(")");
                    } else {
                        return users;
                    }
                }
                if (searchCriterias != null && !searchCriterias.isEmpty()) {
                    Iterator<Map.Entry<Object, Object>> criteriaIterator;
                    Properties filters = (Properties)searchCriterias.clone();
                    String operation = " OR ";
                    if (filters.containsKey(MULTI_CRITERIA_SEARCH_OPERATION)) {
                        if (((String)filters.get(MULTI_CRITERIA_SEARCH_OPERATION)).trim().toLowerCase().equals("and")) {
                            operation = " AND ";
                        }
                        filters.remove(MULTI_CRITERIA_SEARCH_OPERATION);
                    }
                    if (filters.containsKey(COUNT_LIMIT)) {
                        limit = Integer.parseInt((String)filters.get(COUNT_LIMIT));
                        logger.debug("Limit of results has be set to " + limit);
                        filters.remove(COUNT_LIMIT);
                    }
                    if (!(filters.containsKey("*") && filters.size() == 1 && filters.getProperty("*").equals("*") || !(criteriaIterator = filters.entrySet().iterator()).hasNext())) {
                        query.append(query.length() > 0 ? " AND " : "").append(" (");
                        while (criteriaIterator.hasNext()) {
                            String propertyValue;
                            Map.Entry<Object, Object> entry = criteriaIterator.next();
                            String propertyKey = (String)entry.getKey();
                            if ("username".equals(propertyKey)) {
                                propertyKey = "j:nodename";
                            }
                            propertyValue = "*".equals(propertyValue = (String)entry.getValue()) ? "%" : (propertyValue.indexOf(42) != -1 ? Patterns.STAR.matcher(propertyValue).replaceAll("%") : propertyValue + "%");
                            propertyValue = JCRContentUtils.sqlEncode(propertyValue);
                            if ("*".equals(propertyKey)) {
                                query.append("(CONTAINS(u.*,'" + QueryParser.escape((String)Patterns.PERCENT.matcher(propertyValue).replaceAll("")) + "') OR LOWER(u.[j:nodename]) LIKE '").append(propertyValue.toLowerCase()).append("') ");
                            } else {
                                query.append("LOWER(u.[" + Patterns.DOT.matcher(propertyKey).replaceAll("\\\\.") + "])").append(" LIKE '").append(propertyValue.toLowerCase()).append("'");
                            }
                            if (!criteriaIterator.hasNext()) continue;
                            query.append(operation);
                        }
                        query.append(")");
                    }
                }
                if (query.length() > 0) {
                    query.insert(0, " and ");
                }
                if (excludeProtected) {
                    query.insert(0, " and [j:nodename] <> 'guest'");
                }
                String s = siteKey == null ? "/users/" : "/sites/" + siteKey + "/users/";
                query.insert(0, "SELECT * FROM [jnt:user] as u where isdescendantnode(u,'" + JCRContentUtils.sqlEncode(s) + "')");
                if (logger.isDebugEnabled()) {
                    logger.debug(query.toString());
                }
                QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query.toString(), "JCR-SQL2");
                if (limit > 0) {
                    q.setLimit(limit);
                }
                QueryResult qr = q.execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    Node userNode = ni.nextNode();
                    users.add((JCRUserNode)userNode);
                }
            }
            return users;
        }
        catch (RepositoryException e) {
            logger.error("Error while searching for users", (Throwable)e);
            return new HashSet<JCRUserNode>();
        }
    }

    public List<JCRStoreProvider> getProviderList(JCRSessionWrapper session) {
        return this.getProviderList(null, session);
    }

    public List<JCRStoreProvider> getProviderList(String siteKey, JCRSessionWrapper session) {
        LinkedList<JCRStoreProvider> providers = new LinkedList<JCRStoreProvider>();
        try {
            providers.add(JCRSessionFactory.getInstance().getDefaultProvider());
            String providersParentPath = (siteKey == null ? "" : "/sites/" + siteKey) + "/users/providers";
            JCRNodeWrapper providersNode = session.getNode(providersParentPath);
            JCRNodeIteratorWrapper iterator = providersNode.getNodes();
            while (iterator.hasNext()) {
                JCRNodeWrapper providerNode = (JCRNodeWrapper)iterator.next();
                providers.add(providerNode.getProvider());
            }
        }
        catch (PathNotFoundException providersParentPath) {
        }
        catch (RepositoryException e) {
            logger.error("Error while retrieving user providers", (Throwable)e);
        }
        return providers;
    }

    public List<JCRStoreProvider> getProviders(String[] providerKeys, JCRSessionWrapper session) {
        return this.getProviders(null, providerKeys, session);
    }

    public List<JCRStoreProvider> getProviders(String siteKey, String[] providerKeys, JCRSessionWrapper session) {
        if (ArrayUtils.isEmpty((Object[])providerKeys)) {
            return Collections.emptyList();
        }
        LinkedList<JCRStoreProvider> providers = new LinkedList<JCRStoreProvider>();
        for (JCRStoreProvider provider : this.getProviderList(siteKey, session)) {
            if (!ArrayUtils.contains((Object[])providerKeys, (Object)provider.getKey())) continue;
            providers.add(provider);
        }
        return providers;
    }

    public JCRStoreProvider getProvider(String providerKey, JCRSessionWrapper session) {
        return this.getProvider(null, providerKey, session);
    }

    public JCRStoreProvider getProvider(String siteKey, String providerKey, JCRSessionWrapper session) {
        List<JCRStoreProvider> providers = this.getProviders(siteKey, new String[]{providerKey}, session);
        return providers.size() == 1 ? providers.get(0) : null;
    }

    public JCRUserNode createUser(String name, String password, Properties properties, JCRSessionWrapper session) {
        return this.createUser(name, null, password, properties, session);
    }

    public JCRUserNode createUser(String name, String siteKey, String password, Properties properties, JCRSessionWrapper session) {
        try {
            String[] jcrUsernamePath = Patterns.SLASH.split(StringUtils.substringAfter((String)ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(name), (String)"/"));
            JCRNodeWrapper startNode = session.getNode(siteKey == null ? "/" : "/sites/" + siteKey);
            int length = jcrUsernamePath.length;
            for (int i = 0; i < length; ++i) {
                try {
                    startNode = startNode.getNode(jcrUsernamePath[i]);
                    continue;
                }
                catch (PathNotFoundException e) {
                    try {
                        if (i == length - 1) {
                            JCRNodeWrapper userNode = startNode.addNode(name, "jnt:user");
                            userNode.grantRoles("u:" + name, Collections.singleton("owner"));
                            String l_password = !password.startsWith("SHA-1:") ? this.passwordService.digest(password) : password.substring(6);
                            userNode.setProperty("j:password", l_password);
                            userNode.setProperty("j:external", false);
                            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                                String key = (String)entry.getKey();
                                userNode.setProperty(key, (String)entry.getValue());
                            }
                            return (JCRUserNode)userNode;
                        }
                        startNode = startNode.addNode(jcrUsernamePath[i], "jnt:usersFolder");
                        continue;
                    }
                    catch (RepositoryException e1) {
                        logger.error("Cannot save", (Throwable)e1);
                    }
                }
            }
            return (JCRUserNode)startNode;
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean deleteUser(String userPath, JCRSessionWrapper session) {
        try {
            JCRNodeWrapper node;
            try {
                node = session.getNode(userPath);
            }
            catch (ItemNotFoundException e) {
                return true;
            }
            if (node.isNodeType("jmix:systemNode")) {
                return false;
            }
            String query = "SELECT * FROM [jnt:ace] as ace where ace.[j:principal]='u:" + JCRContentUtils.sqlEncode(node.getName()) + "'";
            QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
            QueryResult qr = q.execute();
            NodeIterator nodeIterator = qr.getNodes();
            while (nodeIterator.hasNext()) {
                Node next = nodeIterator.nextNode();
                session.checkout(next.getParent());
                session.checkout(next);
                next.remove();
            }
            PropertyIterator pi = node.getWeakReferences("j:member");
            while (pi.hasNext()) {
                JCRPropertyWrapper propertyWrapper = (JCRPropertyWrapper)pi.next();
                propertyWrapper.getParent().remove();
            }
            session.checkout(node.getParent());
            session.checkout(node);
            node.remove();
            return true;
        }
        catch (RepositoryException e) {
            logger.error("Error while deleting user", (Throwable)e);
            return false;
        }
    }

    public static boolean isGuest(JCRUserNode user) {
        return user == null || GUEST_USERNAME.equals(user.getName());
    }

    public static boolean isGuest(JahiaUser user) {
        return user == null || GUEST_USERNAME.equals(user.getName());
    }

    @Deprecated
    public static String encryptPassword(String password) {
        if (StringUtils.isEmpty((String)password)) {
            return null;
        }
        return EncryptionUtils.sha1DigestLegacy(password);
    }

    public boolean isUsernameSyntaxCorrect(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        boolean usernameCorrect = JahiaUserManagerService.getUserNamePattern().matcher(name).matches();
        if (!usernameCorrect && logger.isDebugEnabled()) {
            logger.debug("Validation failed for the user name: " + name + " against pattern: " + JahiaUserManagerService.getUserNamePattern().pattern());
        }
        return usernameCorrect;
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
        this.checkRootUserPwd();
        for (String key : this.legacyUserProviders.keySet()) {
            BridgeEvents.sendEvent(key, "org/jahia/usersgroups/userProvider/REGISTER");
        }
    }

    private void checkRootUserPwd() {
        try {
            final String pwd = this.getNewRootUserPwd();
            if (StringUtils.isNotEmpty((String)pwd)) {
                logger.info("Resetting root user password");
                JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JahiaUserManagerService.this.lookupRootUser(session).setPassword(pwd);
                        session.save();
                        return null;
                    }
                });
                logger.info("New root user password set.");
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private String getNewRootUserPwd() throws MalformedURLException, IOException {
        String path;
        String pwd = null;
        File pwdFile = null;
        pwdFile = this.servletContext.getResource(ROOT_PWD_RESET_FILE_PATH) != null ? ((path = this.servletContext.getRealPath(ROOT_PWD_RESET_FILE_PATH)) != null ? new File(path) : null) : new File(this.settingsBean.getJahiaVarDiskPath(), ROOT_PWD_RESET_FILE);
        if (pwdFile != null && pwdFile.exists()) {
            pwd = FileUtils.readFileToString((File)pwdFile);
            try {
                pwdFile.delete();
            }
            catch (Exception e) {
                logger.warn("Unable to delete " + pwdFile + " file after resetting root password", (Throwable)e);
            }
        }
        return pwd != null ? StringUtils.chomp(pwd).trim() : null;
    }

    public void updatePathCacheAdded(String userPath) {
        this.cacheHelper.updateAdded(userPath);
    }

    public void updatePathCacheRemoved(String userPath) {
        this.cacheHelper.updateRemoved(userPath);
    }

    @Deprecated
    public List<? extends JahiaUserManagerProvider> getProviderList() {
        return new ArrayList<JahiaUserManagerProvider>(this.legacyUserProviders.values());
    }

    @Deprecated
    public JahiaUserManagerProvider getProvider(String key) {
        return this.legacyUserProviders.get(key);
    }

    @Deprecated
    public void registerProvider(JahiaUserManagerProvider jahiaUserManagerProvider) {
        this.legacyUserProviders.put(jahiaUserManagerProvider.getKey(), jahiaUserManagerProvider);
        if (FrameworkService.getInstance().isStarted()) {
            BridgeEvents.sendEvent(jahiaUserManagerProvider.getKey(), "org/jahia/usersgroups/userProvider/REGISTER");
        }
    }

    @Deprecated
    public void unregisterProvider(JahiaUserManagerProvider jahiaUserManagerProvider) {
        this.legacyUserProviders.remove(jahiaUserManagerProvider.getKey());
        BridgeEvents.sendEvent(jahiaUserManagerProvider.getKey(), "org/jahia/usersgroups/userProvider/UNREGISTER");
    }

    public void setCacheHelper(UserCacheHelper userPathCache) {
        this.cacheHelper = userPathCache;
    }

    public void clearNonExistingUsersCache() {
        this.cacheHelper.clearNonExistingUsersCache();
    }

    public JCRUserNode lookup(String lookupKey) {
        JCRUserNode user = null;
        char first = lookupKey.charAt(0);
        user = '/' == first ? this.lookupUserByPath(lookupKey) : ('{' == first ? this.lookupUser(StringUtils.substringAfter((String)lookupKey, (String)"}")) : this.lookupUser(lookupKey));
        return user;
    }

    public void setPasswordService(PasswordService passwordService) {
        this.passwordService = passwordService;
    }

    private static class Holder {
        static final JahiaUserManagerService INSTANCE = new JahiaUserManagerService();

        private Holder() {
        }
    }

    private static class PatternHolder {
        static final Pattern INSTANCE = Pattern.compile(SettingsBean.getInstance().lookupString("userManagementUserNamePattern"));

        private PatternHolder() {
        }
    }
}

