/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaPrincipal;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.services.workflow.jbpm.AbstractPeopleAssignmentValve;
import org.jahia.services.workflow.jbpm.JBPM6WorkflowProvider;
import org.jahia.services.workflow.jbpm.custom.JahiaLocalHTWorkItemHandler;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.api.definition.process.Process;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;

public class AclPeopleAssignmentValve
extends AbstractPeopleAssignmentValve {
    @Override
    public void invoke(Object context, ValveContext valveContext) throws PipelineException {
        JBPM6WorkflowProvider provider = (JBPM6WorkflowProvider)valveContext.getEnvironment().get("jBPMWorkflowProvider");
        JahiaLocalHTWorkItemHandler.PeopleAssignmentContext peopleAssignmentContext = (JahiaLocalHTWorkItemHandler.PeopleAssignmentContext)context;
        Task task = peopleAssignmentContext.getTask();
        Process process = peopleAssignmentContext.getKieSession().getKieBase().getProcess(task.getTaskData().getProcessId());
        WorkflowDefinition def = new WorkflowDefinition(process.getName(), process.getName(), provider.getKey());
        try {
            String name = ((I18NText)task.getNames().get(0)).getText();
            PeopleAssignments peopleAssignments = task.getPeopleAssignments();
            ArrayList<Object> potentialOwners = new ArrayList<Object>();
            List<JahiaPrincipal> principals = WorkflowService.getInstance().getAssignedRole(def, name, Long.toString(task.getTaskData().getProcessInstanceId()));
            for (JahiaPrincipal principal : principals) {
                if (principal instanceof JahiaGroup) {
                    potentialOwners.add(new GroupImpl(((JahiaGroup)principal).getGroupKey()));
                    continue;
                }
                if (!(principal instanceof JahiaUser)) continue;
                potentialOwners.add(new UserImpl(((JahiaUser)principal).getUserKey()));
            }
            GroupImpl admin = new GroupImpl(ServicesRegistry.getInstance().getJahiaGroupManagerService().getAdministratorGroup(null).getJahiaGroup().getGroupKey());
            potentialOwners.add(admin);
            peopleAssignments.getPotentialOwners().addAll(potentialOwners);
            ArrayList<GroupImpl> administrators = new ArrayList<GroupImpl>();
            administrators.add(admin);
            peopleAssignments.getBusinessAdministrators().addAll(administrators);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Error while setting up task assignees and creating a JCR task", e);
        }
        valveContext.invokeNext(context);
    }

    @Override
    public void initialize() {
    }
}

