/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.workflow.jbpm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jahia.services.workflow.WorkflowDefinition;
import org.jahia.services.workflow.jbpm.BaseCommand;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Process;

public class GetAvailableWorkflowsCommand
extends BaseCommand<List<WorkflowDefinition>> {
    private final Locale uiLocale;

    public GetAvailableWorkflowsCommand(Locale uiLocale) {
        this.uiLocale = uiLocale;
    }

    @Override
    public List<WorkflowDefinition> execute() {
        KieBase kieBase = this.getKieSession().getKieBase();
        Collection processes = kieBase.getProcesses();
        ArrayList<WorkflowDefinition> workflowDefinitions = new ArrayList<WorkflowDefinition>();
        for (Process process : processes) {
            if (this.getWorkflowService().getWorkflowRegistration(process.getName()) == null) continue;
            workflowDefinitions.add(this.convertToWorkflowDefinition(process, this.uiLocale));
        }
        return workflowDefinitions;
    }
}

