/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.patches.LoggerWrapper;
import org.jahia.utils.ScriptEngineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ServletContextAware;

public class GroovyPatcher
implements JahiaAfterInitializationService,
DisposableBean,
ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(GroovyPatcher.class);
    private static final Comparator<Resource> RESOURCE_COMPARATOR = new Comparator<Resource>(){

        @Override
        public int compare(Resource o1, Resource o2) {
            try {
                return o1.getURI().compareTo(o2.getURI());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        }
    };
    private long interval = 300000L;
    private String patchesLookup;
    private ServletContext servletContext;
    private Timer watchdog;

    public static void executeScripts(Resource[] scripts) {
        long timer = System.currentTimeMillis();
        logger.info("Found new patch scripts {}. Executing...", (Object)StringUtils.join((Object[])scripts));
        for (Resource script : scripts) {
            try {
                long timerSingle = System.currentTimeMillis();
                String scriptContent = GroovyPatcher.getContent(script);
                if (StringUtils.isNotEmpty((String)scriptContent)) {
                    ScriptEngine engine = GroovyPatcher.getEngine();
                    SimpleScriptContext ctx = new SimpleScriptContext();
                    ctx.setWriter(new StringWriter());
                    Bindings bindings = engine.createBindings();
                    bindings.put("log", (Object)new LoggerWrapper(logger, logger.getName(), ctx.getWriter()));
                    ctx.setBindings(bindings, 100);
                    engine.eval(scriptContent, (ScriptContext)ctx);
                    String result = ((StringWriter)ctx.getWriter()).getBuffer().toString();
                    logger.info("Execution of script {} took {} ms with result:\n{}", (Object[])new String[]{script.toString(), String.valueOf(System.currentTimeMillis() - timerSingle), result});
                } else {
                    logger.warn("Content of the script {} is either empty or cannot be read. Skipping.");
                }
                GroovyPatcher.rename(script, ".installed");
            }
            catch (Exception e) {
                logger.error("Execution of script " + script + " failed with error: " + e.getMessage(), (Throwable)e);
                GroovyPatcher.rename(script, ".failed");
            }
        }
        logger.info("Execution took {} ms", (Object)(System.currentTimeMillis() - timer));
    }

    public static void executeScripts(ServletContext ctx, String lifecyclePhase) {
        try {
            LinkedList patches;
            File lookupFolder = GroovyPatcher.getPatchesFolder(ctx);
            if (lookupFolder == null) {
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Looking up patches in the folder {}", (Object)lookupFolder);
            }
            if ((patches = new LinkedList(FileUtils.listFiles((File)lookupFolder, (IOFileFilter)new SuffixFileFilter(new String[]{"." + lifecyclePhase + ".groovy"}, IOCase.INSENSITIVE), (IOFileFilter)TrueFileFilter.INSTANCE))) == null || patches.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("No patches were found");
                }
                return;
            }
            Collections.sort(patches);
            Resource[] resources = new Resource[patches.size()];
            for (int i = 0; i < patches.size(); ++i) {
                resources[i] = patches.get(i) == null ? null : new FileSystemResource((File)patches.get(i));
            }
            GroovyPatcher.executeScripts(resources);
        }
        catch (Exception e) {
            logger.error("Error executing patches", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getContent(Resource r) throws IOException {
        InputStream in = null;
        try {
            in = r.getInputStream();
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    protected static ScriptEngine getEngine() throws ScriptException {
        try {
            return ScriptEngineUtils.getInstance().scriptEngine("groovy");
        }
        catch (ScriptException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Script engine not found for extension")) {
                return null;
            }
            throw e;
        }
    }

    private static File getPatchesFolder(ServletContext ctx) {
        File lookupFolder;
        String varFolder = System.getProperty("jahiaVarDiskPath");
        if (varFolder == null) {
            String string = varFolder = SettingsBean.getInstance() != null ? SettingsBean.getInstance().getJahiaVarDiskPath() : null;
        }
        if (varFolder == null) {
            varFolder = ctx.getRealPath("WEB-INF/var");
        }
        return (lookupFolder = new File(varFolder, "patches" + File.separator + "groovy")).isDirectory() ? lookupFolder : null;
    }

    protected static void rename(Resource script, String suffix) {
        try {
            File scriptFile = script.getFile();
            File dest = new File(scriptFile.getParentFile(), scriptFile.getName() + suffix);
            if (dest.exists()) {
                FileUtils.deleteQuietly((File)dest);
            }
            if (!scriptFile.renameTo(dest)) {
                logger.warn("Unable to rename script file {} to {}. Skip renaming.", (Object)script.getFile().getPath(), (Object)dest.getPath());
            }
        }
        catch (IOException e) {
            logger.warn("Unable to rename the script file for resurce " + script + " due to an error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        if (this.watchdog != null) {
            this.watchdog.cancel();
        }
    }

    public void executeScripts(String lifecyclePhase) {
        GroovyPatcher.executeScripts(this.servletContext, lifecyclePhase);
    }

    @Override
    public void initAfterAllServicesAreStarted() throws JahiaInitializationException {
        File patchesFolder;
        if (!SettingsBean.getInstance().isProcessingServer()) {
            logger.info("Script watchdog is disabled on a non-processing Jahia server");
            return;
        }
        if (this.interval > 5000L && SettingsBean.getInstance().isDevelopmentMode()) {
            this.interval = 5000L;
        }
        if (this.interval <= 0L) {
            logger.info("The interval for the Groovy patcher is <= 0. Skip starting file watcher.");
            return;
        }
        if (this.patchesLookup == null && (patchesFolder = GroovyPatcher.getPatchesFolder(this.servletContext)) != null) {
            String absolutePath = patchesFolder.getAbsolutePath();
            absolutePath = StringUtils.replaceChars((String)absolutePath, (char)'\\', (char)'/');
            absolutePath = StringUtils.replace((String)absolutePath, (String)" ", (String)"%20");
            this.patchesLookup = "file://" + absolutePath + "/**/*.groovy";
        }
        if (StringUtils.isEmpty((String)this.patchesLookup)) {
            logger.info("The patches lookup path is not set. Skip starting file watcher.");
            return;
        }
        try {
            if (GroovyPatcher.getEngine() == null) {
                logger.error("The Groovy engine is not evailable. Skip starting file watcher.");
                return;
            }
        }
        catch (ScriptException e) {
            throw new JahiaInitializationException(e.getMessage(), e);
        }
        this.perform();
        this.watchdog = new Timer(true);
        this.watchdog.schedule(new TimerTask(){

            @Override
            public void run() {
                GroovyPatcher.this.perform();
            }
        }, 0L, this.interval);
    }

    private void perform() {
        if (logger.isTraceEnabled()) {
            logger.trace("Checking for avilable Groovy patches in {}", (Object)this.patchesLookup);
        }
        Resource[] resources = null;
        try {
            resources = SpringContextSingleton.getInstance().getResources(this.patchesLookup, false);
        }
        catch (IOException e) {
            logger.error("Error looking up patches in " + this.patchesLookup + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        if (resources == null || resources.length == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("No new Groovy patches found in {}. Sleeping...", (Object)this.patchesLookup);
            }
            return;
        }
        Arrays.sort(resources, RESOURCE_COMPARATOR);
        GroovyPatcher.executeScripts(resources);
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setPatchesLookup(String patchesLookup) {
        this.patchesLookup = patchesLookup;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

