/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.jahia.tools.patches.GroovyPatcher;
import org.jahia.utils.DatabaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public final class SqlPatcher {
    private static final Logger logger = LoggerFactory.getLogger(SqlPatcher.class);
    private ApplicationContext ctx;
    private String varDir;

    public static void apply(String varDir, ApplicationContext ctx) {
        try {
            new SqlPatcher(varDir, ctx).execute();
        }
        catch (IOException e) {
            logger.error("Error executing SQL patches", (Throwable)e);
        }
    }

    private SqlPatcher(String varDir, ApplicationContext ctx) {
        this.varDir = varDir;
        this.ctx = ctx;
    }

    private void execute() throws IOException {
        Object[] patches = this.getPatches();
        if (patches.length == 0) {
            logger.debug("No SQL patches to execute were found");
            return;
        }
        long timer = System.currentTimeMillis();
        logger.info("Found {} SQL patches to execute:\n{}", (Object)patches.length, (Object)StringUtils.join((Object[])patches));
        for (Object r : patches) {
            this.execute((Resource)r);
        }
        logger.info("Execution of SQL patches took {} ms", (Object)(System.currentTimeMillis() - timer));
    }

    private void execute(Resource r) {
        try {
            logger.info("Executing script {}", (Object)r);
            DatabaseUtils.executeScript(new InputStreamReader(r.getInputStream(), Charsets.UTF_8));
            logger.info("Script {} executed successfully", (Object)r);
            GroovyPatcher.rename(r, ".installed");
        }
        catch (Exception e) {
            logger.error("Execution of SQL script " + r + " failed with error: " + e.getMessage(), (Throwable)e);
            GroovyPatcher.rename(r, ".failed");
        }
    }

    private Resource[] getPatches() throws IOException {
        String folder = "file:" + this.varDir + "/patches/sql/" + (Object)((Object)DatabaseUtils.getDatabaseType());
        if (this.ctx.getResource(folder).exists()) {
            return this.ctx.getResources(folder + "/**/*.sql");
        }
        return new Resource[0];
    }
}

