/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jahia.osgi.BundleUtils;

public final class ClassLoaderUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWith(ClassLoader cl, Callback<T> callback) {
        Thread current = Thread.currentThread();
        ClassLoader contextCL = current.getContextClassLoader();
        try {
            current.setContextClassLoader(cl);
            T t = callback.execute();
            return t;
        }
        finally {
            current.setContextClassLoader(contextCL);
        }
    }

    public static ClassLoader getChainedClassLoader(ClassLoader ... loaders) {
        return new ChainedClassLoader(loaders);
    }

    private ClassLoaderUtils() {
    }

    private static class ChainedClassLoader
    extends ClassLoader {
        private ClassLoader[] loaders;

        ChainedClassLoader(ClassLoader[] loaders) {
            super(null);
            this.loaders = loaders;
        }

        @Override
        public URL getResource(final String name) {
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        return ChainedClassLoader.this.myGetResource(name);
                    }
                });
            }
            return this.myGetResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final ArrayList<Enumeration<URL>> urlsEnums = new ArrayList<Enumeration<URL>>();
            for (ClassLoader loader : this.loaders) {
                Enumeration<URL> urls = loader.getResources(name);
                if (urls == null || !urls.hasMoreElements()) continue;
                urlsEnums.add(urls);
            }
            if (urlsEnums.size() == 0) {
                return Collections.emptyEnumeration();
            }
            return new Enumeration<URL>(){
                int i = 0;
                Enumeration<URL> currentEnum = (Enumeration)urlsEnums.get(this.i);

                @Override
                public boolean hasMoreElements() {
                    if (this.currentEnum.hasMoreElements()) {
                        return true;
                    }
                    int j = this.i;
                    while (++j < urlsEnums.size() - 1 && !((Enumeration)urlsEnums.get(j)).hasMoreElements()) {
                    }
                    if (j <= urlsEnums.size() - 1) {
                        return ((Enumeration)urlsEnums.get(j)).hasMoreElements();
                    }
                    return false;
                }

                @Override
                public URL nextElement() {
                    if (this.currentEnum.hasMoreElements()) {
                        return this.currentEnum.nextElement();
                    }
                    do {
                        ++this.i;
                        this.currentEnum = (Enumeration)urlsEnums.get(this.i);
                    } while (!this.currentEnum.hasMoreElements() && this.i < urlsEnums.size() - 1);
                    if (this.currentEnum.hasMoreElements()) {
                        return this.currentEnum.nextElement();
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Class<?> loadClass(final String className) throws ClassNotFoundException {
            if (System.getSecurityManager() != null) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                        @Override
                        public Class<?> run() throws Exception {
                            return ChainedClassLoader.this.myLoadClass(className);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (ClassNotFoundException)pae.getException();
                }
            }
            return this.myLoadClass(className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private URL myGetResource(String resource) {
            URL url = null;
            ClassLoader[] classLoaderArray = this.loaders;
            synchronized (this.loaders) {
                for (ClassLoader cl : this.loaders) {
                    url = cl.getResource(resource);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return url;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> myLoadClass(String name) throws ClassNotFoundException {
            ClassLoader[] classLoaderArray = this.loaders;
            synchronized (this.loaders) {
                for (ClassLoader cl : this.loaders) {
                    try {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return cl.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                throw new ClassNotFoundException(name);
            }
        }
    }

    public static class CoreAndModulesClassLoader
    extends ClassLoader {
        public CoreAndModulesClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return BundleUtils.loadModuleClass(name);
            }
        }
    }

    public static interface Callback<T> {
        public T execute();
    }
}

