/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.utils.InsertionSortedSet;

public class InsertionSortedMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -5482653693975365706L;
    private List<Map.Entry<K, V>> internalList = new ArrayList<Map.Entry<K, V>>();

    public InsertionSortedMap() {
    }

    public InsertionSortedMap(Map<K, V> t) {
        for (Map.Entry<K, V> curEntry : t.entrySet()) {
            this.internalList.add(curEntry);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        InsertionSortedSet<Map.Entry<K, V>> insertionSortedSet = new InsertionSortedSet<Map.Entry<K, V>>();
        insertionSortedSet.setInternalList(this.internalList);
        return insertionSortedSet;
    }

    @Override
    public V put(K key, V value) throws UnsupportedOperationException, ClassCastException, IllegalArgumentException, NullPointerException {
        int pos = this.findKey(key);
        if (pos == -1) {
            Entry<K, V> newEntry = new Entry<K, V>(key, value);
            this.internalList.add(newEntry);
            return null;
        }
        Map.Entry<K, V> existingEntry = this.internalList.get(pos);
        V oldValue = existingEntry.getValue();
        existingEntry.setValue(value);
        return oldValue;
    }

    private int findKey(K key) {
        int pos = -1;
        for (Map.Entry<K, V> curEntry : this.internalList) {
            ++pos;
            if (!curEntry.getKey().equals(key)) continue;
            return pos;
        }
        return -1;
    }

    private class Entry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -9072586755304139107L;
        private K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                Map.Entry e2 = (Map.Entry)obj;
                if ((this.getKey() == null ? e2.getKey() == null : this.getKey().equals(e2.getKey())) && (this.getValue() == null ? e2.getValue() == null : this.getValue().equals(e2.getValue()))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

