/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.Arrays;
import java.util.Locale;
import org.apache.jackrabbit.core.query.lucene.FieldNames;

public class LuceneUtils {
    public static final String DASH = "-";

    public static String getFullTextFieldName(String siteName, String language) {
        StringBuilder fulltextNameBuilder = new StringBuilder(64);
        fulltextNameBuilder.append(FieldNames.FULLTEXT);
        if (siteName != null) {
            fulltextNameBuilder.append(DASH).append(siteName);
        }
        if (language != null) {
            fulltextNameBuilder.append(DASH).append(language.trim().toLowerCase());
        }
        return fulltextNameBuilder.toString();
    }

    public static String extractLanguageOrNullFrom(String fieldName) {
        int lastDash;
        if (fieldName.startsWith(FieldNames.FULLTEXT) && (lastDash = fieldName.lastIndexOf(DASH)) > 0) {
            String languageCode = fieldName.substring(lastDash + DASH.length());
            if (Arrays.binarySearch(Locale.getISOLanguages(), languageCode) >= 0) {
                return languageCode;
            }
        }
        return null;
    }

    public static String extractLanguageOrNullFromStatement(String statement) {
        int langIndex = statement.indexOf("jcr:language");
        String languageCandidate = null;
        while (langIndex >= 0) {
            String constraint;
            int equalsIndex;
            int nextLangIndex = statement.indexOf("jcr:language", langIndex += "jcr:language".length());
            if ((equalsIndex = (constraint = nextLangIndex < 0 ? statement.substring(langIndex) : statement.substring(langIndex, nextLangIndex)).indexOf(61)) >= 0) {
                int quoteChar = 39;
                boolean hasQuote = false;
                int begLang = constraint.indexOf(quoteChar);
                if (begLang < 0) {
                    begLang = constraint.indexOf(34);
                    if (begLang >= 0) {
                        quoteChar = 34;
                        hasQuote = true;
                    }
                } else {
                    hasQuote = true;
                }
                if (hasQuote) {
                    int endLang;
                    int endConstraint = LuceneUtils.getEndOfConstraintIndex(constraint);
                    if ((endLang = constraint.indexOf(quoteChar, ++begLang)) > 0 && endLang <= endConstraint) {
                        if (languageCandidate != null) {
                            return null;
                        }
                        languageCandidate = constraint.substring(begLang, endLang).trim();
                    }
                }
            }
            langIndex = nextLangIndex;
        }
        return languageCandidate;
    }

    private static int getEndOfConstraintIndex(String constraint) {
        int rightParenIndex = constraint.indexOf(41);
        rightParenIndex = rightParenIndex < 0 ? Integer.MAX_VALUE : rightParenIndex;
        int orIndex = constraint.indexOf("or");
        orIndex = orIndex < 0 ? constraint.indexOf("OR") : orIndex;
        orIndex = orIndex < 0 ? Integer.MAX_VALUE : orIndex;
        int andIndex = constraint.indexOf("and");
        andIndex = andIndex < 0 ? constraint.indexOf("AND") : andIndex;
        andIndex = andIndex < 0 ? Integer.MAX_VALUE : andIndex;
        int endConstraint = Math.min(rightParenIndex, Math.min(orIndex, andIndex));
        endConstraint = endConstraint == Integer.MAX_VALUE ? constraint.length() - 1 : endConstraint;
        return endConstraint;
    }
}

