/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBundleMarker {
    private static final transient Logger logger = LoggerFactory.getLogger(ResourceBundleMarker.class);
    private static Pattern pattern = Pattern.compile("<jahia-resource id=\"(.*)\" key=\"(.*)\" default-value=\"(.*)\"/>");
    private String resourceBundleID;
    private String resourceKey;
    private String value;
    private String defaultValue;

    public ResourceBundleMarker(String resourceBundleID, String resourceKey, String defaultValue) {
        this.resourceBundleID = resourceBundleID;
        this.resourceKey = resourceKey;
        this.defaultValue = defaultValue;
    }

    public String getResourceBundleID() {
        return this.resourceBundleID;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value;
    }

    public static String getValue(String value, String resourceBundle, String valueKey, Locale locale) {
        String result = value;
        try {
            ResourceBundle res = ResourceBundle.getBundle(resourceBundle, locale);
            result = res.getString(valueKey);
        }
        catch (MissingResourceException mre) {
            logger.debug(mre.getMessage(), (Throwable)mre);
        }
        if (result == null || result.length() == 0) {
            return value;
        }
        return result;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String drawMarker() {
        return ResourceBundleMarker.drawMarker(this.getResourceBundleID(), this.getResourceKey(), this.getDefaultValue());
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static ResourceBundleMarker parseMarkerValue(String markerStr) {
        if (markerStr == null) {
            return null;
        }
        ResourceBundleMarker marker = null;
        String val = markerStr.trim();
        Matcher matcher = pattern.matcher(val);
        if (matcher.matches()) {
            String resourceBundleID = matcher.group(1);
            String resourceKey = matcher.group(2);
            String defaultValue = matcher.group(3);
            marker = new ResourceBundleMarker(resourceBundleID, resourceKey, defaultValue);
        }
        return marker;
    }

    public static String drawMarker(String resourceBundleID, String resourceKey, String defaultValue) {
        return new StringBuilder(64).append("<jahia-resource ").append("id=\"").append(resourceBundleID).append("\" key=\"").append(resourceKey).append("\" default-value=\"").append(defaultValue).append("\"/>").toString();
    }

    public int compare(Object c1, Object c2) throws ClassCastException {
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        String s1 = c1 instanceof ResourceBundleMarker ? ((ResourceBundleMarker)c1).getValue() : c1.toString();
        String s2 = c2 instanceof ResourceBundleMarker ? ((ResourceBundleMarker)c2).getValue() : c2.toString();
        int idx1 = this.getFirstDigitIndex(s1);
        int idx2 = this.getFirstDigitIndex(s2);
        if (idx1 == -1 || idx2 == -1 || !s1.substring(0, idx1).equals(s2.substring(0, idx2))) {
            return s1.compareTo(s2);
        }
        int edx1 = this.getLastDigitIndex(s1, idx1);
        int edx2 = this.getLastDigitIndex(s2, idx2);
        String sub1 = null;
        String sub2 = null;
        sub1 = edx1 == -1 ? s1.substring(idx1) : s1.substring(idx1, edx1);
        sub2 = edx2 == -1 ? s2.substring(idx2) : s2.substring(idx2, edx2);
        int zero1 = this.countZeroes(sub1);
        int zero2 = this.countZeroes(sub2);
        if ((sub1 = sub1.substring(zero1)).equals(sub2 = sub2.substring(zero2))) {
            int ret = 0;
            if (zero1 > zero2) {
                ret = 1;
            } else if (zero1 < zero2) {
                ret = -1;
            }
            s1 = edx1 == -1 ? "" : s1.substring(edx1);
            s2 = edx2 == -1 ? "" : s2.substring(edx2);
            int comp = this.compare(s1, s2);
            if (comp != 0) {
                ret = comp;
            }
            return ret;
        }
        if (sub1.length() != sub2.length()) {
            return sub1.length() < sub2.length() ? -1 : 1;
        }
        char[] chr1 = sub1.toCharArray();
        char[] chr2 = sub2.toCharArray();
        int sz = chr1.length;
        for (int i = 0; i < sz; ++i) {
            if (chr1[i] == chr2[i]) continue;
            return chr1[i] < chr2[i] ? -1 : 1;
        }
        return 0;
    }

    private int getFirstDigitIndex(String str) {
        return this.getFirstDigitIndex(str, 0);
    }

    private int getFirstDigitIndex(String str, int start) {
        return this.getFirstDigitIndex(str.toCharArray(), start);
    }

    private int getFirstDigitIndex(char[] chrs, int start) {
        int sz = chrs.length;
        for (int i = start; i < sz; ++i) {
            if (!Character.isDigit(chrs[i])) continue;
            return i;
        }
        return -1;
    }

    private int getLastDigitIndex(String str, int start) {
        return this.getLastDigitIndex(str.toCharArray(), start);
    }

    private int getLastDigitIndex(char[] chrs, int start) {
        int sz = chrs.length;
        for (int i = start; i < sz; ++i) {
            if (Character.isDigit(chrs[i])) continue;
            return i;
        }
        return -1;
    }

    public int countZeroes(String str) {
        int count = 0;
        for (int i = 0; i < str.length() && str.charAt(i) == '0'; ++i) {
            ++count;
        }
        return count;
    }
}

