/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.properties;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesManager {
    private static final transient Logger logger = LoggerFactory.getLogger(PropertiesManager.class);
    public Properties properties = new Properties();
    public String propertiesFilePath;

    public PropertiesManager() {
    }

    public PropertiesManager(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
        this.loadProperties();
    }

    public PropertiesManager(Properties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadProperties() {
        this.properties = new Properties();
        File file = new File(this.propertiesFilePath);
        if (!file.exists()) {
            return;
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            this.properties.load(inputStream);
        }
        catch (IOException ioe) {
            logger.error("IOException on loadProperties().", (Throwable)ioe);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (SecurityException se) {
            logger.error("SecurityException on file [" + this.propertiesFilePath + "]", (Throwable)se);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public void setProperty(String propertyName, String propvalue) {
        this.properties.setProperty(propertyName, propvalue);
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public void storeProperties() {
        try {
            this.storeProperties(this.propertiesFilePath);
        }
        catch (NullPointerException npe) {
            logger.error("NullPointerException on storeProperties().", (Throwable)npe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProperties(String propertiesFilePath) throws NullPointerException {
        block17: {
            File propertiesFileObject = new File(propertiesFilePath);
            File propertiesFileFolder = propertiesFileObject.getParentFile();
            if (!propertiesFileFolder.exists()) {
                propertiesFileFolder.mkdirs();
                propertiesFileFolder = null;
            }
            try {
                if (new File(this.propertiesFilePath).exists()) {
                    ArrayList<String> bufferList = new ArrayList<String>();
                    String lineReaded = null;
                    BufferedReader buffered = new BufferedReader(new FileReader(this.propertiesFilePath));
                    int position = 0;
                    ArrayList<String> allProperties = new ArrayList<String>();
                    EnumerationIterator allPropertiesEnumeration = new EnumerationIterator(this.properties.propertyNames());
                    while (allPropertiesEnumeration.hasNext()) {
                        allProperties.add((String)allPropertiesEnumeration.next());
                    }
                    while ((lineReaded = buffered.readLine()) != null) {
                        try {
                            lineReaded = lineReaded.replaceAll("\\t", "    ");
                            if (!lineReaded.trim().equals("") && !lineReaded.trim().substring(0, 1).equals("#")) {
                                boolean propertyFound = false;
                                Iterator propertyNames = allProperties.iterator();
                                while (propertyNames.hasNext() && !propertyFound) {
                                    String propertyName = (String)propertyNames.next();
                                    String propvalue = this.properties.getProperty(propertyName);
                                    if (lineReaded.indexOf(propertyName + " ") != 0 || (position = lineReaded.indexOf("=")) < 0) continue;
                                    propertyFound = true;
                                    StringBuilder thisLineBuffer = new StringBuilder();
                                    thisLineBuffer.append(lineReaded.substring(0, position + 1));
                                    thisLineBuffer.append("   ");
                                    thisLineBuffer.append(PropertiesManager.string2Property(propvalue));
                                    bufferList.add(thisLineBuffer.toString());
                                    allProperties.remove(propertyName);
                                }
                                continue;
                            }
                            bufferList.add(lineReaded.trim());
                        }
                        catch (IndexOutOfBoundsException propertyFound) {
                        }
                        catch (PatternSyntaxException ex1) {
                            logger.error(ex1.getMessage(), (Throwable)ex1);
                        }
                        catch (IllegalArgumentException ex2) {
                            logger.error(ex2.getMessage(), (Throwable)ex2);
                        }
                    }
                    for (String restantPropertyName : allProperties) {
                        StringBuilder specialLineBuffer = new StringBuilder();
                        specialLineBuffer.append(restantPropertyName);
                        for (int i = 0; i < 55 - restantPropertyName.length(); ++i) {
                            specialLineBuffer.append(" ");
                        }
                        specialLineBuffer.append("=   ");
                        specialLineBuffer.append(this.properties.getProperty(restantPropertyName));
                        bufferList.add(specialLineBuffer.toString());
                    }
                    buffered.close();
                    this.writeTheFile(propertiesFilePath, bufferList);
                    break block17;
                }
                try (FileOutputStream outputStream = new FileOutputStream(propertiesFileObject);){
                    this.properties.store(outputStream, "This file has been written by Jahia.");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeTheFile(String propertiesFilePath, List bufferList) {
        File thisFile = null;
        FileWriter fileWriter = null;
        StringBuilder outputBuffer = null;
        try {
            thisFile = new File(propertiesFilePath);
            fileWriter = new FileWriter(thisFile);
            outputBuffer = new StringBuilder();
            for (int i = 0; i < bufferList.size(); ++i) {
                outputBuffer.append((String)bufferList.get(i));
                outputBuffer.append("\n");
            }
            fileWriter.write(outputBuffer.toString());
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(fileWriter);
            fileWriter = null;
            thisFile = null;
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                fileWriter = null;
                thisFile = null;
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        fileWriter = null;
        thisFile = null;
    }

    public Properties getPropertiesObject() {
        return this.properties;
    }

    public static String string2Property(String originalValue) {
        StringBuilder convertedValue = new StringBuilder();
        for (int i = 0; i < originalValue.length(); ++i) {
            if (originalValue.substring(i, i + 1).equals(":")) {
                convertedValue.append("\\:");
                continue;
            }
            if (originalValue.substring(i, i + 1).equals("\\")) {
                convertedValue.append("\\\\");
                continue;
            }
            convertedValue.append(originalValue.substring(i, i + 1));
        }
        return convertedValue.toString();
    }
}

