/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RangeUtils {
    private static int inputBufferSize = 2048;
    private static int output = 2048;
    public static final List<Range> FULL = new ArrayList<Range>();
    public static final String MIME_SEPARATION = "CATALINA_MIME_BOUNDARY";

    public static List<Range> parseRange(HttpServletRequest request, HttpServletResponse response, String eTag, long lastModified, long fileLength) throws IOException {
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = request.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (headerValueTime == -1L ? !eTag.equals(headerValue.trim()) : lastModified > headerValueTime + 1000L) {
                return FULL;
            }
        }
        if (fileLength == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.addHeader("Content-Range", "bytes */" + fileLength);
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    public static void copy(InputStream resourceInputStream, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, inputBufferSize);
        exception = RangeUtils.copyRange(istream, ostream, range.start, range.end);
        ((InputStream)istream).close();
        if (exception != null) {
            throw exception;
        }
    }

    public static void copy(InputStream resourceInputStream, ServletOutputStream ostream, Iterator<Range> ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, inputBufferSize);
            Range currentRange = ranges.next();
            ostream.println();
            ostream.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            ostream.println();
            exception = RangeUtils.copyRange(istream, ostream, currentRange.start, currentRange.end);
            ((InputStream)istream).close();
        }
        ostream.println();
        ostream.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    public static IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[inputBufferSize];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    public static int getInputBufferSize() {
        return inputBufferSize;
    }

    public static void setInputBufferSize(int inputBufferSize) {
        RangeUtils.inputBufferSize = inputBufferSize;
    }

    public static int getOutput() {
        return output;
    }

    public static void setOutput(int output) {
        RangeUtils.output = output;
    }

    public static class Range {
        public long start;
        public long end;
        public long length;

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }

        public void recycle() {
            this.start = 0L;
            this.end = 0L;
            this.length = 0L;
        }
    }
}

