/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryObjectModelImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaLuceneQueryFactoryImpl;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.join.JahiaQueryEngine;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.core.stats.RepositoryStatisticsImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaQueryObjectModelImpl
extends QueryObjectModelImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryObjectModelImpl.class);

    public void init(SessionContext sessionContext, QueryHandler handler, QueryObjectModelTree qomTree, String language, Node node) throws InvalidQueryException, RepositoryException {
        super.init(sessionContext, handler, qomTree, language, node);
        this.lqf = new JahiaLuceneQueryFactoryImpl(sessionContext.getSessionImpl(), (SearchIndex)handler, this.variables);
    }

    public QueryResult execute() throws RepositoryException {
        long time = System.nanoTime();
        QueryResult result = (QueryResult)this.sessionContext.getSessionState().perform((SessionOperation)new SessionOperation<QueryResult>(){

            public QueryResult perform(SessionContext context) throws RepositoryException {
                JahiaQueryEngine engine = new JahiaQueryEngine((Session)JahiaQueryObjectModelImpl.this.sessionContext.getSessionImpl(), JahiaQueryObjectModelImpl.this.lqf, JahiaQueryObjectModelImpl.this.variables);
                return engine.execute(JahiaQueryObjectModelImpl.this.getColumns(), JahiaQueryObjectModelImpl.this.getSource(), JahiaQueryObjectModelImpl.this.getConstraint(), JahiaQueryObjectModelImpl.this.getOrderings(), JahiaQueryObjectModelImpl.this.offset, JahiaQueryObjectModelImpl.this.limit);
            }

            public String toString() {
                return "query.execute(" + JahiaQueryObjectModelImpl.this.statement + ")";
            }
        });
        time = System.nanoTime() - time;
        long timeMs = time / 1000000L;
        log.debug("executed in {} ms. ({})", (Object)timeMs, (Object)this.statement);
        RepositoryStatisticsImpl statistics = this.sessionContext.getRepositoryContext().getRepositoryStatistics();
        statistics.getCounter(RepositoryStatistics.Type.QUERY_COUNT).incrementAndGet();
        statistics.getCounter(RepositoryStatistics.Type.QUERY_DURATION).addAndGet(timeMs);
        this.sessionContext.getRepositoryContext().getStatManager().getQueryStat().logQuery(this.language, this.statement, timeMs);
        return result;
    }

    public LuceneQueryFactory getLuceneQueryFactory() {
        return this.lqf;
    }
}

