/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.qom.QueryObjectModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.JahiaSearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.JahiaQueryObjectModelImpl;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.AnalyzerRegistry;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.IndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.JackrabbitAnalyzer;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.JahiaFilterMultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.JahiaIndexingConfigurationImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.JahiaQueryImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaSecondaryIndex;
import org.apache.jackrabbit.core.query.lucene.LanguageCustomizingAnalyzerRegistry;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.Ordering;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SpellChecker;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.NoDuplicatesConstraint;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.QueryNodeFactory;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.tika.parser.Parser;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.search.spell.CompositeSpellChecker;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.DateUtils;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaSearchIndex
extends SearchIndex {
    private static final Logger log = LoggerFactory.getLogger(JahiaSearchIndex.class);
    private static final Name JNT_ACL = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/nt/1.0", "acl");
    private static final Name JNT_ACE = NameFactoryImpl.getInstance().create("http://www.jahia.org/jahia/nt/1.0", "ace");
    public static final String SKIP_VERSION_INDEX_SYSTEM_PROPERTY = "jahia.jackrabbit.searchIndex.skipVersionIndex";
    public static final boolean SKIP_VERSION_INDEX = Boolean.valueOf(System.getProperty("jahia.jackrabbit.searchIndex.skipVersionIndex", "true"));
    private Boolean versionIndex;
    private int maxClauseCount = 1024;
    private int batchSize = 100;
    private boolean addAclUuidInIndex = true;
    private Set<String> typesUsingOptimizedACEIndexation = new HashSet<String>();
    private Set<Name> ignoredTypes;
    private String ignoredTypesString;
    private volatile boolean switching = false;
    private int defaultWaitTime = 500;
    private volatile JahiaSecondaryIndex newIndex;

    public static boolean isAclUuidInIndex(SearchIndex index) {
        return index instanceof JahiaSearchIndex && ((JahiaSearchIndex)index).isAddAclUuidInIndex();
    }

    public int getMaxClauseCount() {
        return this.maxClauseCount;
    }

    public void setMaxClauseCount(int maxClauseCount) {
        this.maxClauseCount = maxClauseCount;
        BooleanQuery.setMaxClauseCount((int)maxClauseCount);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isAddAclUuidInIndex() {
        return this.addAclUuidInIndex;
    }

    public void setAddAclUuidInIndex(boolean addAclUuidInIndex) {
        this.addAclUuidInIndex = addAclUuidInIndex;
    }

    public Set<String> getTypesUsingOptimizedACEIndexation() {
        return this.typesUsingOptimizedACEIndexation;
    }

    public void setTypesUsingOptimizedACEIndexation(String typesUsingOptimizedACEIndexation) {
        this.typesUsingOptimizedACEIndexation = Sets.newHashSet((Object[])StringUtils.split((String)typesUsingOptimizedACEIndexation));
    }

    public void setIgnoredTypes(String ignoredTypes) {
        this.ignoredTypesString = ignoredTypes;
    }

    public int getDefaultWaitTime() {
        return this.defaultWaitTime;
    }

    public void setDefaultWaitTime(int defaultWaitTime) {
        this.defaultWaitTime = defaultWaitTime;
    }

    protected void doInit() throws IOException {
        HashSet<Name> ignoredTypes = new HashSet<Name>();
        NameFactory nf = NameFactoryImpl.getInstance();
        if (SKIP_VERSION_INDEX && this.isVersionIndex()) {
            ignoredTypes.add(nf.create("internal", "versionStorage"));
            ignoredTypes.add(nf.create("http://www.jcp.org/jcr/nt/1.0", "versionHistory"));
            ignoredTypes.add(nf.create("http://www.jcp.org/jcr/nt/1.0", "version"));
            ignoredTypes.add(nf.create("http://www.jcp.org/jcr/nt/1.0", "versionLabels"));
            ignoredTypes.add(nf.create("http://www.jcp.org/jcr/nt/1.0", "frozenNode"));
            ignoredTypes.add(nf.create("http://www.jcp.org/jcr/nt/1.0", "versionedChild"));
        }
        if (this.ignoredTypesString != null) {
            for (String s : StringUtils.split((String)this.ignoredTypesString, (String)", ")) {
                try {
                    if (!s.startsWith("{")) {
                        try {
                            ignoredTypes.add(nf.create(this.getContext().getNamespaceRegistry().getURI(StringUtils.substringBefore((String)s, (String)":")), StringUtils.substringAfter((String)s, (String)":")));
                        }
                        catch (NamespaceException e) {
                            log.error("Cannot parse namespace for " + s, (Throwable)e);
                        }
                        continue;
                    }
                    ignoredTypes.add(nf.create(s));
                }
                catch (IllegalArgumentException iae) {
                    log.error("Illegal node type name: " + s, (Throwable)iae);
                }
            }
        }
        this.ignoredTypes = ignoredTypes.isEmpty() ? null : ignoredTypes;
        super.doInit();
    }

    protected AnalyzerRegistry getAnalyzerRegistry() {
        IndexingConfiguration indexingConfig = this.getIndexingConfig();
        if (indexingConfig instanceof JahiaIndexingConfigurationImpl) {
            JahiaIndexingConfigurationImpl config = (JahiaIndexingConfigurationImpl)indexingConfig;
            return config.getAnalyzerRegistry();
        }
        return super.getAnalyzerRegistry();
    }

    protected IndexingConfiguration createIndexingConfiguration(NamespaceMappings namespaceMappings) {
        IndexingConfiguration configuration = super.createIndexingConfiguration(namespaceMappings);
        if (configuration instanceof JahiaIndexingConfigurationImpl) {
            JahiaIndexingConfigurationImpl jahiaConfiguration = (JahiaIndexingConfigurationImpl)configuration;
            LanguageCustomizingAnalyzerRegistry registry = jahiaConfiguration.getAnalyzerRegistry();
            Analyzer analyzer = super.getTextAnalyzer();
            registry.setDefaultAnalyzer(analyzer);
            SettingsBean settings = SettingsBean.getInstance();
            Locale defaultLocale = settings.getDefaultLocale();
            Analyzer specific = registry.getAnalyzer(defaultLocale.toString());
            if (specific == null) {
                specific = registry.getAnalyzer(defaultLocale.getLanguage());
            }
            if (specific != null) {
                if (analyzer instanceof JackrabbitAnalyzer) {
                    JackrabbitAnalyzer jrAnalyzer = (JackrabbitAnalyzer)analyzer;
                    jrAnalyzer.setDefaultAnalyzer(specific);
                } else {
                    throw new IllegalArgumentException("Analyzer wasn't a JackrabbitAnalyzer. Couldn't set default language Analyzer as a consequence.");
                }
            }
        }
        return configuration;
    }

    private void waitForIndexSwitch() {
        while (this.switching) {
            try {
                Thread.sleep(this.defaultWaitTime);
            }
            catch (InterruptedException e) {
                log.error("Interrupted", (Throwable)e);
            }
        }
    }

    protected IndexReader getIndexReader(boolean includeSystemIndex) throws IOException {
        this.waitForIndexSwitch();
        return super.getIndexReader(includeSystemIndex);
    }

    public void updateNodes(Iterator<NodeId> remove, Iterator<NodeState> add) throws RepositoryException, IOException {
        this.updateNodes(remove, add, true);
    }

    void updateNodes(Iterator<NodeId> remove, Iterator<NodeState> add, boolean waitForIndexSwitch) throws RepositoryException, IOException {
        long timer;
        boolean debugEnabled;
        ArrayList<NodeId> aclChangedList;
        HashSet<NodeId> addedIds;
        HashSet<NodeId> removedIds;
        ArrayList<NodeId> removeList;
        ArrayList<NodeState> addList;
        block27: {
            if (waitForIndexSwitch) {
                this.waitForIndexSwitch();
                if (this.ignoredTypes != null && add.hasNext()) {
                    LinkedList<NodeState> l = null;
                    while (add.hasNext()) {
                        NodeState state = add.next();
                        if (state == null || this.ignoredTypes.contains(state.getNodeTypeName())) continue;
                        if (l == null) {
                            l = new LinkedList<NodeState>();
                        }
                        l.add(state);
                    }
                    Iterator<Object> iterator = add = l != null ? l.iterator() : Collections.emptyIterator();
                }
                if (this.newIndex != null) {
                    this.newIndex.addDelayedUpdated(remove, add);
                }
            }
            if (this.isVersionIndex()) {
                super.updateNodes(remove, add);
                return;
            }
            addList = new ArrayList<NodeState>();
            removeList = new ArrayList<NodeId>();
            removedIds = new HashSet<NodeId>();
            addedIds = new HashSet<NodeId>();
            aclChangedList = new ArrayList<NodeId>();
            HashSet<NodeId> topIdsRecursedForAcl = new HashSet<NodeId>();
            boolean hasAclOrAce = false;
            while (add.hasNext()) {
                NodeState state = (NodeState)add.next();
                if (state == null) continue;
                addedIds.add(state.getNodeId());
                addList.add(state);
                if (hasAclOrAce || !JNT_ACL.equals(state.getNodeTypeName()) && !JNT_ACE.equals(state.getNodeTypeName())) continue;
                hasAclOrAce = true;
            }
            while (remove.hasNext()) {
                NodeId nodeId = remove.next();
                removedIds.add(nodeId);
                removeList.add(nodeId);
            }
            debugEnabled = log.isDebugEnabled();
            if (this.isAddAclUuidInIndex() && hasAclOrAce) {
                ItemStateManager itemStateManager = this.getContext().getItemStateManager();
                for (NodeState node : new ArrayList(addList)) {
                    try {
                        NodeState acl;
                        NodeState nodeParent;
                        Event event = null;
                        if (add instanceof JahiaSearchManager.NodeStateIterator && (event = ((JahiaSearchManager.NodeStateIterator)add).getEvent(node.getNodeId())) != null && event.getType() != 1 && event.getType() != 2 && (!JNT_ACL.equals(node.getNodeTypeName()) || !event.getPath().endsWith("/j:inherit"))) continue;
                        if (JNT_ACL.equals(node.getNodeTypeName())) {
                            NodeState nodeParent2 = (NodeState)itemStateManager.getItemState((ItemId)node.getParentId());
                            this.addIdToBeIndexed(nodeParent2.getNodeId(), addedIds, removedIds, addList, removeList);
                            if (!topIdsRecursedForAcl.contains(nodeParent2.getNodeId()) && !aclChangedList.contains(nodeParent2.getNodeId())) {
                                long startTime = debugEnabled ? System.currentTimeMillis() : 0L;
                                this.recurseTreeForAclIdSetting(nodeParent2, addedIds, removedIds, aclChangedList, itemStateManager);
                                topIdsRecursedForAcl.add(node.getParentId());
                                if (debugEnabled) {
                                    log.debug("ACL updated {}. Recursed down the JCR tree to update the index in {} ms.", (Object)(event != null ? event.getPath() : nodeParent2.getId()), (Object)(System.currentTimeMillis() - startTime));
                                }
                            }
                        }
                        if (!JNT_ACE.equals(node.getNodeTypeName()) || !this.canUseOptimizedACEIndexation(nodeParent = (NodeState)itemStateManager.getItemState((ItemId)(acl = (NodeState)itemStateManager.getItemState((ItemId)node.getParentId())).getParentId()))) continue;
                        this.addIdToBeIndexed(nodeParent.getNodeId(), addedIds, removedIds, addList, removeList);
                        if (topIdsRecursedForAcl.contains(nodeParent.getNodeId()) || aclChangedList.contains(nodeParent.getNodeId())) continue;
                        long startTime = debugEnabled ? System.currentTimeMillis() : 0L;
                        this.recurseTreeForAclIdSetting(nodeParent, addedIds, removedIds, aclChangedList, itemStateManager);
                        topIdsRecursedForAcl.add(node.getParentId());
                        if (!debugEnabled) continue;
                        log.debug("ACE entry updated: {}. Recursed down the JCR tree to update the index in {} ms.", (Object)(event != null ? event.getPath() : nodeParent.getId()), (Object)(System.currentTimeMillis() - startTime));
                    }
                    catch (RepositoryException | ItemStateException e) {
                        log.warn("ACL_UUID field in documents may not be updated, so access rights check in search may not work correctly", e);
                    }
                }
            }
            timer = System.currentTimeMillis();
            try {
                super.updateNodes(removeList.iterator(), addList.iterator());
            }
            catch (AlreadyClosedException e) {
                if (this.switching) break block27;
                throw e;
            }
        }
        if (debugEnabled) {
            log.debug("Re-indexed nodes in {} ms: {} removed, {} added", new Object[]{System.currentTimeMillis() - timer, removeList.size(), addList.size()});
        }
        if (!aclChangedList.isEmpty()) {
            int aclSubListEnd = Math.min(aclChangedList.size(), this.batchSize);
            for (int aclSubListStart = 0; aclSubListStart < aclChangedList.size(); aclSubListStart += this.batchSize) {
                block28: {
                    if (aclSubListStart > 0) {
                        Thread.yield();
                    }
                    ArrayList<NodeState> aclAddList = new ArrayList<NodeState>();
                    ArrayList<NodeId> aclRemoveList = new ArrayList<NodeId>();
                    for (NodeId node : aclChangedList.subList(aclSubListStart, aclSubListEnd)) {
                        try {
                            this.addIdToBeIndexed(node, addedIds, removedIds, aclAddList, aclRemoveList);
                        }
                        catch (ItemStateException e) {
                            log.warn("ACL_UUID field in document for nodeId '" + node.toString() + "' may not be updated, so access rights check in search may not work correctly", (Throwable)e);
                        }
                    }
                    try {
                        super.updateNodes(aclRemoveList.iterator(), aclAddList.iterator());
                    }
                    catch (AlreadyClosedException e) {
                        if (this.switching) break block28;
                        throw e;
                    }
                }
                aclSubListEnd = Math.min(aclChangedList.size(), aclSubListEnd + this.batchSize);
            }
            if (debugEnabled) {
                log.debug("Re-indexed {} nodes after ACL change in {} ms", new Object[]{aclChangedList.size(), System.currentTimeMillis() - timer});
            }
        }
    }

    private void recurseTreeForAclIdSetting(NodeState node, Set<NodeId> addedIds, Set<NodeId> removedIds, List<NodeId> aclChangedList, ItemStateManager itemStateManager) {
        for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries()) {
            try {
                PropertyId propId;
                PropertyState ps;
                NodeState childNode = (NodeState)this.getContext().getItemStateManager().getItemState((ItemId)childNodeEntry.getId());
                boolean breakInheritance = false;
                if (childNode.hasPropertyName(JahiaNodeIndexer.J_ACL_INHERITED) && (ps = (PropertyState)itemStateManager.getItemState((ItemId)(propId = new PropertyId((NodeId)childNode.getId(), JahiaNodeIndexer.J_ACL_INHERITED)))).getValues().length == 1 && ps.getValues()[0].getBoolean()) {
                    breakInheritance = true;
                }
                if (breakInheritance) continue;
                if (!addedIds.contains(childNodeEntry.getId()) && !removedIds.contains(childNodeEntry.getId())) {
                    aclChangedList.add(childNodeEntry.getId());
                }
                this.recurseTreeForAclIdSetting(childNode, addedIds, removedIds, aclChangedList, itemStateManager);
            }
            catch (ItemStateException e) {
                log.warn("ACL_UUID field in document for nodeId '{}' may not be updated, so access rights check in search may not work correctly", (Object)childNodeEntry.getId().toString());
                log.debug("Exception when checking for creating ACL_UUID in index", (Throwable)e);
            }
            catch (RepositoryException e) {
                log.warn("ACL_UUID field in document for nodeId '{}' may not be updated, so access rights check in search may not work correctly", (Object)childNodeEntry.getId().toString());
                log.debug("Exception when checking for creating ACL_UUID in index", (Throwable)e);
            }
        }
    }

    private void addIdToBeIndexed(NodeId id, Set<NodeId> addedIds, Set<NodeId> removedIds, List<NodeState> addList, List<NodeId> removeList) throws ItemStateException {
        if (!removedIds.contains(id) && !addedIds.contains(id)) {
            removeList.add(id);
            removedIds.add(id);
        }
        if (!addedIds.contains(id) && this.getContext().getItemStateManager().hasItemState((ItemId)id)) {
            addList.add((NodeState)this.getContext().getItemStateManager().getItemState((ItemId)id));
            addedIds.add(id);
        }
    }

    protected Document createDocument(NodeState node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        if (this.getIndexingConfig() instanceof JahiaIndexingConfigurationImpl && !((JahiaIndexingConfigurationImpl)this.getIndexingConfig()).getExcludesTypesByPath().isEmpty() && this.isNodeExcluded(node)) {
            return null;
        }
        JahiaNodeIndexer indexer = JahiaNodeIndexer.createNodeIndexer(node, this.getContext().getItemStateManager(), nsMappings, this.getContext().getExecutor(), this.getParser(), this.getContext());
        indexer.setSupportHighlighting(this.getSupportHighlighting());
        indexer.setIndexingConfiguration(this.getIndexingConfig());
        indexer.setIndexFormatVersion(indexFormatVersion);
        indexer.setMaxExtractLength(this.getMaxExtractLength());
        indexer.setSupportSpellchecking(this.getSpellCheckerClass() != null);
        indexer.setAddAclUuidInIndex(this.addAclUuidInIndex);
        indexer.setUseOptimizedACEIndexation(this.canUseOptimizedACEIndexation(node));
        Document doc = indexer.createDoc();
        this.mergeAggregatedNodeIndexes(node, doc, indexFormatVersion);
        return doc;
    }

    protected boolean isNodeExcluded(NodeState node) throws RepositoryException {
        try {
            String nodeTypeName = JahiaNodeIndexer.getTypeNameAsString(node.getNodeTypeName(), (NamespaceRegistry)this.getContext().getNamespaceRegistry());
            NodeState nodeToProcess = "jnt:translation".equals(nodeTypeName) ? (NodeState)this.getContext().getItemStateManager().getItemState((ItemId)node.getParentId()) : node;
            String localPath = null;
            for (JahiaIndexingConfigurationImpl.ExcludedType excludedType : ((JahiaIndexingConfigurationImpl)this.getIndexingConfig()).getExcludesTypesByPath()) {
                if (!excludedType.matchesNodeType(nodeToProcess)) continue;
                if (localPath == null) {
                    localPath = StringUtils.remove((String)this.getNamespaceMappings().translatePath(this.getContext().getHierarchyManager().getPath(nodeToProcess.getId()).getNormalizedPath()), (String)"0:");
                }
                if (!excludedType.matchPath(localPath)) continue;
                return true;
            }
        }
        catch (ItemStateException e) {
            log.debug("While indexing translation node unable to get its parent item", (Throwable)e);
            return true;
        }
        return false;
    }

    private boolean canUseOptimizedACEIndexation(NodeState currentNode) throws RepositoryException {
        ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(JahiaNodeIndexer.getTypeNameAsString(currentNode.getNodeTypeName(), (NamespaceRegistry)this.getContext().getNamespaceRegistry()));
        for (String type : this.typesUsingOptimizedACEIndexation) {
            if (!nodeType.isNodeType(type)) continue;
            return true;
        }
        return false;
    }

    public QueryObjectModel createQueryObjectModel(SessionContext sessionContext, QueryObjectModelTree qomTree, String language, Node node) throws RepositoryException {
        JahiaQueryObjectModelImpl query = new JahiaQueryObjectModelImpl();
        query.init(sessionContext, (QueryHandler)this, qomTree, language, node);
        return query;
    }

    public ExecutableQuery createExecutableQuery(SessionContext sessionContext, String statement, String language) throws InvalidQueryException {
        JahiaQueryImpl query = new JahiaQueryImpl(sessionContext, this, this.getContext().getPropertyTypeRegistry(), statement, language, (QueryNodeFactory)this.getQueryNodeFactory());
        query.setConstraint(new NoDuplicatesConstraint());
        query.setRespectDocumentOrder(this.getRespectDocumentOrder());
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<NodeId> getWeaklyReferringNodes(NodeId id) throws RepositoryException, IOException {
        final ArrayList docs = new ArrayList();
        ArrayList<NodeId> ids = new ArrayList<NodeId>();
        IndexReader reader = this.getIndexReader(false);
        try {
            try (IndexSearcher searcher = new IndexSearcher(reader);){
                TermQuery q = new TermQuery(new Term(FieldNames.WEAK_REFS, id.toString()));
                searcher.search((Query)q, (Collector)new AbstractHitCollector(){

                    public void collect(int doc, float score) {
                        docs.add(doc);
                    }
                });
            }
            for (Integer doc : docs) {
                Document d = reader.document(doc.intValue(), FieldSelectors.UUID);
                ids.add(new NodeId(d.get(FieldNames.UUID)));
            }
        }
        finally {
            Util.closeOrRelease((IndexReader)reader);
        }
        return ids;
    }

    private boolean isVersionIndex() {
        if (this.versionIndex == null) {
            this.versionIndex = this.getIndexingConfigurationClass().equals(IndexingConfigurationImpl.class.getName());
        }
        return this.versionIndex;
    }

    protected Parser createParser() {
        return null;
    }

    public synchronized boolean prepareReindexing() {
        if (this.newIndex != null || this.switching) {
            return false;
        }
        this.newIndex = new JahiaSecondaryIndex(this);
        return true;
    }

    public void scheduleReindexing() {
        if (!this.prepareReindexing()) {
            return;
        }
        JobDetail jobDetail = BackgroundJob.createJahiaJob("Re-indexing of the " + StringUtils.defaultIfEmpty((String)this.getContext().getWorkspace(), (String)"system") + " workspace content", ReindexJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put((Object)"index", (Object)this);
        try {
            ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail, true);
        }
        catch (SchedulerException e) {
            log.error("Unable to schedule background job for re-indexing", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reindexAndSwitch() throws RepositoryException, IOException {
        long startTime = System.currentTimeMillis();
        File dest = new File(this.getPath() + ".old." + System.currentTimeMillis());
        FileUtils.deleteQuietly((File)new File(this.newIndex.getPath()));
        String workspace = StringUtils.defaultIfEmpty((String)this.getContext().getWorkspace(), (String)"system");
        log.info("Start initializing new index for {} workspace", (Object)workspace);
        this.newIndex.newIndexInit();
        log.info("New index for workspace {} initialized in {} ms", (Object)workspace, (Object)(System.currentTimeMillis() - startTime));
        this.newIndex.replayDelayedUpdates(this.newIndex);
        log.info("Reindexing has finished for {} workspace, switching to new index...", (Object)workspace);
        long startTimeIntern = System.currentTimeMillis();
        try {
            this.switching = true;
            this.quietClose(this.newIndex);
            this.quietClose(this);
            if (!new File(this.getPath()).renameTo(dest)) {
                throw new IOException("Unable to rename the existing index folder " + this.getPath());
            }
            if (!new File(this.newIndex.getPath()).renameTo(new File(this.getPath()))) {
                log.info("Restored original index");
                dest.renameTo(new File(this.getPath()));
                throw new IOException("Unable to rename the newly created index folder " + this.newIndex.getPath());
            }
            log.info("New index deployed, reloading {}", (Object)this.getPath());
            this.init(this.fs, this.getContext());
            this.newIndex.replayDelayedUpdates(this);
            log.info("New index ready");
        }
        finally {
            this.newIndex = null;
            this.switching = false;
        }
        log.info("Switched to newly created index in {} ms", (Object)(System.currentTimeMillis() - startTimeIntern));
        FileUtils.deleteQuietly((File)dest);
        SpellChecker spellChecker = this.getSpellChecker();
        if (spellChecker instanceof CompositeSpellChecker) {
            ((CompositeSpellChecker)spellChecker).updateIndex(false);
            log.info("Triggered update of the spellchecker index");
        }
        log.info("Re-indexing operation is completed for {} workspace in {}", (Object)workspace, (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - startTime));
    }

    private void quietClose(JahiaSearchIndex index) {
        try {
            if (index.getSpellChecker() != null) {
                index.getSpellChecker().close();
            }
        }
        catch (Exception e) {
            log.warn("Unable to close spell checker", (Throwable)e);
        }
        try {
            index.index.close();
        }
        catch (Exception e) {
            log.warn("Unable to close index", (Throwable)e);
        }
    }

    public void reindexTree(String startNodeId) throws RepositoryException, NoSuchItemStateException, IllegalArgumentException, ItemStateException, IOException {
        long startTime = System.currentTimeMillis();
        log.info("Requested re-indexing of the JCR tree for node {}", (Object)startNodeId);
        ItemStateManager stateManager = this.getContext().getItemStateManager();
        LinkedList<NodeState> nodes = new LinkedList<NodeState>();
        JahiaSearchIndex.collectChildren((NodeState)stateManager.getItemState((ItemId)NodeId.valueOf((String)startNodeId)), stateManager, nodes);
        int totalCount = nodes.size();
        log.info("Collected {} node IDs to be re-indexed", (Object)totalCount);
        LinkedList<NodeId> removed = new LinkedList<NodeId>();
        for (NodeState n : nodes) {
            removed.add(n.getNodeId());
        }
        if (totalCount > this.batchSize) {
            log.info("Will process re-indexig of nodes in batches of {} nodes", (Object)this.batchSize);
            int listEnd = Math.min(totalCount, this.batchSize);
            for (int listStart = 0; listStart < totalCount; listStart += this.batchSize) {
                if (listStart > 0) {
                    Thread.yield();
                }
                super.updateNodes(removed.subList(listStart, listEnd).iterator(), nodes.subList(listStart, listEnd).iterator());
                if (listEnd % (10 * this.batchSize) == 0) {
                    log.info("Re-indexed {} nodes out of {}", (Object)listEnd, (Object)totalCount);
                }
                listEnd = Math.min(totalCount, listEnd + this.batchSize);
            }
        } else {
            super.updateNodes(removed.iterator(), nodes.iterator());
        }
        log.info("Done re-indexed JCR sub-tree for node {} in {} ms", (Object)startNodeId, (Object)(System.currentTimeMillis() - startTime));
    }

    private static void collectChildren(NodeState startNode, ItemStateManager stateManager, List<NodeState> nodes) {
        nodes.add(startNode);
        for (ChildNodeEntry child : startNode.getChildNodeEntries()) {
            try {
                JahiaSearchIndex.collectChildren((NodeState)stateManager.getItemState((ItemId)child.getId()), stateManager, nodes);
            }
            catch (ItemStateException e) {
                log.warn("Unable to obtain state for the node " + child.getId() + ". Cause: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public MultiColumnQueryHits executeQuery(SessionImpl session, AbstractQueryImpl queryImpl, Query query, Path[] orderProps, boolean[] orderSpecs, String[] orderFuncs, long resultFetchHint) throws IOException {
        this.checkOpen();
        Sort sort = new Sort(this.createSortFields(orderProps, orderSpecs, orderFuncs));
        final IndexReader reader = this.getIndexReader(queryImpl.needsSystemTree());
        JackrabbitIndexSearcher searcher = new JackrabbitIndexSearcher(session, reader, this.getContext().getItemStateManager());
        searcher.setSimilarity(this.getSimilarity());
        return new JahiaFilterMultiColumnQueryHits(searcher.execute(query, sort, resultFetchHint, QueryImpl.DEFAULT_SELECTOR_NAME), reader){

            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    Util.closeOrRelease((IndexReader)reader);
                }
            }
        };
    }

    public MultiColumnQueryHits executeQuery(SessionImpl session, MultiColumnQuery query, Ordering[] orderings, long resultFetchHint) throws IOException {
        this.checkOpen();
        final IndexReader reader = this.getIndexReader();
        JackrabbitIndexSearcher searcher = new JackrabbitIndexSearcher(session, reader, this.getContext().getItemStateManager());
        searcher.setSimilarity(this.getSimilarity());
        return new JahiaFilterMultiColumnQueryHits(query.execute(searcher, orderings, resultFetchHint), reader){

            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    Util.closeOrRelease((IndexReader)reader);
                }
            }
        };
    }

    public static class ReindexJob
    extends BackgroundJob
    implements StatefulJob {
        @Override
        public void executeJahiaJob(JobExecutionContext jobExecutionContext) throws Exception {
            JobDataMap map = jobExecutionContext.getJobDetail().getJobDataMap();
            JahiaSearchIndex index = (JahiaSearchIndex)((Object)map.get((Object)"index"));
            if (index != null) {
                index.reindexAndSwitch();
            } else {
                List indexes = (List)map.get((Object)"indexes");
                if (indexes != null) {
                    long start = System.currentTimeMillis();
                    for (JahiaSearchIndex searchIndex : indexes) {
                        searchIndex.reindexAndSwitch();
                    }
                    log.info("Re-indexing of the whole repository content took {}", (Object)DateUtils.formatDurationWords(System.currentTimeMillis() - start));
                }
            }
        }
    }
}

