/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.IndexReaderAware;
import org.apache.jackrabbit.core.query.lucene.JahiaLuceneQueryFactoryImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SingleColumnQueryResult;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaSingleColumnQueryResult
extends SingleColumnQueryResult {
    private static final FieldSelector ACL_FIELD_SELECTOR = new FieldSelector(){
        private static final long serialVersionUID = 2021640917456446047L;

        public FieldSelectorResult accept(String fieldName) {
            return JahiaNodeIndexer.ACL_UUID == fieldName ? FieldSelectorResult.LOAD : FieldSelectorResult.NO_LOAD;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(JahiaSingleColumnQueryResult.class);
    private Map<String, Boolean> checkedAcls;

    public JahiaSingleColumnQueryResult(SearchIndex index, SessionContext sessionContext, AbstractQueryImpl queryImpl, Query query, SpellSuggestion spellSuggestion, ColumnImpl[] columns, Path[] orderProps, boolean[] orderSpecs, String[] orderFuncs, boolean documentOrder, long offset, long limit) throws RepositoryException {
        super(index, sessionContext, queryImpl, query, spellSuggestion, columns, orderProps, orderSpecs, orderFuncs, documentOrder, offset, limit);
    }

    private boolean canRead(ScoreNode node, IndexReader indexReader) throws RepositoryException, IOException {
        String aclUuid;
        Field aclUuidField = indexReader.document(node.getDoc(indexReader), ACL_FIELD_SELECTOR).getField(JahiaNodeIndexer.ACL_UUID);
        String string = aclUuid = aclUuidField != null ? aclUuidField.stringValue() : null;
        if (aclUuid != null && aclUuid.length() == 0) {
            logger.warn("Empty ACL UUIDs in index for node: {}", (Object)node.getNodeId());
            aclUuid = null;
        }
        return JahiaLuceneQueryFactoryImpl.checkIndexedAcl(this.checkedAcls, aclUuid, this.sessionContext.getSessionImpl());
    }

    private boolean checkGranted(ScoreNode[] nodes, IndexReader indexReader) throws RepositoryException {
        for (ScoreNode node : nodes) {
            try {
                if (node == null || this.canRead(node, indexReader)) continue;
                return false;
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (IOException e) {
                logger.warn("Unable to read nodes's ACL UUID from index. Cause: " + e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    protected boolean isAccessGranted(ScoreNode[] nodes, MultiColumnQueryHits hits) throws RepositoryException {
        if (hits instanceof IndexReaderAware) {
            if (this.checkedAcls == null) {
                this.checkedAcls = new HashMap<String, Boolean>();
            }
            return this.checkGranted(nodes, ((IndexReaderAware)hits).getReader());
        }
        return super.isAccessGranted(nodes, hits);
    }
}

